/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.kyuubi;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.kyuubi.engine.spark.operation.progress.SparkOperationProgressStatus$;
import org.apache.kyuubi.engine.spark.operation.progress.SparkStage;
import org.apache.kyuubi.engine.spark.operation.progress.SparkStageProgress;
import org.apache.kyuubi.shaded.hive.service.rpc.thrift.TJobExecutionStatus;
import org.apache.spark.kyuubi.SparkProgressMonitor$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.status.AppStatusStore;
import org.apache.spark.status.api.v1.JobData;
import org.apache.spark.status.api.v1.StageStatus;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SortedMap$;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005%b\u0001B\u000b\u0017\u0001}A\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tY\u0001\u0011\t\u0011)A\u0005[!)\u0001\b\u0001C\u0001s!9a\b\u0001b\u0001\n\u0013y\u0004B\u0002$\u0001A\u0003%\u0001\t\u0003\u0005H\u0001!\u0015\r\u0011\"\u0003I\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015)\u0007\u0001\"\u0001g\u0011\u0015A\u0007\u0001\"\u0001j\u0011\u0015Q\u0007\u0001\"\u0001l\u0011\u0015y\u0007\u0001\"\u0001q\u0011\u0019y\b\u0001\"\u0003\u0002\u0002!9\u0011Q\u0003\u0001\u0005\n\u0005]qaBA\r-!\u0005\u00111\u0004\u0004\u0007+YA\t!!\b\t\razA\u0011AA\u0010\u0011!\t\tc\u0004b\u0001\n\u0013a\u0006bBA\u0012\u001f\u0001\u0006I!\u0018\u0005\n\u0003Ky!\u0019!C\u0005\u0003/A\u0001\"a\n\u0010A\u0003%\u00111\u0002\u0002\u0015'B\f'o\u001b)s_\u001e\u0014Xm]:N_:LGo\u001c:\u000b\u0005]A\u0012AB6zkV\u0014\u0017N\u0003\u0002\u001a5\u0005)1\u000f]1sW*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\u0011\u0011\u0005\u0005\"S\"\u0001\u0012\u000b\u0003\r\nQa]2bY\u0006L!!\n\u0012\u0003\r\u0005s\u0017PU3g!\t9#&D\u0001)\u0015\tI\u0003$A\u0002tc2L!a\u000b\u0015\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\u0002\u0011)|'m\u0012:pkB\u0004\"AL\u001b\u000f\u0005=\u001a\u0004C\u0001\u0019#\u001b\u0005\t$B\u0001\u001a\u001f\u0003\u0019a$o\\8u}%\u0011AGI\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025E\u00051A(\u001b8jiz\"2A\u000f\u001f>!\tY\u0004!D\u0001\u0017\u0011\u0015I2\u00011\u0001'\u0011\u0015a3\u00011\u0001.\u0003-\u0019H/\u0019;vgN#xN]3\u0016\u0003\u0001\u0003\"!\u0011#\u000e\u0003\tS!a\u0011\r\u0002\rM$\u0018\r^;t\u0013\t)%I\u0001\bBaB\u001cF/\u0019;vgN#xN]3\u0002\u0019M$\u0018\r^;t'R|'/\u001a\u0011\u0002\u0017A\u0014xn\u001a:fgNl\u0015\r]\u000b\u0002\u0013B!aF\u0013'Y\u0013\tYuGA\u0002NCB\u0004\"!\u0014,\u000e\u00039S!a\u0014)\u0002\u0011A\u0014xn\u001a:fgNT!!\u0015*\u0002\u0013=\u0004XM]1uS>t'BA\rT\u0015\t!V+\u0001\u0004f]\u001eLg.\u001a\u0006\u0003/iI!a\u0016(\u0003\u0015M\u0003\u0018M]6Ti\u0006<W\r\u0005\u0002N3&\u0011!L\u0014\u0002\u0013'B\f'o[*uC\u001e,\u0007K]8he\u0016\u001c8/A\u0004iK\u0006$WM]:\u0016\u0003u\u00032AX2.\u001b\u0005y&B\u00011b\u0003\u0011)H/\u001b7\u000b\u0003\t\fAA[1wC&\u0011Am\u0018\u0002\u0005\u0019&\u001cH/\u0001\u0003s_^\u001cX#A4\u0011\u0007y\u001bW,A\u0007g_>$XM]*v[6\f'/_\u000b\u0002[\u0005!\u0002O]8he\u0016\u001c8/\u001a3QKJ\u001cWM\u001c;bO\u0016,\u0012\u0001\u001c\t\u0003C5L!A\u001c\u0012\u0003\r\u0011{WO\u00197f\u0003=)\u00070Z2vi&|gn\u0015;biV\u001cX#A9\u0011\u0005IlX\"A:\u000b\u0005Q,\u0018A\u0002;ie&4GO\u0003\u0002wo\u0006\u0019!\u000f]2\u000b\u0005aL\u0018aB:feZL7-\u001a\u0006\u0003un\fA\u0001[5wK*\u0011A0V\u0001\u0007g\"\fG-\u001a3\n\u0005y\u001c(a\u0005+K_\n,\u00050Z2vi&|gn\u0015;biV\u001c\u0018aE4fi:\u000bW.Z,ji\"\u0004&o\\4sKN\u001cHcB\u0017\u0002\u0004\u0005\u001d\u0011\u0011\u0003\u0005\u0007\u0003\u000ba\u0001\u0019A\u0017\u0002\u0003MDq!!\u0003\r\u0001\u0004\tY!\u0001\u0005d_6\u0004H.\u001a;f!\r\t\u0013QB\u0005\u0004\u0003\u001f\u0011#aA%oi\"9\u00111\u0003\u0007A\u0002\u0005-\u0011!\u0002;pi\u0006d\u0017AE4fi\u000e{W\u000e\u001d7fi\u0016$7\u000b^1hKN,\"!a\u0003\u0002)M\u0003\u0018M]6Qe><'/Z:t\u001b>t\u0017\u000e^8s!\tYtb\u0005\u0002\u0010AQ\u0011\u00111D\u0001\b\u0011\u0016\u000bE)\u0012*T\u0003!AU)\u0011#F%N\u0003\u0013AD\"P\u0019VkejX\u0019`/&#E\u000bS\u0001\u0010\u0007>cU+\u0014(`c};\u0016\n\u0012+IA\u0001")
public class SparkProgressMonitor {
    private Map<SparkStage, SparkStageProgress> progressMap;
    private final String jobGroup;
    private final AppStatusStore statusStore;
    private volatile boolean bitmap$0;

    private AppStatusStore statusStore() {
        return this.statusStore;
    }

    private Map<SparkStage, SparkStageProgress> progressMap$lzycompute() {
        SparkProgressMonitor sparkProgressMonitor = this;
        synchronized (sparkProgressMonitor) {
            if (!this.bitmap$0) {
                Seq stages = (Seq)((IterableOps)((IterableOps)((IterableOps)this.statusStore().jobsList(null).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SparkProgressMonitor.$anonfun$progressMap$1(this, x$1)))).flatMap((Function1 & Serializable)x$2 -> x$2.stageIds())).flatMap((Function1 & Serializable)stageId -> SparkProgressMonitor.$anonfun$progressMap$3(this, BoxesRunTime.unboxToInt((Object)stageId)))).map((Function1 & Serializable)stage -> {
                    SparkStage sparkStage = new SparkStage(stage.stageId(), stage.attemptId());
                    StageStatus stageStatus = stage.status();
                    StageStatus stageStatus2 = StageStatus.SKIPPED;
                    int completedTasksCount = !(stageStatus != null ? !stageStatus.equals(stageStatus2) : stageStatus2 != null) ? stage.numTasks() : stage.numCompleteTasks();
                    SparkStageProgress sparkStageProgress = new SparkStageProgress(stage.numTasks(), completedTasksCount, stage.numActiveTasks(), stage.numFailedTasks());
                    return new Tuple2((Object)sparkStage, (Object)sparkStageProgress);
                });
                this.progressMap = (Map)SortedMap$.MODULE$.apply(stages, Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
                this.bitmap$0 = true;
            }
        }
        return this.progressMap;
    }

    private Map<SparkStage, SparkStageProgress> progressMap() {
        return !this.bitmap$0 ? this.progressMap$lzycompute() : this.progressMap;
    }

    public List<String> headers() {
        return SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$HEADERS();
    }

    public List<List<String>> rows() {
        Collection progressRows = JavaConverters$.MODULE$.asJavaCollectionConverter((Iterable)((IterableOnceOps)this.progressMap().map((Function1 & Serializable)x0$1 -> {
            Enumeration.Value state;
            int failed;
            int running;
            int total;
            int complete;
            SparkStage stage;
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                stage = (SparkStage)tuple2._1();
                SparkStageProgress progress = (SparkStageProgress)tuple2._2();
                complete = progress.completedTasksCount();
                total = progress.totalTaskCount();
                running = progress.runningTaskCount();
                failed = progress.failedTaskCount();
                Enumeration.Value value = state = total > 0 ? SparkOperationProgressStatus$.MODULE$.PENDING() : SparkOperationProgressStatus$.MODULE$.FINISHED();
                if (complete > 0 || running > 0 || failed > 0) {
                    state = complete < total ? SparkOperationProgressStatus$.MODULE$.RUNNING() : SparkOperationProgressStatus$.MODULE$.FINISHED();
                }
            } else {
                throw new MatchError((Object)tuple2);
            }
            String attempt = String.valueOf(stage.attemptId());
            String stageName = new StringBuilder(6).append("Stage-").append(String.valueOf(stage.stageId())).toString();
            String nameWithProgress = this.getNameWithProgress(stageName, complete, total);
            int pending = total - complete - running;
            List<Object> list = Arrays.asList((Object[])new String[]{nameWithProgress, attempt, state.toString(), String.valueOf(total), String.valueOf(complete), String.valueOf(running), String.valueOf(pending), String.valueOf(failed), ""});
            return list;
        })).toList()).asJavaCollection();
        return new ArrayList<List<String>>(progressRows);
    }

    public String footerSummary() {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("STAGES: %02d/%02d"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.getCompletedStages()), BoxesRunTime.boxToInteger((int)this.progressMap().keySet().size())}));
    }

    public double progressedPercentage() {
        IntRef sumTotal = IntRef.create((int)0);
        IntRef sumComplete = IntRef.create((int)0);
        this.progressMap().values().foreach((Function1 & Serializable)progress -> {
            SparkProgressMonitor.$anonfun$progressedPercentage$1(sumTotal, sumComplete, progress);
            return BoxedUnit.UNIT;
        });
        return sumTotal.elem == 0 ? 1.0 : (double)((float)sumComplete.elem / (float)sumTotal.elem);
    }

    public TJobExecutionStatus executionStatus() {
        return this.getCompletedStages() == this.progressMap().keySet().size() ? TJobExecutionStatus.COMPLETE : TJobExecutionStatus.IN_PROGRESS;
    }

    private String getNameWithProgress(String s, int complete, int total) {
        if (s == null) {
            return "";
        }
        float percent = total == 0 ? 1.0f : (float)complete / (float)total;
        int spaceRemaining = SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$COLUMN_1_WIDTH() - s.length() - 1;
        String trimmedVName = s;
        if (s.length() > SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$COLUMN_1_WIDTH()) {
            trimmedVName = s.substring(0, SparkProgressMonitor$.MODULE$.org$apache$spark$kyuubi$SparkProgressMonitor$$COLUMN_1_WIDTH() - 2);
            trimmedVName = new StringBuilder(2).append(trimmedVName).append("..").toString();
        } else {
            trimmedVName = new StringBuilder(1).append(trimmedVName).append(" ").toString();
        }
        int toFill = (int)((float)spaceRemaining * percent);
        return new StringBuilder(0).append(trimmedVName).append(StringOps$.MODULE$.$times$extension(Predef$.MODULE$.augmentString("."), toFill)).toString();
    }

    private int getCompletedStages() {
        IntRef completed = IntRef.create((int)0);
        this.progressMap().values().foreach((Function1 & Serializable)progress -> {
            SparkProgressMonitor.$anonfun$getCompletedStages$1(completed, progress);
            return BoxedUnit.UNIT;
        });
        return completed.elem;
    }

    public static final /* synthetic */ boolean $anonfun$progressMap$1(SparkProgressMonitor $this, JobData x$1) {
        Option option = x$1.jobGroup();
        Option option2 = Option$.MODULE$.apply((Object)$this.jobGroup);
        return !(option != null ? !option.equals(option2) : option2 != null);
    }

    public static final /* synthetic */ Option $anonfun$progressMap$3(SparkProgressMonitor $this, int stageId) {
        return $this.statusStore().asOption((Function0 & Serializable)() -> $this.statusStore().lastStageAttempt(stageId));
    }

    public static final /* synthetic */ void $anonfun$progressedPercentage$1(IntRef sumTotal$1, IntRef sumComplete$1, SparkStageProgress progress) {
        int complete = progress.completedTasksCount();
        int total = progress.totalTaskCount();
        sumTotal$1.elem += total;
        sumComplete$1.elem += complete;
    }

    public static final /* synthetic */ void $anonfun$getCompletedStages$1(IntRef completed$1, SparkStageProgress progress) {
        block0: {
            int complete = progress.completedTasksCount();
            int total = progress.totalTaskCount();
            if (total <= 0 || complete != total) break block0;
            ++completed$1.elem;
        }
    }

    public SparkProgressMonitor(SparkSession spark, String jobGroup) {
        this.jobGroup = jobGroup;
        this.statusStore = spark.sparkContext().statusStore();
    }
}

