/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kyuubi.client;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.kyuubi.client.HttpClientFactory;
import org.apache.kyuubi.client.IRestClient;
import org.apache.kyuubi.client.RestClient;
import org.apache.kyuubi.client.RestClientConf;
import org.apache.kyuubi.client.exception.RetryableKyuubiRestException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableRestClient
implements InvocationHandler {
    private static final Logger LOG = LoggerFactory.getLogger(RetryableRestClient.class);
    private final RestClientConf conf;
    private final List<String> uris;
    private int currentUriIndex;
    private volatile IRestClient restClient;

    private RetryableRestClient(List<String> uris, RestClientConf conf) {
        this.conf = conf;
        this.uris = uris;
        this.currentUriIndex = ThreadLocalRandom.current().nextInt(uris.size());
        this.newRestClient();
    }

    public static IRestClient getRestClient(List<String> uris, RestClientConf conf) {
        RetryableRestClient client = new RetryableRestClient(uris, conf);
        return (IRestClient)Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{IRestClient.class}, (InvocationHandler)client);
    }

    private void newRestClient() {
        if (this.restClient != null) {
            try {
                this.restClient.close();
                this.restClient = null;
            }
            catch (Exception e) {
                LOG.warn("Failed to close rest client", (Throwable)e);
            }
        }
        CloseableHttpClient httpclient = HttpClientFactory.createHttpClient(this.conf);
        assert (this.currentUriIndex < this.uris.size());
        this.restClient = new RestClient(this.uris.get(this.currentUriIndex), httpclient);
        LOG.info("Current connect server uri {}", (Object)this.uris.get(this.currentUriIndex));
    }

    @Override
    public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int retryTimes = 0;
        while (true) {
            try {
                return method.invoke((Object)this.restClient, args);
            }
            catch (IllegalAccessException illegalAccessException) {
                continue;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() == null) {
                    throw e;
                }
                if (e.getCause() instanceof RetryableKyuubiRestException) {
                    if (++retryTimes > this.conf.getMaxAttempts()) {
                        LOG.error("Attempt over {} times", (Object)this.conf.getMaxAttempts(), (Object)e.getCause());
                        throw e.getCause();
                    }
                    Thread.sleep(this.conf.getAttemptWaitTime());
                    this.currentUriIndex = this.currentUriIndex == this.uris.size() - 1 ? 0 : ++this.currentUriIndex;
                    this.newRestClient();
                    continue;
                }
                throw e.getCause();
            }
            break;
        }
    }
}

