/*
 * Decompiled with CFR 0.152.
 */
package org.apache.log4j.net;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.net.PortBased;
import org.apache.log4j.net.ZeroConfSupport;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.XMLLayout;

public class UDPAppender
extends AppenderSkeleton
implements PortBased {
    public static final int DEFAULT_PORT = 9991;
    String hostname;
    String remoteHost;
    String application;
    String encoding;
    InetAddress address;
    int port = 9991;
    DatagramSocket outSocket;
    public static final String ZONE = "_log4j_xml_udp_appender.local.";
    boolean inError = false;
    private boolean advertiseViaMulticastDNS;
    private ZeroConfSupport zeroConf;

    public UDPAppender() {
        super(false);
    }

    public UDPAppender(InetAddress address, int port) {
        super(false);
        this.address = address;
        this.remoteHost = address.getHostName();
        this.port = port;
        this.activateOptions();
    }

    public UDPAppender(String host, int port) {
        super(false);
        this.port = port;
        this.address = this.getAddressByName(host);
        this.remoteHost = host;
        this.activateOptions();
    }

    @Override
    public void activateOptions() {
        try {
            this.hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException uhe) {
            try {
                this.hostname = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException uhe2) {
                this.hostname = "unknown";
            }
        }
        if (this.application == null) {
            this.application = System.getProperty("application");
        } else if (System.getProperty("application") != null) {
            this.application = this.application + "-" + System.getProperty("application");
        }
        if (this.remoteHost == null) {
            String err = "The RemoteHost property is required for SocketAppender named " + this.name;
            LogLog.error(err);
            throw new IllegalStateException(err);
        }
        this.address = this.getAddressByName(this.remoteHost);
        this.connect(this.address, this.port);
        if (this.layout == null) {
            this.layout = new XMLLayout();
        }
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf = new ZeroConfSupport(ZONE, this.port, this.getName());
            this.zeroConf.advertise();
        }
        super.activateOptions();
    }

    @Override
    public synchronized void close() {
        if (this.closed) {
            return;
        }
        if (this.advertiseViaMulticastDNS) {
            this.zeroConf.unadvertise();
        }
        this.closed = true;
        this.cleanUp();
    }

    public void cleanUp() {
        if (this.outSocket != null) {
            try {
                this.outSocket.close();
            }
            catch (Exception e) {
                LogLog.error("Could not close outSocket.", e);
            }
            this.outSocket = null;
        }
    }

    void connect(InetAddress address, int port) {
        if (this.address == null) {
            return;
        }
        try {
            this.cleanUp();
            this.outSocket = new DatagramSocket();
            this.outSocket.connect(address, port);
        }
        catch (IOException e) {
            LogLog.error("Could not open UDP Socket for sending.", e);
            this.inError = true;
        }
    }

    @Override
    public void append(LoggingEvent event) {
        if (this.inError) {
            return;
        }
        if (event == null) {
            return;
        }
        if (this.address == null) {
            return;
        }
        if (this.outSocket != null) {
            event.setProperty("hostname", this.hostname);
            if (this.application != null) {
                event.setProperty("application", this.application);
            }
            try {
                StringBuilder buf = new StringBuilder(this.layout.format(event));
                byte[] payload = this.encoding == null ? buf.toString().getBytes() : buf.toString().getBytes(this.encoding);
                DatagramPacket dp = new DatagramPacket(payload, payload.length, this.address, this.port);
                this.outSocket.send(dp);
            }
            catch (IOException e) {
                this.outSocket = null;
                LogLog.warn("Detected problem with UDP connection: " + e);
            }
        }
    }

    @Override
    public boolean isActive() {
        return !this.inError;
    }

    InetAddress getAddressByName(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (Exception e) {
            LogLog.error("Could not find address of [" + host + "].", e);
            return null;
        }
    }

    @Override
    public boolean requiresLayout() {
        return true;
    }

    public void setRemoteHost(String host) {
        this.remoteHost = host;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public void setApplication(String app) {
        this.application = app;
    }

    public String getApplication() {
        return this.application;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public int getPort() {
        return this.port;
    }

    public void setAdvertiseViaMulticastDNS(boolean advertiseViaMulticastDNS) {
        this.advertiseViaMulticastDNS = advertiseViaMulticastDNS;
    }

    public boolean isAdvertiseViaMulticastDNS() {
        return this.advertiseViaMulticastDNS;
    }
}

