﻿using Lucene.Net.Analysis.TokenAttributes;
using System;
using System.IO;

namespace Lucene.Net.Analysis.Standard.Std34
{
    /*
     * Licensed to the Apache Software Foundation (ASF) under one or more
     * contributor license agreements.  See the NOTICE file distributed with
     * this work for additional information regarding copyright ownership.
     * The ASF licenses this file to You under the Apache License, Version 2.0
     * (the "License"); you may not use this file except in compliance with
     * the License.  You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */

    /// <summary>
    /// This class implements StandardTokenizer using Unicode 6.0.0.
    /// 
    /// @deprecated This class is only for exact backwards compatibility
    /// </summary>
    [Obsolete("This class is only for exact backwards compatibility")]
    public sealed class StandardTokenizerImpl34 : IStandardTokenizerInterface
    {
        /// <summary>This character denotes the end of file</summary>
        public static readonly int YYEOF = -1;

        /// <summary>initial size of the lookahead buffer</summary>
        private static readonly int ZZ_BUFFERSIZE = 4096;

        /// <summary>lexical states</summary>
        public const int YYINITIAL = 0;

        /// <summary>
        /// ZZ_LEXSTATE[l] is the state in the DFA for the lexical state l
        /// ZZ_LEXSTATE[l+1] is the state in the DFA for the lexical state l
        ///     at the beginning of a line
        /// l is of the form l = 2*k, k a non negative integer
        /// </summary>
        private static readonly int[] ZZ_LEXSTATE = { 0, 0 };

        /// <summary>
        /// Translates characters to character classes
        /// </summary>
        private const string ZZ_CMAP_PACKED =
            "\x0027\x0000\x0001\x0060\x0004\x0000\x0001\x005F\x0001\x0000\x0001\x0060\x0001\x0000\x000A\x005C\x0001\x005E\x0001\x005F" +
            "\x0005\x0000\x001A\x005A\x0004\x0000\x0001\x0061\x0001\x0000\x001A\x005A\x002F\x0000\x0001\x005A\x0002\x0000\x0001\x005B" +
            "\x0007\x0000\x0001\x005A\x0001\x0000\x0001\x005E\x0002\x0000\x0001\x005A\x0005\x0000\x0017\x005A\x0001\x0000\x001F\x005A" +
            "\x0001\x0000\u01ca\x005A\x0004\x0000\x000C\x005A\x000E\x0000\x0005\x005A\x0007\x0000\x0001\x005A\x0001\x0000\x0001\x005A" +
            "\x0011\x0000\x0070\x005B\x0005\x005A\x0001\x0000\x0002\x005A\x0002\x0000\x0004\x005A\x0001\x005F\x0007\x0000\x0001\x005A" +
            "\x0001\x005E\x0003\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0014\x005A\x0001\x0000\x0053\x005A\x0001\x0000\x008B\x005A" +
            "\x0001\x0000\x0007\x005B\x009E\x005A\x0009\x0000\x0026\x005A\x0002\x0000\x0001\x005A\x0007\x0000\x0027\x005A\x0001\x0000" +
            "\x0001\x005F\x0007\x0000\x002D\x005B\x0001\x0000\x0001\x005B\x0001\x0000\x0002\x005B\x0001\x0000\x0002\x005B\x0001\x0000" +
            "\x0001\x005B\x0008\x0000\x001B\x005A\x0005\x0000\x0004\x005A\x0001\x005E\x000B\x0000\x0004\x005B\x0008\x0000\x0002\x005F" +
            "\x0002\x0000\x000B\x005B\x0005\x0000\x002B\x005A\x0015\x005B\x000A\x005C\x0001\x0000\x0001\x005C\x0001\x005F\x0001\x0000" +
            "\x0002\x005A\x0001\x005B\x0063\x005A\x0001\x0000\x0001\x005A\x0007\x005B\x0001\x005B\x0001\x0000\x0006\x005B\x0002\x005A" +
            "\x0002\x005B\x0001\x0000\x0004\x005B\x0002\x005A\x000A\x005C\x0003\x005A\x0002\x0000\x0001\x005A\x000F\x0000\x0001\x005B" +
            "\x0001\x005A\x0001\x005B\x001E\x005A\x001B\x005B\x0002\x0000\x0059\x005A\x000B\x005B\x0001\x005A\x000E\x0000\x000A\x005C" +
            "\x0021\x005A\x0009\x005B\x0002\x005A\x0002\x0000\x0001\x005F\x0001\x0000\x0001\x005A\x0005\x0000\x0016\x005A\x0004\x005B" +
            "\x0001\x005A\x0009\x005B\x0001\x005A\x0003\x005B\x0001\x005A\x0005\x005B\x0012\x0000\x0019\x005A\x0003\x005B\x00A4\x0000" +
            "\x0004\x005B\x0036\x005A\x0003\x005B\x0001\x005A\x0012\x005B\x0001\x005A\x0007\x005B\x000A\x005A\x0002\x005B\x0002\x0000" +
            "\x000A\x005C\x0001\x0000\x0007\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0003\x005B\x0001\x0000\x0008\x005A\x0002\x0000" +
            "\x0002\x005A\x0002\x0000\x0016\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0001\x005A\x0003\x0000\x0004\x005A\x0002\x0000" +
            "\x0001\x005B\x0001\x005A\x0007\x005B\x0002\x0000\x0002\x005B\x0002\x0000\x0003\x005B\x0001\x005A\x0008\x0000\x0001\x005B" +
            "\x0004\x0000\x0002\x005A\x0001\x0000\x0003\x005A\x0002\x005B\x0002\x0000\x000A\x005C\x0002\x005A\x000F\x0000\x0003\x005B" +
            "\x0001\x0000\x0006\x005A\x0004\x0000\x0002\x005A\x0002\x0000\x0016\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0002\x005A" +
            "\x0001\x0000\x0002\x005A\x0001\x0000\x0002\x005A\x0002\x0000\x0001\x005B\x0001\x0000\x0005\x005B\x0004\x0000\x0002\x005B" +
            "\x0002\x0000\x0003\x005B\x0003\x0000\x0001\x005B\x0007\x0000\x0004\x005A\x0001\x0000\x0001\x005A\x0007\x0000\x000A\x005C" +
            "\x0002\x005B\x0003\x005A\x0001\x005B\x000B\x0000\x0003\x005B\x0001\x0000\x0009\x005A\x0001\x0000\x0003\x005A\x0001\x0000" +
            "\x0016\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0002\x005A\x0001\x0000\x0005\x005A\x0002\x0000\x0001\x005B\x0001\x005A" +
            "\x0008\x005B\x0001\x0000\x0003\x005B\x0001\x0000\x0003\x005B\x0002\x0000\x0001\x005A\x000F\x0000\x0002\x005A\x0002\x005B" +
            "\x0002\x0000\x000A\x005C\x0011\x0000\x0003\x005B\x0001\x0000\x0008\x005A\x0002\x0000\x0002\x005A\x0002\x0000\x0016\x005A" +
            "\x0001\x0000\x0007\x005A\x0001\x0000\x0002\x005A\x0001\x0000\x0005\x005A\x0002\x0000\x0001\x005B\x0001\x005A\x0007\x005B" +
            "\x0002\x0000\x0002\x005B\x0002\x0000\x0003\x005B\x0008\x0000\x0002\x005B\x0004\x0000\x0002\x005A\x0001\x0000\x0003\x005A" +
            "\x0002\x005B\x0002\x0000\x000A\x005C\x0001\x0000\x0001\x005A\x0010\x0000\x0001\x005B\x0001\x005A\x0001\x0000\x0006\x005A" +
            "\x0003\x0000\x0003\x005A\x0001\x0000\x0004\x005A\x0003\x0000\x0002\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0002\x005A" +
            "\x0003\x0000\x0002\x005A\x0003\x0000\x0003\x005A\x0003\x0000\x000C\x005A\x0004\x0000\x0005\x005B\x0003\x0000\x0003\x005B" +
            "\x0001\x0000\x0004\x005B\x0002\x0000\x0001\x005A\x0006\x0000\x0001\x005B\x000E\x0000\x000A\x005C\x0011\x0000\x0003\x005B" +
            "\x0001\x0000\x0008\x005A\x0001\x0000\x0003\x005A\x0001\x0000\x0017\x005A\x0001\x0000\x000A\x005A\x0001\x0000\x0005\x005A" +
            "\x0003\x0000\x0001\x005A\x0007\x005B\x0001\x0000\x0003\x005B\x0001\x0000\x0004\x005B\x0007\x0000\x0002\x005B\x0001\x0000" +
            "\x0002\x005A\x0006\x0000\x0002\x005A\x0002\x005B\x0002\x0000\x000A\x005C\x0012\x0000\x0002\x005B\x0001\x0000\x0008\x005A" +
            "\x0001\x0000\x0003\x005A\x0001\x0000\x0017\x005A\x0001\x0000\x000A\x005A\x0001\x0000\x0005\x005A\x0002\x0000\x0001\x005B" +
            "\x0001\x005A\x0007\x005B\x0001\x0000\x0003\x005B\x0001\x0000\x0004\x005B\x0007\x0000\x0002\x005B\x0007\x0000\x0001\x005A" +
            "\x0001\x0000\x0002\x005A\x0002\x005B\x0002\x0000\x000A\x005C\x0001\x0000\x0002\x005A\x000F\x0000\x0002\x005B\x0001\x0000" +
            "\x0008\x005A\x0001\x0000\x0003\x005A\x0001\x0000\x0029\x005A\x0002\x0000\x0001\x005A\x0007\x005B\x0001\x0000\x0003\x005B" +
            "\x0001\x0000\x0004\x005B\x0001\x005A\x0008\x0000\x0001\x005B\x0008\x0000\x0002\x005A\x0002\x005B\x0002\x0000\x000A\x005C" +
            "\x000A\x0000\x0006\x005A\x0002\x0000\x0002\x005B\x0001\x0000\x0012\x005A\x0003\x0000\x0018\x005A\x0001\x0000\x0009\x005A" +
            "\x0001\x0000\x0001\x005A\x0002\x0000\x0007\x005A\x0003\x0000\x0001\x005B\x0004\x0000\x0006\x005B\x0001\x0000\x0001\x005B" +
            "\x0001\x0000\x0008\x005B\x0012\x0000\x0002\x005B\x000D\x0000\x0030\x0062\x0001\x0063\x0002\x0062\x0007\x0063\x0005\x0000" +
            "\x0007\x0062\x0008\x0063\x0001\x0000\x000A\x005C\x0027\x0000\x0002\x0062\x0001\x0000\x0001\x0062\x0002\x0000\x0002\x0062" +
            "\x0001\x0000\x0001\x0062\x0002\x0000\x0001\x0062\x0006\x0000\x0004\x0062\x0001\x0000\x0007\x0062\x0001\x0000\x0003\x0062" +
            "\x0001\x0000\x0001\x0062\x0001\x0000\x0001\x0062\x0002\x0000\x0002\x0062\x0001\x0000\x0004\x0062\x0001\x0063\x0002\x0062" +
            "\x0006\x0063\x0001\x0000\x0002\x0063\x0001\x0062\x0002\x0000\x0005\x0062\x0001\x0000\x0001\x0062\x0001\x0000\x0006\x0063" +
            "\x0002\x0000\x000A\x005C\x0002\x0000\x0002\x0062\x0022\x0000\x0001\x005A\x0017\x0000\x0002\x005B\x0006\x0000\x000A\x005C" +
            "\x000B\x0000\x0001\x005B\x0001\x0000\x0001\x005B\x0001\x0000\x0001\x005B\x0004\x0000\x0002\x005B\x0008\x005A\x0001\x0000" +
            "\x0024\x005A\x0004\x0000\x0014\x005B\x0001\x0000\x0002\x005B\x0005\x005A\x000B\x005B\x0001\x0000\x0024\x005B\x0009\x0000" +
            "\x0001\x005B\x0039\x0000\x002B\x0062\x0014\x0063\x0001\x0062\x000A\x005C\x0006\x0000\x0006\x0062\x0004\x0063\x0004\x0062" +
            "\x0003\x0063\x0001\x0062\x0003\x0063\x0002\x0062\x0007\x0063\x0003\x0062\x0004\x0063\x000D\x0062\x000C\x0063\x0001\x0062" +
            "\x0001\x0063\x000A\x005C\x0004\x0063\x0002\x0062\x0026\x005A\x000A\x0000\x002B\x005A\x0001\x0000\x0001\x005A\x0003\x0000" +
            "\u0100\x0066\x0049\x005A\x0001\x0000\x0004\x005A\x0002\x0000\x0007\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0004\x005A" +
            "\x0002\x0000\x0029\x005A\x0001\x0000\x0004\x005A\x0002\x0000\x0021\x005A\x0001\x0000\x0004\x005A\x0002\x0000\x0007\x005A" +
            "\x0001\x0000\x0001\x005A\x0001\x0000\x0004\x005A\x0002\x0000\x000F\x005A\x0001\x0000\x0039\x005A\x0001\x0000\x0004\x005A" +
            "\x0002\x0000\x0043\x005A\x0002\x0000\x0003\x005B\x0020\x0000\x0010\x005A\x0010\x0000\x0055\x005A\x000C\x0000\u026c\x005A" +
            "\x0002\x0000\x0011\x005A\x0001\x0000\x001A\x005A\x0005\x0000\x004B\x005A\x0003\x0000\x0003\x005A\x000F\x0000\x000D\x005A" +
            "\x0001\x0000\x0004\x005A\x0003\x005B\x000B\x0000\x0012\x005A\x0003\x005B\x000B\x0000\x0012\x005A\x0002\x005B\x000C\x0000" +
            "\x000D\x005A\x0001\x0000\x0003\x005A\x0001\x0000\x0002\x005B\x000C\x0000\x0034\x0062\x0002\x0063\x001E\x0063\x0003\x0000" +
            "\x0001\x0062\x0004\x0000\x0001\x0062\x0001\x0063\x0002\x0000\x000A\x005C\x0021\x0000\x0003\x005B\x0002\x0000\x000A\x005C" +
            "\x0006\x0000\x0058\x005A\x0008\x0000\x0029\x005A\x0001\x005B\x0001\x005A\x0005\x0000\x0046\x005A\x000A\x0000\x001D\x005A" +
            "\x0003\x0000\x000C\x005B\x0004\x0000\x000C\x005B\x000A\x0000\x000A\x005C\x001E\x0062\x0002\x0000\x0005\x0062\x000B\x0000" +
            "\x002C\x0062\x0004\x0000\x0011\x0063\x0007\x0062\x0002\x0063\x0006\x0000\x000A\x005C\x0001\x0062\x0003\x0000\x0002\x0062" +
            "\x0020\x0000\x0017\x005A\x0005\x005B\x0004\x0000\x0035\x0062\x000A\x0063\x0001\x0000\x001D\x0063\x0002\x0000\x0001\x005B" +
            "\x000A\x005C\x0006\x0000\x000A\x005C\x0006\x0000\x000E\x0062\x0052\x0000\x0005\x005B\x002F\x005A\x0011\x005B\x0007\x005A" +
            "\x0004\x0000\x000A\x005C\x0011\x0000\x0009\x005B\x000C\x0000\x0003\x005B\x001E\x005A\x000A\x005B\x0003\x0000\x0002\x005A" +
            "\x000A\x005C\x0006\x0000\x0026\x005A\x000E\x005B\x000C\x0000\x0024\x005A\x0014\x005B\x0008\x0000\x000A\x005C\x0003\x0000" +
            "\x0003\x005A\x000A\x005C\x0024\x005A\x0052\x0000\x0003\x005B\x0001\x0000\x0015\x005B\x0004\x005A\x0001\x005B\x0004\x005A" +
            "\x0001\x005B\x000D\x0000\x00C0\x005A\x0027\x005B\x0015\x0000\x0004\x005B\u0116\x005A\x0002\x0000\x0006\x005A\x0002\x0000" +
            "\x0026\x005A\x0002\x0000\x0006\x005A\x0002\x0000\x0008\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0001\x005A\x0001\x0000" +
            "\x0001\x005A\x0001\x0000\x001F\x005A\x0002\x0000\x0035\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0001\x005A\x0003\x0000" +
            "\x0003\x005A\x0001\x0000\x0007\x005A\x0003\x0000\x0004\x005A\x0002\x0000\x0006\x005A\x0004\x0000\x000D\x005A\x0005\x0000" +
            "\x0003\x005A\x0001\x0000\x0007\x005A\x000F\x0000\x0002\x005B\x0002\x005B\x0008\x0000\x0002\x0060\x000A\x0000\x0001\x0060" +
            "\x0002\x0000\x0001\x005E\x0002\x0000\x0005\x005B\x0010\x0000\x0002\x0061\x0003\x0000\x0001\x005F\x000F\x0000\x0001\x0061" +
            "\x000B\x0000\x0005\x005B\x0005\x0000\x0006\x005B\x0001\x0000\x0001\x005A\x000D\x0000\x0001\x005A\x0010\x0000\x000D\x005A" +
            "\x0033\x0000\x0021\x005B\x0011\x0000\x0001\x005A\x0004\x0000\x0001\x005A\x0002\x0000\x000A\x005A\x0001\x0000\x0001\x005A" +
            "\x0003\x0000\x0005\x005A\x0006\x0000\x0001\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0004\x005A" +
            "\x0001\x0000\x000B\x005A\x0002\x0000\x0004\x005A\x0005\x0000\x0005\x005A\x0004\x0000\x0001\x005A\x0011\x0000\x0029\x005A" +
            "\u032d\x0000\x0034\x005A\u0716\x0000\x002F\x005A\x0001\x0000\x002F\x005A\x0001\x0000\x0085\x005A\x0006\x0000\x0004\x005A" +
            "\x0003\x005B\x000E\x0000\x0026\x005A\x000A\x0000\x0036\x005A\x0009\x0000\x0001\x005A\x000F\x0000\x0001\x005B\x0017\x005A" +
            "\x0009\x0000\x0007\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0007\x005A" +
            "\x0001\x0000\x0007\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0007\x005A\x0001\x0000\x0020\x005B\x002F\x0000\x0001\x005A" +
            "\x0050\x0000\x001A\x0064\x0001\x0000\x0059\x0064\x000C\x0000\x00D6\x0064\x002F\x0000\x0001\x005A\x0001\x0000\x0001\x0064" +
            "\x0019\x0000\x0009\x0064\x0004\x005B\x0002\x005B\x0001\x0000\x0005\x005D\x0002\x0000\x0003\x0064\x0001\x005A\x0001\x005A" +
            "\x0004\x0000\x0056\x0065\x0002\x0000\x0002\x005B\x0002\x005D\x0003\x0065\x005B\x005D\x0001\x0000\x0004\x005D\x0005\x0000" +
            "\x0029\x005A\x0003\x0000\x005E\x0066\x0011\x0000\x001B\x005A\x0035\x0000\x0010\x005D\x001F\x0000\x0041\x0000\x001F\x0000" +
            "\x0051\x0000\x002F\x005D\x0001\x0000\x0058\x005D\x00A8\x0000\u19b6\x0064\x004A\x0000\u51cc\x0064\x0034\x0000\u048d\x005A" +
            "\x0043\x0000\x002E\x005A\x0002\x0000\u010d\x005A\x0003\x0000\x0010\x005A\x000A\x005C\x0002\x005A\x0014\x0000\x002F\x005A" +
            "\x0004\x005B\x0009\x0000\x0002\x005B\x0001\x0000\x0019\x005A\x0008\x0000\x0050\x005A\x0002\x005B\x0025\x0000\x0009\x005A" +
            "\x0002\x0000\x0067\x005A\x0002\x0000\x0004\x005A\x0001\x0000\x0002\x005A\x000E\x0000\x000A\x005A\x0050\x0000\x0008\x005A" +
            "\x0001\x005B\x0003\x005A\x0001\x005B\x0004\x005A\x0001\x005B\x0017\x005A\x0005\x005B\x0018\x0000\x0034\x005A\x000C\x0000" +
            "\x0002\x005B\x0032\x005A\x0011\x005B\x000B\x0000\x000A\x005C\x0006\x0000\x0012\x005B\x0006\x005A\x0003\x0000\x0001\x005A" +
            "\x0004\x0000\x000A\x005C\x001C\x005A\x0008\x005B\x0002\x0000\x0017\x005A\x000D\x005B\x000C\x0000\x001D\x0066\x0003\x0000" +
            "\x0004\x005B\x002F\x005A\x000E\x005B\x000E\x0000\x0001\x005A\x000A\x005C\x0026\x0000\x0029\x005A\x000E\x005B\x0009\x0000" +
            "\x0003\x005A\x0001\x005B\x0008\x005A\x0002\x005B\x0002\x0000\x000A\x005C\x0006\x0000\x001B\x0062\x0001\x0063\x0004\x0000" +
            "\x0030\x0062\x0001\x0063\x0001\x0062\x0003\x0063\x0002\x0062\x0002\x0063\x0005\x0062\x0002\x0063\x0001\x0062\x0001\x0063" +
            "\x0001\x0062\x0018\x0000\x0005\x0062\x0021\x0000\x0006\x005A\x0002\x0000\x0006\x005A\x0002\x0000\x0006\x005A\x0009\x0000" +
            "\x0007\x005A\x0001\x0000\x0007\x005A\x0091\x0000\x0023\x005A\x0008\x005B\x0001\x0000\x0002\x005B\x0002\x0000\x000A\x005C" +
            "\x0006\x0000\u2ba4\x0066\x000C\x0000\x0017\x0066\x0004\x0000\x0031\x0066\x0004\x0000\x0001\x0019\x0001\x0015\x0001\x0026" +
            "\x0001\x0023\x0001\x000B\x0003\x0000\x0001\x0007\x0001\x0005\x0002\x0000\x0001\x0003\x0001\x0001\x000C\x0000\x0001\x0009" +
            "\x0011\x0000\x0001\x004A\x0007\x0000\x0001\x0035\x0001\x000F\x0006\x0000\x0001\x0058\x0003\x0000\x0001\x0050\x0001\x0050" +
            "\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050" +
            "\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050" +
            "\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050" +
            "\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0051" +
            "\x0001\x0050\x0001\x0050\x0001\x0050\x0001\x0055\x0001\x0053\x000F\x0000\x0001\x004C\u02c1\x0000\x0001\x0038\x00BF\x0000" +
            "\x0001\x004B\x0001\x0039\x0001\x0002\x0003\x0054\x0002\x001D\x0001\x0054\x0001\x001D\x0002\x0054\x0001\x000C\x0011\x0054" +
            "\x0002\x0030\x0007\x003B\x0001\x003A\x0007\x003B\x0007\x002A\x0001\x000D\x0001\x002A\x0001\x003D\x0002\x0025\x0001\x0024" +
            "\x0001\x003D\x0001\x0025\x0001\x0024\x0008\x003D\x0002\x0033\x0005\x0031\x0002\x002C\x0005\x0031\x0001\x0006\x0008\x001F" +
            "\x0005\x0011\x0003\x0017\x000A\x0046\x0010\x0017\x0003\x0022\x001A\x0018\x0001\x0016\x0002\x0014\x0002\x0048\x0001\x0049" +
            "\x0002\x0048\x0002\x0049\x0002\x0048\x0001\x0049\x0003\x0014\x0001\x000E\x0002\x0014\x000A\x0034\x0001\x003C\x0001\x0021" +
            "\x0001\x001C\x0001\x0034\x0006\x0021\x0001\x001C\x0036\x0021\x0005\x004D\x0006\x0043\x0001\x0029\x0004\x0043\x0002\x0029" +
            "\x0008\x0043\x0001\x0029\x0007\x0040\x0001\x000A\x0002\x0040\x001A\x0043\x0001\x000A\x0004\x0040\x0001\x000A\x0005\x0042" +
            "\x0001\x0041\x0001\x0042\x0003\x0041\x0007\x0042\x0001\x0041\x0013\x0042\x0005\x0037\x0003\x0042\x0006\x0037\x0002\x0037" +
            "\x0006\x0036\x0008\x0036\x0002\x0040\x0007\x0036\x001E\x0040\x0004\x0036\x0042\x0040\x000D\x004D\x0001\x003F\x0002\x004D" +
            "\x0001\x0059\x0003\x004F\x0001\x004D\x0002\x004F\x0005\x004D\x0004\x004F\x0004\x004E\x0001\x004D\x0003\x004E\x0001\x004D" +
            "\x0005\x004E\x0016\x002E\x0004\x0013\x0001\x0045\x0002\x0044\x0004\x0052\x0001\x0044\x0002\x0052\x0003\x003E\x001B\x0052" +
            "\x001D\x002D\x0003\x0052\x001D\x0056\x0003\x0052\x0006\x0056\x0002\x001B\x0019\x0056\x0001\x001B\x000F\x0056\x0006\x0052" +
            "\x0004\x0012\x0001\x0008\x001F\x0012\x0001\x0008\x0004\x0012\x0015\x0032\x0001\x0057\x0009\x0032\x0011\x002D\x0005\x0032" +
            "\x0001\x002F\x000A\x0020\x000B\x0032\x0004\x002D\x0001\x0028\x0006\x002D\x000A\x0052\x000F\x002D\x0001\x0027\x0003\x002B" +
            "\x000D\x0010\x0009\x001E\x0001\x001A\x0014\x001E\x0002\x0010\x0009\x001E\x0001\x001A\x0019\x001E\x0001\x001A\x0004\x0010" +
            "\x0004\x001E\x0002\x001A\x0002\x0047\x0001\x0004\x0005\x0047\x002A\x0004\u1900\x0000\u012e\x0064\x0002\x0000\x003E\x0064" +
            "\x0002\x0000\x006A\x0064\x0026\x0000\x0007\x005A\x000C\x0000\x0005\x005A\x0005\x0000\x0001\x005A\x0001\x005B\x000A\x005A" +
            "\x0001\x0000\x000D\x005A\x0001\x0000\x0005\x005A\x0001\x0000\x0001\x005A\x0001\x0000\x0002\x005A\x0001\x0000\x0002\x005A" +
            "\x0001\x0000\x006C\x005A\x0021\x0000\u016b\x005A\x0012\x0000\x0040\x005A\x0002\x0000\x0036\x005A\x0028\x0000\x000C\x005A" +
            "\x0004\x0000\x0010\x005B\x0001\x005F\x0002\x0000\x0001\x005E\x0001\x005F\x000B\x0000\x0007\x005B\x000C\x0000\x0002\x0061" +
            "\x0018\x0000\x0003\x0061\x0001\x005F\x0001\x0000\x0001\x0060\x0001\x0000\x0001\x005F\x0001\x005E\x001A\x0000\x0005\x005A" +
            "\x0001\x0000\x0087\x005A\x0002\x0000\x0001\x005B\x0007\x0000\x0001\x0060\x0004\x0000\x0001\x005F\x0001\x0000\x0001\x0060" +
            "\x0001\x0000\x000A\x005C\x0001\x005E\x0001\x005F\x0005\x0000\x001A\x005A\x0004\x0000\x0001\x0061\x0001\x0000\x001A\x005A" +
            "\x000B\x0000\x0038\x005D\x0002\x005B\x001F\x0066\x0003\x0000\x0006\x0066\x0002\x0000\x0006\x0066\x0002\x0000\x0006\x0066" +
            "\x0002\x0000\x0003\x0066\x001C\x0000\x0003\x005B\x0004\x0000";

        /// <summary>
        /// Translates characters to character classes
        /// </summary>
        private static readonly char[] ZZ_CMAP = ZzUnpackCMap(ZZ_CMAP_PACKED);

        /// <summary>
        /// Translates DFA states to action switch labels.
        /// </summary>
        private static readonly int[] ZZ_ACTION = ZzUnpackAction();

        private const string ZZ_ACTION_PACKED_0 =
            "\x0001\x0000\x0013\x0001\x0001\x0002\x0001\x0003\x0001\x0004\x0001\x0001\x0001\x0005\x0001\x0006" +
            "\x0001\x0007\x0001\x0008\x000D\x0000\x0001\x0002\x0001\x0000\x0001\x0002\x0008\x0000\x0001\x0003" +
            "\x000D\x0000\x0001\x0002\x0039\x0000";

        private static int[] ZzUnpackAction()
        {
            int[] result = new int[124];
            int offset = 0;
            offset = ZzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackAction(string packed, int offset, int[] result)
        {
            int i = 0;       /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                do result[j++] = value; while (--count > 0);
            }
            return j;
        }


        /// <summary>
        /// Translates a state to a row index in the transition table
        /// </summary>
        private static readonly int[] ZZ_ROWMAP = ZzUnpackRowMap();

        private const string ZZ_ROWMAP_PACKED_0 =
            "\x0000\x0000\x0000\x0067\x0000\x00CE\x0000\u0135\x0000\u019c\x0000\u0203\x0000\u026a\x0000\u02d1" +
            "\x0000\u0338\x0000\u039f\x0000\u0406\x0000\u046d\x0000\u04d4\x0000\u053b\x0000\u05a2\x0000\u0609" +
            "\x0000\u0670\x0000\u06d7\x0000\u073e\x0000\u07a5\x0000\u080c\x0000\u0873\x0000\u08da\x0000\u0941" +
            "\x0000\u09a8\x0000\u0a0f\x0000\u0a76\x0000\u0add\x0000\x00CE\x0000\u0135\x0000\u019c\x0000\u0203" +
            "\x0000\u026a\x0000\u0b44\x0000\u0bab\x0000\u0c12\x0000\u0c79\x0000\u046d\x0000\u0ce0\x0000\u0d47" +
            "\x0000\u0dae\x0000\u0e15\x0000\u0e7c\x0000\u0ee3\x0000\u0f4a\x0000\u0338\x0000\u039f\x0000\u0fb1" +
            "\x0000\u1018\x0000\u107f\x0000\u10e6\x0000\u114d\x0000\u11b4\x0000\u121b\x0000\u1282\x0000\u12e9" +
            "\x0000\u1350\x0000\u13b7\x0000\u141e\x0000\u1485\x0000\u14ec\x0000\u1553\x0000\u15ba\x0000\u1621" +
            "\x0000\u1688\x0000\u0941\x0000\u16ef\x0000\u1756\x0000\u17bd\x0000\u1824\x0000\u188b\x0000\u18f2" +
            "\x0000\u1959\x0000\u19c0\x0000\u1a27\x0000\u1a8e\x0000\u1af5\x0000\u1b5c\x0000\u1bc3\x0000\u1c2a" +
            "\x0000\u1c91\x0000\u1cf8\x0000\u1d5f\x0000\u1dc6\x0000\u1e2d\x0000\u1e94\x0000\u1efb\x0000\u1f62" +
            "\x0000\u1fc9\x0000\u2030\x0000\u2097\x0000\u20fe\x0000\u2165\x0000\u21cc\x0000\u2233\x0000\u229a" +
            "\x0000\u2301\x0000\u2368\x0000\u23cf\x0000\u2436\x0000\u249d\x0000\u2504\x0000\u256b\x0000\u25d2" +
            "\x0000\u2639\x0000\u26a0\x0000\u2707\x0000\u276e\x0000\u27d5\x0000\u283c\x0000\u28a3\x0000\u290a" +
            "\x0000\u2971\x0000\u29d8\x0000\u2a3f\x0000\u2aa6\x0000\u2b0d\x0000\u2b74\x0000\u2bdb\x0000\u2c42" +
            "\x0000\u2ca9\x0000\u2d10\x0000\u2d77\x0000\u2dde";

        private static int[] ZzUnpackRowMap()
        {
            int[] result = new int[124];
            int offset = 0;
            offset = ZzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackRowMap(string packed, int offset, int[] result)
        {
            int i = 0;  /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int high = packed[i++] << 16;
                result[j++] = high | packed[i++];
            }
            return j;
        }

        /// <summary>
        /// The transition table of the DFA
        /// </summary>
        private static readonly int[] ZZ_TRANS = ZzUnpackTrans();

        private const string ZZ_TRANS_PACKED_0 =
            "\x0001\x0002\x0001\x0003\x0001\x0002\x0001\x0004\x0001\x0002\x0001\x0005\x0001\x0002\x0001\x0006" +
            "\x0001\x0002\x0001\x0007\x0001\x0002\x0001\x0008\x0003\x0002\x0001\x0009\x0005\x0002\x0001\x000A" +
            "\x0003\x0002\x0001\x000B\x0009\x0002\x0001\x000C\x0002\x0002\x0001\x000D\x0023\x0002\x0001\x000E" +
            "\x0001\x0002\x0001\x000F\x0003\x0002\x0001\x0010\x0001\x0011\x0001\x0002\x0001\x0012\x0001\x0002" +
            "\x0001\x0013\x0002\x0002\x0001\x0014\x0001\x0002\x0001\x0015\x0001\x0002\x0001\x0016\x0001\x0017" +
            "\x0003\x0002\x0001\x0018\x0002\x0019\x0001\x001A\x0001\x001B\x0001\x001C\x0069\x0000\x0001\x0015" +
            "\x0009\x0000\x0001\x0015\x0010\x0000\x0001\x0015\x0012\x0000\x0001\x0015\x0008\x0000\x0003\x0015" +
            "\x000F\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015" +
            "\x0001\x0000\x0005\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0009\x0015\x0001\x0000\x0002\x0015" +
            "\x0001\x0000\x000E\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0011\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0003\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0002\x0015" +
            "\x0001\x0000\x0001\x0015\x000F\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000\x0002\x0015" +
            "\x0003\x0000\x0001\x0015\x000B\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000\x0002\x0015" +
            "\x0004\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015" +
            "\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x000D\x0000\x0001\x0015\x0008\x0000\x0001\x0015" +
            "\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0003\x0015\x0002\x0000\x0004\x0015\x0001\x0000\x0003\x0015\x0002\x0000\x0003\x0015" +
            "\x0001\x0000\x0004\x0015\x0001\x0000\x0002\x0015\x0002\x0000\x0003\x0015\x0001\x0000\x0009\x0015" +
            "\x0001\x0000\x0002\x0015\x0001\x0000\x000E\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0003\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0002\x0015" +
            "\x0001\x0000\x0001\x0015\x000F\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0003\x0000\x0001\x0015" +
            "\x0001\x0000\x0003\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0003\x0015" +
            "\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0002\x0015" +
            "\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0002\x0015" +
            "\x0001\x0000\x0002\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0005\x0015\x0001\x0000\x0005\x0015" +
            "\x0001\x0000\x0002\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015" +
            "\x0004\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0019\x0000\x0003\x0015\x0005\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x000C\x0000\x0001\x0015" +
            "\x0005\x0000\x0001\x0015\x0009\x0000\x0002\x0015\x000A\x0000\x0001\x0016\x0001\x0000\x0002\x0015" +
            "\x000A\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0001\x0000\x0001\x0016\x0007\x0000\x0002\x0015" +
            "\x0002\x0000\x0005\x0015\x0002\x0000\x0002\x0015\x0004\x0000\x0006\x0015\x0001\x0000\x0002\x0015" +
            "\x0004\x0000\x0005\x0015\x0001\x0000\x0005\x0015\x0001\x0000\x0002\x0015\x0001\x0000\x0003\x0015" +
            "\x0001\x0000\x0004\x0015\x0001\x0000\x0005\x0015\x0001\x0016\x0001\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0001\x0000\x0003\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0002\x0000\x0001\x0015\x000F\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000" +
            "\x0002\x0015\x0003\x0000\x0001\x0015\x0004\x0000\x0003\x0015\x0004\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0004\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015\x0005\x0000\x0003\x0015\x0001\x0000" +
            "\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0016\x0001\x0000\x0001\x0015\x0008\x0000" +
            "\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0006\x0000\x0002\x0015\x0005\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0009\x0015\x0002\x0000" +
            "\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0006\x0015\x0002\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0001\x0000\x0003\x0015\x0003\x0000\x0002\x0015\x0004\x0000\x0003\x0015\x0001\x0000" +
            "\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015\x0009\x0000" +
            "\x0002\x0015\x000F\x0000\x0001\x0015\x0006\x0000\x0002\x0015\x0004\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x0002\x0000\x0001\x0015\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x000D\x0000" +
            "\x0001\x0015\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x0007\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0002\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0046\x0000\x0001\x001B\x0011\x0000\x0001\x0017\x001D\x0000" +
            "\x0001\x001A\x0003\x0000\x0001\x001A\x0003\x0000\x0001\x001A\x0001\x0000\x0003\x001A\x0002\x0000" +
            "\x0001\x001A\x0002\x0000\x0001\x001A\x0001\x0000\x0003\x001A\x0003\x0000\x0002\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0002\x001A\x0003\x0000\x0002\x001A\x0001\x0000" +
            "\x0001\x001A\x0003\x0000\x0002\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0002\x001A\x0001\x0000" +
            "\x0005\x001A\x0001\x0000\x0005\x001A\x0002\x0000\x0001\x001A\x0001\x0000\x0002\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0003\x001A\x0004\x0000\x0001\x001A\x0004\x0000\x0001\x001A\x000F\x0000" +
            "\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0003\x001A\x0001\x0000\x0005\x001A\x0001\x0000\x0003\x001A\x0001\x0000" +
            "\x0009\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x000E\x001A\x0001\x0000\x0002\x001A\x0001\x0000" +
            "\x0011\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0003\x001A\x0002\x0000\x0001\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0001\x001A\x000F\x0000\x0001\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0001\x001A\x0003\x0000\x0001\x001A\x0001\x0000\x0003\x001A\x0001\x0000" +
            "\x0002\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0003\x001A\x0001\x0000\x0009\x001A\x0001\x0000" +
            "\x0002\x001A\x0001\x0000\x000E\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0011\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0003\x001A\x0002\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000" +
            "\x0002\x001A\x0001\x0000\x0001\x001A\x000F\x0000\x0001\x001A\x0009\x0000\x0001\x001A\x0010\x0000" +
            "\x0001\x001A\x001B\x0000\x0001\x001A\x0011\x0000\x0001\x001A\x0008\x0000\x0001\x001A\x0014\x0000" +
            "\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000" +
            "\x0001\x001A\x0001\x0000\x0003\x001A\x0001\x0000\x0005\x001A\x0001\x0000\x0003\x001A\x0001\x0000" +
            "\x0006\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0008\x001A\x0001\x0000" +
            "\x0005\x001A\x0001\x0000\x0002\x001A\x0001\x0000\x0011\x001A\x0001\x0000\x0001\x001A\x0001\x0000" +
            "\x0003\x001A\x0002\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0001\x0000\x0002\x001A\x0001\x0000" +
            "\x0001\x001A\x0066\x0000\x0001\x001B\x000E\x0000\x0001\x001D\x0001\x0000\x0001\x001E\x0001\x0000" +
            "\x0001\x001F\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x0022\x0003\x0000" +
            "\x0001\x0023\x0005\x0000\x0001\x0024\x0003\x0000\x0001\x0025\x0009\x0000\x0001\x0026\x0002\x0000" +
            "\x0001\x0027\x000E\x0000\x0001\x0028\x0002\x0000\x0001\x0029\x0021\x0000\x0002\x0015\x0001\x002A" +
            "\x0001\x0000\x0001\x002B\x0001\x0000\x0001\x002B\x0001\x002C\x0001\x0000\x0001\x0015\x0002\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001E\x0001\x0000\x0001\x001F\x0001\x0000" +
            "\x0001\x0020\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x002D\x0003\x0000\x0001\x002E\x0005\x0000" +
            "\x0001\x002F\x0003\x0000\x0001\x0030\x0009\x0000\x0001\x0026\x0002\x0000\x0001\x0031\x000E\x0000" +
            "\x0001\x0032\x0002\x0000\x0001\x0033\x0021\x0000\x0001\x0015\x0002\x0016\x0002\x0000\x0002\x0034" +
            "\x0001\x0035\x0001\x0000\x0001\x0016\x0002\x0000\x0001\x0015\x000B\x0000\x0001\x0036\x000D\x0000" +
            "\x0001\x0037\x000C\x0000\x0001\x0038\x000E\x0000\x0001\x0039\x0002\x0000\x0001\x003A\x0011\x0000" +
            "\x0001\x003B\x0010\x0000\x0001\x0017\x0001\x0000\x0001\x0017\x0003\x0000\x0001\x002C\x0001\x0000" +
            "\x0001\x0017\x0004\x0000\x0001\x001D\x0001\x0000\x0001\x001E\x0001\x0000\x0001\x001F\x0001\x0000" +
            "\x0001\x0020\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x003C\x0003\x0000\x0001\x002E\x0005\x0000" +
            "\x0001\x002F\x0003\x0000\x0001\x003D\x0009\x0000\x0001\x0026\x0002\x0000\x0001\x003E\x000E\x0000" +
            "\x0001\x003F\x0002\x0000\x0001\x0040\x0011\x0000\x0001\x0041\x000F\x0000\x0001\x0015\x0001\x0042" +
            "\x0001\x0016\x0001\x0043\x0003\x0000\x0001\x0042\x0001\x0000\x0001\x0042\x0002\x0000\x0001\x0015" +
            "\x0062\x0000\x0002\x0019\x000E\x0000\x0001\x0044\x000D\x0000\x0001\x0045\x000C\x0000\x0001\x0046" +
            "\x000E\x0000\x0001\x0047\x0002\x0000\x0001\x0048\x0022\x0000\x0001\x001A\x0007\x0000\x0001\x001A" +
            "\x000E\x0000\x0001\x0049\x000D\x0000\x0001\x004A\x000C\x0000\x0001\x004B\x000E\x0000\x0001\x004C" +
            "\x0002\x0000\x0001\x004D\x0022\x0000\x0001\x001B\x0007\x0000\x0001\x001B\x0004\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001E\x0001\x0000\x0001\x001F\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021" +
            "\x0001\x0000\x0001\x004E\x0003\x0000\x0001\x0023\x0005\x0000\x0001\x0024\x0003\x0000\x0001\x004F" +
            "\x0009\x0000\x0001\x0026\x0002\x0000\x0001\x0050\x000E\x0000\x0001\x0051\x0002\x0000\x0001\x0052" +
            "\x0021\x0000\x0001\x0015\x0001\x001C\x0001\x002A\x0001\x0000\x0001\x002B\x0001\x0000\x0001\x002B" +
            "\x0001\x002C\x0001\x0000\x0001\x001C\x0002\x0000\x0001\x001C\x0002\x0000\x0001\x0015\x0009\x0000" +
            "\x0003\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000" +
            "\x0001\x0015\x0004\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0004\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x0003\x0000\x0001\x0015\x0004\x0000\x0005\x0015\x0008\x0000\x0001\x002A\x0001\x0000" +
            "\x0002\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x002A\x0007\x0000\x0002\x0015\x0002\x0000\x0005\x0015\x0002\x0000\x0002\x0015\x0004\x0000" +
            "\x0006\x0015\x0001\x0000\x0002\x0015\x0004\x0000\x0005\x0015\x0001\x0000\x0005\x0015\x0001\x0000" +
            "\x0002\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0004\x0015\x0001\x0000\x0005\x0015\x0001\x002A" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015\x0002\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x000F\x0000\x0001\x0015" +
            "\x0003\x0000\x0001\x0015\x0005\x0000\x0002\x0015\x0003\x0000\x0001\x0015\x0004\x0000\x0003\x0015" +
            "\x0004\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0002\x0015" +
            "\x0004\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015" +
            "\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x002A" +
            "\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015" +
            "\x0006\x0000\x0002\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0009\x0015\x0002\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0006\x0015" +
            "\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0002\x0015\x0004\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015" +
            "\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000\x0001\x0015" +
            "\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0005\x0000\x0003\x0015" +
            "\x0005\x0000\x0001\x0015\x0002\x0000\x0002\x0015\x0004\x0000\x0001\x0015\x0002\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0043\x0000\x0002\x0015\x0006\x0000\x0001\x0015\x002E\x0000\x0001\x0015" +
            "\x0003\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000\x0001\x0015" +
            "\x0007\x0000\x0001\x0015\x0004\x0000\x0002\x0015\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015" +
            "\x0004\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0002\x0000\x0002\x0015\x0001\x0000\x0003\x0015" +
            "\x0001\x0000\x0001\x0015\x0002\x0000\x0004\x0015\x0002\x0000\x0001\x0015\x0021\x0000\x0001\x001D" +
            "\x0001\x0000\x0001\x001E\x0001\x0000\x0001\x001F\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021" +
            "\x0001\x0000\x0001\x0053\x0003\x0000\x0001\x0023\x0005\x0000\x0001\x0024\x0003\x0000\x0001\x0054" +
            "\x0009\x0000\x0001\x0026\x0002\x0000\x0001\x0055\x000E\x0000\x0001\x0056\x0002\x0000\x0001\x0057" +
            "\x0021\x0000\x0001\x0015\x0002\x002A\x0002\x0000\x0002\x0058\x0001\x002C\x0001\x0000\x0001\x002A" +
            "\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001E\x0001\x0000\x0001\x001F" +
            "\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x0059\x0003\x0000\x0001\x005A" +
            "\x0005\x0000\x0001\x005B\x0003\x0000\x0001\x005C\x0009\x0000\x0001\x0026\x0002\x0000\x0001\x005D" +
            "\x000E\x0000\x0001\x005E\x0002\x0000\x0001\x005F\x0021\x0000\x0001\x0015\x0001\x002B\x0007\x0000" +
            "\x0001\x002B\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x001D\x0001\x0000\x0001\x001E\x0001\x0000" +
            "\x0001\x001F\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x0060\x0003\x0000" +
            "\x0001\x0023\x0005\x0000\x0001\x0024\x0003\x0000\x0001\x0061\x0009\x0000\x0001\x0026\x0002\x0000" +
            "\x0001\x0062\x000E\x0000\x0001\x0063\x0002\x0000\x0001\x0064\x0011\x0000\x0001\x0041\x000F\x0000" +
            "\x0001\x0015\x0001\x002C\x0001\x002A\x0001\x0043\x0003\x0000\x0001\x002C\x0001\x0000\x0001\x002C" +
            "\x0002\x0000\x0001\x0015\x0002\x0000\x0001\x0016\x0009\x0000\x0003\x0015\x0005\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0001\x0016" +
            "\x0001\x0000\x0002\x0016\x0004\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0003\x0000\x0001\x0016" +
            "\x0004\x0000\x0001\x0016\x0002\x0015\x0002\x0016\x0008\x0000\x0001\x0016\x0001\x0000\x0002\x0015" +
            "\x0001\x0000\x0001\x0016\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015" +
            "\x0006\x0000\x0002\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0009\x0015\x0002\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0006\x0015" +
            "\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0001\x0016" +
            "\x0001\x0000\x0002\x0015\x0004\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015" +
            "\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000\x0001\x0015" +
            "\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0005\x0000\x0001\x0015" +
            "\x0002\x0016\x0005\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0016\x0004\x0000\x0001\x0015" +
            "\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0043\x0000\x0002\x0016\x0006\x0000\x0001\x0016" +
            "\x002E\x0000\x0001\x0016\x0003\x0000\x0001\x0016\x0002\x0000\x0001\x0016\x0003\x0000\x0001\x0016" +
            "\x0005\x0000\x0001\x0016\x0007\x0000\x0001\x0016\x0004\x0000\x0002\x0016\x0003\x0000\x0002\x0016" +
            "\x0001\x0000\x0001\x0016\x0004\x0000\x0001\x0016\x0001\x0000\x0001\x0016\x0002\x0000\x0002\x0016" +
            "\x0001\x0000\x0003\x0016\x0001\x0000\x0001\x0016\x0002\x0000\x0004\x0016\x0002\x0000\x0001\x0016" +
            "\x002B\x0000\x0001\x0065\x0003\x0000\x0001\x0066\x0005\x0000\x0001\x0067\x0003\x0000\x0001\x0068" +
            "\x000C\x0000\x0001\x0069\x000E\x0000\x0001\x006A\x0002\x0000\x0001\x006B\x0022\x0000\x0001\x0034" +
            "\x0001\x0016\x0006\x0000\x0001\x0034\x0004\x0000\x0001\x001D\x0001\x0000\x0001\x001E\x0001\x0000" +
            "\x0001\x001F\x0001\x0000\x0001\x0020\x0001\x0000\x0001\x0021\x0001\x0000\x0001\x006C\x0003\x0000" +
            "\x0001\x002E\x0005\x0000\x0001\x002F\x0003\x0000\x0001\x006D\x0009\x0000\x0001\x0026\x0002\x0000" +
            "\x0001\x006E\x000E\x0000\x0001\x006F\x0002\x0000\x0001\x0070\x0011\x0000\x0001\x0041\x000F\x0000" +
            "\x0001\x0015\x0001\x0035\x0001\x0016\x0001\x0043\x0003\x0000\x0001\x0035\x0001\x0000\x0001\x0035" +
            "\x0002\x0000\x0001\x0015\x0002\x0000\x0001\x0017\x001F\x0000\x0001\x0017\x0001\x0000\x0002\x0017" +
            "\x000E\x0000\x0001\x0017\x0004\x0000\x0001\x0017\x0002\x0000\x0002\x0017\x000D\x0000\x0001\x0017" +
            "\x005A\x0000\x0001\x0017\x006B\x0000\x0002\x0017\x0009\x0000\x0001\x0017\x004D\x0000\x0002\x0017" +
            "\x0006\x0000\x0001\x0017\x002E\x0000\x0001\x0017\x0003\x0000\x0001\x0017\x0002\x0000\x0001\x0017" +
            "\x0003\x0000\x0001\x0017\x0005\x0000\x0001\x0017\x0007\x0000\x0001\x0017\x0004\x0000\x0002\x0017" +
            "\x0003\x0000\x0002\x0017\x0001\x0000\x0001\x0017\x0004\x0000\x0001\x0017\x0001\x0000\x0001\x0017" +
            "\x0002\x0000\x0002\x0017\x0001\x0000\x0003\x0017\x0001\x0000\x0001\x0017\x0002\x0000\x0004\x0017" +
            "\x0002\x0000\x0001\x0017\x006B\x0000\x0001\x0017\x001D\x0000\x0001\x0042\x0009\x0000\x0003\x0015" +
            "\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000\x0001\x0015" +
            "\x0004\x0000\x0001\x0042\x0001\x0000\x0002\x0042\x0004\x0000\x0001\x0015\x0005\x0000\x0001\x0015" +
            "\x0003\x0000\x0001\x0042\x0004\x0000\x0001\x0042\x0002\x0015\x0002\x0042\x0008\x0000\x0001\x0016" +
            "\x0001\x0000\x0002\x0015\x0001\x0000\x0001\x0042\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015" +
            "\x0003\x0000\x0001\x0015\x0006\x0000\x0002\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0009\x0015\x0002\x0000\x0001\x0015\x0004\x0000\x0001\x0015" +
            "\x0004\x0000\x0006\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015" +
            "\x0001\x0000\x0001\x0042\x0001\x0000\x0002\x0015\x0004\x0000\x0003\x0015\x0001\x0000\x0001\x0015" +
            "\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015\x0003\x0000\x0001\x0015" +
            "\x0005\x0000\x0001\x0015\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015" +
            "\x0005\x0000\x0001\x0015\x0002\x0042\x0005\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0042" +
            "\x0004\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0043\x0000\x0002\x0042" +
            "\x0006\x0000\x0001\x0042\x002E\x0000\x0001\x0042\x0003\x0000\x0001\x0042\x0002\x0000\x0001\x0042" +
            "\x0003\x0000\x0001\x0042\x0005\x0000\x0001\x0042\x0007\x0000\x0001\x0042\x0004\x0000\x0002\x0042" +
            "\x0003\x0000\x0002\x0042\x0001\x0000\x0001\x0042\x0004\x0000\x0001\x0042\x0001\x0000\x0001\x0042" +
            "\x0002\x0000\x0002\x0042\x0001\x0000\x0003\x0042\x0001\x0000\x0001\x0042\x0002\x0000\x0004\x0042" +
            "\x0002\x0000\x0001\x0042\x006B\x0000\x0001\x0043\x0026\x0000\x0001\x0071\x000D\x0000\x0001\x0072" +
            "\x000C\x0000\x0001\x0073\x000E\x0000\x0001\x0074\x0002\x0000\x0001\x0075\x0011\x0000\x0001\x0041" +
            "\x0010\x0000\x0001\x0043\x0001\x0000\x0001\x0043\x0003\x0000\x0001\x002C\x0001\x0000\x0001\x0043" +
            "\x0005\x0000\x0001\x001A\x001F\x0000\x0001\x001A\x0001\x0000\x0002\x001A\x000E\x0000\x0001\x001A" +
            "\x0004\x0000\x0001\x001A\x0002\x0000\x0002\x001A\x000D\x0000\x0001\x001A\x005A\x0000\x0001\x001A" +
            "\x006B\x0000\x0002\x001A\x0009\x0000\x0001\x001A\x004D\x0000\x0002\x001A\x0006\x0000\x0001\x001A" +
            "\x002E\x0000\x0001\x001A\x0003\x0000\x0001\x001A\x0002\x0000\x0001\x001A\x0003\x0000\x0001\x001A" +
            "\x0005\x0000\x0001\x001A\x0007\x0000\x0001\x001A\x0004\x0000\x0002\x001A\x0003\x0000\x0002\x001A" +
            "\x0001\x0000\x0001\x001A\x0004\x0000\x0001\x001A\x0001\x0000\x0001\x001A\x0002\x0000\x0002\x001A" +
            "\x0001\x0000\x0003\x001A\x0001\x0000\x0001\x001A\x0002\x0000\x0004\x001A\x0002\x0000\x0001\x001A" +
            "\x0022\x0000\x0001\x001B\x001F\x0000\x0001\x001B\x0001\x0000\x0002\x001B\x000E\x0000\x0001\x001B" +
            "\x0004\x0000\x0001\x001B\x0002\x0000\x0002\x001B\x000D\x0000\x0001\x001B\x005A\x0000\x0001\x001B" +
            "\x006B\x0000\x0002\x001B\x0009\x0000\x0001\x001B\x004D\x0000\x0002\x001B\x0006\x0000\x0001\x001B" +
            "\x002E\x0000\x0001\x001B\x0003\x0000\x0001\x001B\x0002\x0000\x0001\x001B\x0003\x0000\x0001\x001B" +
            "\x0005\x0000\x0001\x001B\x0007\x0000\x0001\x001B\x0004\x0000\x0002\x001B\x0003\x0000\x0002\x001B" +
            "\x0001\x0000\x0001\x001B\x0004\x0000\x0001\x001B\x0001\x0000\x0001\x001B\x0002\x0000\x0002\x001B" +
            "\x0001\x0000\x0003\x001B\x0001\x0000\x0001\x001B\x0002\x0000\x0004\x001B\x0002\x0000\x0001\x001B" +
            "\x0022\x0000\x0001\x001C\x0009\x0000\x0003\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0001\x001C\x0001\x0000\x0002\x001C" +
            "\x0004\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0003\x0000\x0001\x001C\x0004\x0000\x0001\x001C" +
            "\x0002\x0015\x0002\x001C\x0008\x0000\x0001\x002A\x0001\x0000\x0002\x0015\x0001\x0000\x0001\x001C" +
            "\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0006\x0000\x0002\x0015" +
            "\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0009\x0015" +
            "\x0002\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0006\x0015\x0002\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0001\x001C\x0001\x0000\x0002\x0015" +
            "\x0004\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0015" +
            "\x0011\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x001A\x0000\x000D\x0015" +
            "\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0002\x001C\x0005\x0000" +
            "\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x001C\x0004\x0000\x0001\x0015\x0002\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0043\x0000\x0002\x001C\x0006\x0000\x0001\x001C\x002E\x0000\x0001\x001C" +
            "\x0003\x0000\x0001\x001C\x0002\x0000\x0001\x001C\x0003\x0000\x0001\x001C\x0005\x0000\x0001\x001C" +
            "\x0007\x0000\x0001\x001C\x0004\x0000\x0002\x001C\x0003\x0000\x0002\x001C\x0001\x0000\x0001\x001C" +
            "\x0004\x0000\x0001\x001C\x0001\x0000\x0001\x001C\x0002\x0000\x0002\x001C\x0001\x0000\x0003\x001C" +
            "\x0001\x0000\x0001\x001C\x0002\x0000\x0004\x001C\x0002\x0000\x0001\x001C\x0022\x0000\x0001\x002A" +
            "\x0009\x0000\x0003\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0004\x0000\x0001\x0015\x0004\x0000\x0001\x002A\x0001\x0000\x0002\x002A\x0004\x0000\x0001\x0015" +
            "\x0005\x0000\x0001\x0015\x0003\x0000\x0001\x002A\x0004\x0000\x0001\x002A\x0002\x0015\x0002\x002A" +
            "\x0008\x0000\x0001\x002A\x0001\x0000\x0002\x0015\x0001\x0000\x0001\x002A\x0008\x0000\x0001\x0015" +
            "\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0006\x0000\x0002\x0015\x0005\x0000\x0001\x0015" +
            "\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0009\x0015\x0002\x0000\x0001\x0015" +
            "\x0004\x0000\x0001\x0015\x0004\x0000\x0006\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0001\x0000\x0003\x0015\x0001\x0000\x0001\x002A\x0001\x0000\x0002\x0015\x0004\x0000\x0003\x0015" +
            "\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015" +
            "\x0003\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015" +
            "\x0001\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0002\x002A\x0005\x0000\x0001\x0015\x0002\x0000" +
            "\x0001\x0015\x0001\x002A\x0004\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015" +
            "\x0043\x0000\x0002\x002A\x0006\x0000\x0001\x002A\x002E\x0000\x0001\x002A\x0003\x0000\x0001\x002A" +
            "\x0002\x0000\x0001\x002A\x0003\x0000\x0001\x002A\x0005\x0000\x0001\x002A\x0007\x0000\x0001\x002A" +
            "\x0004\x0000\x0002\x002A\x0003\x0000\x0002\x002A\x0001\x0000\x0001\x002A\x0004\x0000\x0001\x002A" +
            "\x0001\x0000\x0001\x002A\x0002\x0000\x0002\x002A\x0001\x0000\x0003\x002A\x0001\x0000\x0001\x002A" +
            "\x0002\x0000\x0004\x002A\x0002\x0000\x0001\x002A\x002B\x0000\x0001\x0076\x0003\x0000\x0001\x0077" +
            "\x0005\x0000\x0001\x0078\x0003\x0000\x0001\x0079\x000C\x0000\x0001\x007A\x000E\x0000\x0001\x007B" +
            "\x0002\x0000\x0001\x007C\x0022\x0000\x0001\x0058\x0001\x002A\x0006\x0000\x0001\x0058\x0005\x0000" +
            "\x0001\x002B\x0009\x0000\x0003\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0001\x002B\x0001\x0000\x0002\x002B\x0004\x0000" +
            "\x0001\x0015\x0005\x0000\x0001\x0015\x0003\x0000\x0001\x002B\x0004\x0000\x0001\x002B\x0002\x0015" +
            "\x0002\x002B\x000A\x0000\x0002\x0015\x0001\x0000\x0001\x002B\x0008\x0000\x0001\x0015\x0014\x0000" +
            "\x0001\x0015\x0009\x0000\x0002\x0015\x0002\x0000\x0005\x0015\x0002\x0000\x0002\x0015\x0004\x0000" +
            "\x0006\x0015\x0001\x0000\x0002\x0015\x0004\x0000\x0005\x0015\x0001\x0000\x0005\x0015\x0001\x0000" +
            "\x0002\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0004\x0015\x0001\x0000\x0005\x0015\x0002\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015\x0002\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x000F\x0000\x0001\x0015\x0003\x0000" +
            "\x0001\x0015\x0005\x0000\x0002\x0015\x0003\x0000\x0001\x0015\x0004\x0000\x0003\x0015\x0004\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0004\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0003\x0000\x0002\x0015\x0001\x0000\x0001\x0015\x0005\x0000" +
            "\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0008\x0000" +
            "\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0006\x0000\x0002\x0015\x0005\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0009\x0015\x0002\x0000" +
            "\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000\x0006\x0015\x0002\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0001\x0000\x0003\x0015\x0001\x0000\x0001\x002B\x0001\x0000\x0002\x0015\x0004\x0000" +
            "\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0011\x0000" +
            "\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x001A\x0000\x000D\x0015\x0005\x0000" +
            "\x0003\x0015\x0001\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0002\x002B\x0005\x0000\x0001\x0015" +
            "\x0002\x0000\x0001\x0015\x0001\x002B\x0004\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0043\x0000\x0002\x002B\x0006\x0000\x0001\x002B\x002E\x0000\x0001\x002B\x0003\x0000" +
            "\x0001\x002B\x0002\x0000\x0001\x002B\x0003\x0000\x0001\x002B\x0005\x0000\x0001\x002B\x0007\x0000" +
            "\x0001\x002B\x0004\x0000\x0002\x002B\x0003\x0000\x0002\x002B\x0001\x0000\x0001\x002B\x0004\x0000" +
            "\x0001\x002B\x0001\x0000\x0001\x002B\x0002\x0000\x0002\x002B\x0001\x0000\x0003\x002B\x0001\x0000" +
            "\x0001\x002B\x0002\x0000\x0004\x002B\x0002\x0000\x0001\x002B\x0022\x0000\x0001\x002C\x0009\x0000" +
            "\x0003\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000" +
            "\x0001\x0015\x0004\x0000\x0001\x002C\x0001\x0000\x0002\x002C\x0004\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x0003\x0000\x0001\x002C\x0004\x0000\x0001\x002C\x0002\x0015\x0002\x002C\x0008\x0000" +
            "\x0001\x002A\x0001\x0000\x0002\x0015\x0001\x0000\x0001\x002C\x0008\x0000\x0001\x0015\x0014\x0000" +
            "\x0001\x0015\x0003\x0000\x0001\x0015\x0006\x0000\x0002\x0015\x0005\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0009\x0015\x0002\x0000\x0001\x0015\x0004\x0000" +
            "\x0001\x0015\x0004\x0000\x0006\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000" +
            "\x0003\x0015\x0001\x0000\x0001\x002C\x0001\x0000\x0002\x0015\x0004\x0000\x0003\x0015\x0001\x0000" +
            "\x0001\x0015\x0008\x0000\x0001\x0015\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015\x0003\x0000" +
            "\x0001\x0015\x0005\x0000\x0001\x0015\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015\x0001\x0000" +
            "\x0001\x0015\x0005\x0000\x0001\x0015\x0002\x002C\x0005\x0000\x0001\x0015\x0002\x0000\x0001\x0015" +
            "\x0001\x002C\x0004\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0043\x0000" +
            "\x0002\x002C\x0006\x0000\x0001\x002C\x002E\x0000\x0001\x002C\x0003\x0000\x0001\x002C\x0002\x0000" +
            "\x0001\x002C\x0003\x0000\x0001\x002C\x0005\x0000\x0001\x002C\x0007\x0000\x0001\x002C\x0004\x0000" +
            "\x0002\x002C\x0003\x0000\x0002\x002C\x0001\x0000\x0001\x002C\x0004\x0000\x0001\x002C\x0001\x0000" +
            "\x0001\x002C\x0002\x0000\x0002\x002C\x0001\x0000\x0003\x002C\x0001\x0000\x0001\x002C\x0002\x0000" +
            "\x0004\x002C\x0002\x0000\x0001\x002C\x0022\x0000\x0001\x0034\x001F\x0000\x0001\x0034\x0001\x0000" +
            "\x0002\x0034\x000E\x0000\x0001\x0034\x0004\x0000\x0001\x0034\x0002\x0000\x0002\x0034\x0008\x0000" +
            "\x0001\x0016\x0004\x0000\x0001\x0034\x001F\x0000\x0001\x0016\x0042\x0000\x0001\x0016\x0067\x0000" +
            "\x0002\x0016\x005C\x0000\x0001\x0034\x006B\x0000\x0002\x0034\x0009\x0000\x0001\x0034\x004D\x0000" +
            "\x0002\x0034\x0006\x0000\x0001\x0034\x002E\x0000\x0001\x0034\x0003\x0000\x0001\x0034\x0002\x0000" +
            "\x0001\x0034\x0003\x0000\x0001\x0034\x0005\x0000\x0001\x0034\x0007\x0000\x0001\x0034\x0004\x0000" +
            "\x0002\x0034\x0003\x0000\x0002\x0034\x0001\x0000\x0001\x0034\x0004\x0000\x0001\x0034\x0001\x0000" +
            "\x0001\x0034\x0002\x0000\x0002\x0034\x0001\x0000\x0003\x0034\x0001\x0000\x0001\x0034\x0002\x0000" +
            "\x0004\x0034\x0002\x0000\x0001\x0034\x0022\x0000\x0001\x0035\x0009\x0000\x0003\x0015\x0005\x0000" +
            "\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000" +
            "\x0001\x0035\x0001\x0000\x0002\x0035\x0004\x0000\x0001\x0015\x0005\x0000\x0001\x0015\x0003\x0000" +
            "\x0001\x0035\x0004\x0000\x0001\x0035\x0002\x0015\x0002\x0035\x0008\x0000\x0001\x0016\x0001\x0000" +
            "\x0002\x0015\x0001\x0000\x0001\x0035\x0008\x0000\x0001\x0015\x0014\x0000\x0001\x0015\x0003\x0000" +
            "\x0001\x0015\x0006\x0000\x0002\x0015\x0005\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000" +
            "\x0001\x0015\x0001\x0000\x0009\x0015\x0002\x0000\x0001\x0015\x0004\x0000\x0001\x0015\x0004\x0000" +
            "\x0006\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0001\x0000\x0003\x0015\x0001\x0000" +
            "\x0001\x0035\x0001\x0000\x0002\x0015\x0004\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0008\x0000" +
            "\x0001\x0015\x0001\x0000\x0002\x0015\x0011\x0000\x0001\x0015\x0003\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x001A\x0000\x000D\x0015\x0005\x0000\x0003\x0015\x0001\x0000\x0001\x0015\x0005\x0000" +
            "\x0001\x0015\x0002\x0035\x0005\x0000\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0035\x0004\x0000" +
            "\x0001\x0015\x0002\x0000\x0001\x0015\x0001\x0000\x0001\x0015\x0043\x0000\x0002\x0035\x0006\x0000" +
            "\x0001\x0035\x002E\x0000\x0001\x0035\x0003\x0000\x0001\x0035\x0002\x0000\x0001\x0035\x0003\x0000" +
            "\x0001\x0035\x0005\x0000\x0001\x0035\x0007\x0000\x0001\x0035\x0004\x0000\x0002\x0035\x0003\x0000" +
            "\x0002\x0035\x0001\x0000\x0001\x0035\x0004\x0000\x0001\x0035\x0001\x0000\x0001\x0035\x0002\x0000" +
            "\x0002\x0035\x0001\x0000\x0003\x0035\x0001\x0000\x0001\x0035\x0002\x0000\x0004\x0035\x0002\x0000" +
            "\x0001\x0035\x0022\x0000\x0001\x0043\x001F\x0000\x0001\x0043\x0001\x0000\x0002\x0043\x000E\x0000" +
            "\x0001\x0043\x0004\x0000\x0001\x0043\x0002\x0000\x0002\x0043\x000D\x0000\x0001\x0043\x005A\x0000" +
            "\x0001\x0043\x006B\x0000\x0002\x0043\x0009\x0000\x0001\x0043\x004D\x0000\x0002\x0043\x0006\x0000" +
            "\x0001\x0043\x002E\x0000\x0001\x0043\x0003\x0000\x0001\x0043\x0002\x0000\x0001\x0043\x0003\x0000" +
            "\x0001\x0043\x0005\x0000\x0001\x0043\x0007\x0000\x0001\x0043\x0004\x0000\x0002\x0043\x0003\x0000" +
            "\x0002\x0043\x0001\x0000\x0001\x0043\x0004\x0000\x0001\x0043\x0001\x0000\x0001\x0043\x0002\x0000" +
            "\x0002\x0043\x0001\x0000\x0003\x0043\x0001\x0000\x0001\x0043\x0002\x0000\x0004\x0043\x0002\x0000" +
            "\x0001\x0043\x0022\x0000\x0001\x0058\x001F\x0000\x0001\x0058\x0001\x0000\x0002\x0058\x000E\x0000" +
            "\x0001\x0058\x0004\x0000\x0001\x0058\x0002\x0000\x0002\x0058\x0008\x0000\x0001\x002A\x0004\x0000" +
            "\x0001\x0058\x001F\x0000\x0001\x002A\x0042\x0000\x0001\x002A\x0067\x0000\x0002\x002A\x005C\x0000" +
            "\x0001\x0058\x006B\x0000\x0002\x0058\x0009\x0000\x0001\x0058\x004D\x0000\x0002\x0058\x0006\x0000" +
            "\x0001\x0058\x002E\x0000\x0001\x0058\x0003\x0000\x0001\x0058\x0002\x0000\x0001\x0058\x0003\x0000" +
            "\x0001\x0058\x0005\x0000\x0001\x0058\x0007\x0000\x0001\x0058\x0004\x0000\x0002\x0058\x0003\x0000" +
            "\x0002\x0058\x0001\x0000\x0001\x0058\x0004\x0000\x0001\x0058\x0001\x0000\x0001\x0058\x0002\x0000" +
            "\x0002\x0058\x0001\x0000\x0003\x0058\x0001\x0000\x0001\x0058\x0002\x0000\x0004\x0058\x0002\x0000" +
            "\x0001\x0058\x0020\x0000";

        private static int[] ZzUnpackTrans()
        {
            int[] result = new int[11845];
            int offset = 0;
            offset = ZzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackTrans(string packed, int offset, int[] result)
        {
            int i = 0;       /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                value--;
                do result[j++] = value; while (--count > 0);
            }
            return j;
        }


        /* error codes */
        private const int ZZ_UNKNOWN_ERROR = 0;
        private const int ZZ_NO_MATCH = 1;
        private const int ZZ_PUSHBACK_2BIG = 2;

        /* error messages for the codes above */
        private static readonly string[] ZZ_ERROR_MSG = {
            "Unkown internal scanner error",
            "Error: could not match input",
            "Error: pushback value was too large"
        };

        /// <summary>
        /// ZZ_ATTRIBUTE[aState] contains the attributes of state <c>aState</c>
        /// </summary>
        private static readonly int[] ZZ_ATTRIBUTE = ZzUnpackAttribute();

        private const string ZZ_ATTRIBUTE_PACKED_0 =
            "\x0001\x0000\x0001\x0009\x001A\x0001\x000D\x0000\x0001\x0001\x0001\x0000\x0001\x0001\x0008\x0000" +
            "\x0001\x0001\x000D\x0000\x0001\x0001\x0039\x0000";

        private static int[] ZzUnpackAttribute()
        {
            int[] result = new int[124];
            int offset = 0;
            offset = ZzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
            return result;
        }

        private static int ZzUnpackAttribute(string packed, int offset, int[] result)
        {
            int i = 0;       /* index in packed string  */
            int j = offset;  /* index in unpacked array */
            int l = packed.Length;
            while (i < l)
            {
                int count = packed[i++];
                int value = packed[i++];
                do result[j++] = value; while (--count > 0);
            }
            return j;
        }

        /// <summary>the input device</summary>
        private TextReader zzReader;

        /// <summary>the current state of the DFA</summary>
        private int zzState;

        /// <summary>the current lexical state</summary>
        private int zzLexicalState = YYINITIAL;

        /// <summary>
        /// this buffer contains the current text to be matched and is
        /// the source of the YyText string
        /// </summary>
        private char[] zzBuffer = new char[ZZ_BUFFERSIZE];

        /// <summary>the textposition at the last accepting state</summary>
        private int zzMarkedPos;

        /// <summary>the current text position in the buffer</summary>
        private int zzCurrentPos;

        /// <summary>startRead marks the beginning of the YyText string in the buffer</summary>
        private int zzStartRead;

        /// <summary>
        /// endRead marks the last character in the buffer, that has been read
        /// from input
        /// </summary>
        private int zzEndRead;

        ///// <summary>number of newlines encountered up to the start of the matched text</summary>
        //private int yyline; // LUCENENET: Never read

        /// <summary>the number of characters up to the start of the matched text</summary>
        private int yyChar;

        ///// <summary>
        ///// the number of characters from the last newline up to the start of the 
        ///// matched text
        ///// </summary>
        //private int yycolumn; // LUCENENET: Never read

        ///// <summary>
        ///// zzAtBOL == true &lt;=&gt; the scanner is currently at the beginning of a line
        ///// </summary>
        //private bool zzAtBOL = true; // LUCENENET: Never read

        /// <summary>zzAtEOF == true &lt;=&gt; the scanner is at the EOF</summary>
        private bool zzAtEOF;

        ///// <summary>denotes if the user-EOF-code has already been executed</summary>
        //private bool zzEOFDone; // LUCENENET: Never read


        /* user code: */
        /// <summary>Alphanumeric sequences</summary>
        public static readonly int WORD_TYPE = StandardTokenizer.ALPHANUM;

        /// <summary>Numbers</summary>
        public static readonly int NUMERIC_TYPE = StandardTokenizer.NUM;

        /// <summary>
        /// Chars in class \p{Line_Break = Complex_Context} are from South East Asian
        /// scripts (Thai, Lao, Myanmar, Khmer, etc.).  Sequences of these are kept 
        /// together as as a single token rather than broken up, because the logic
        /// required to break them at word boundaries is too complex for UAX#29.
        /// <para/>
        /// See Unicode Line Breaking Algorithm: http://www.unicode.org/reports/tr14/#SA
        /// </summary>
        public static readonly int SOUTH_EAST_ASIAN_TYPE = StandardTokenizer.SOUTHEAST_ASIAN;

        public static readonly int IDEOGRAPHIC_TYPE = StandardTokenizer.IDEOGRAPHIC;

        public static readonly int HIRAGANA_TYPE = StandardTokenizer.HIRAGANA;

        public static readonly int KATAKANA_TYPE = StandardTokenizer.KATAKANA;

        public static readonly int HANGUL_TYPE = StandardTokenizer.HANGUL;

        public int YyChar => yyChar;

        /// <summary>
        /// Fills ICharTermAttribute with the current token text.
        /// </summary>
        public void GetText(ICharTermAttribute t)
        {
            t.CopyBuffer(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);
        }

        /// <summary>
        /// Creates a new scanner
        /// </summary>
        /// <param name="in">the TextReader to read input from.</param>
        public StandardTokenizerImpl34(TextReader @in)
        {
            this.zzReader = @in;
        }

        /// <summary>
        /// Unpacks the compressed character translation table.
        /// </summary>
        /// <param name="packed">the packed character translation table</param>
        /// <returns>the unpacked character translation table</returns>
        private static char[] ZzUnpackCMap(string packed)
        {
            char[] map = new char[0x10000];
            int i = 0;  /* index in packed string  */
            int j = 0;  /* index in unpacked array */
            while (i < 2650)
            {
                int count = packed[i++];
                char value = packed[i++];
                do map[j++] = value; while (--count > 0);
            }
            return map;
        }

        /// <summary>
        /// Refills the input buffer.
        /// </summary>
        /// <returns><c>false</c>, iff there was new input.</returns>
        /// <exception cref="IOException">if any I/O-Error occurs</exception>
        private bool ZzRefill()
        {

            /* first: make room (if you can) */
            if (zzStartRead > 0)
            {
                System.Array.Copy(zzBuffer, zzStartRead,
                                 zzBuffer, 0,
                                 zzEndRead - zzStartRead);

                /* translate stored positions */
                zzEndRead -= zzStartRead;
                zzCurrentPos -= zzStartRead;
                zzMarkedPos -= zzStartRead;
                zzStartRead = 0;
            }

            /* is the buffer big enough? */
            if (zzCurrentPos >= zzBuffer.Length)
            {
                /* if not: blow it up */
                char[] newBuffer = new char[zzCurrentPos * 2];
                System.Array.Copy(zzBuffer, 0, newBuffer, 0, zzBuffer.Length);
                zzBuffer = newBuffer;
            }

            /* readonlyly: fill the buffer with new input */
            int numRead = zzReader.Read(zzBuffer, zzEndRead,
                                                    zzBuffer.Length - zzEndRead);

            if (numRead > 0)
            {
                zzEndRead += numRead;
                return false;
            }
            // unlikely but not impossible: read 0 characters, but not at end of stream    
            if (numRead == 0)
            {
                int c = zzReader.Read();
                if (c == -1)
                {
                    return true;
                }
                else
                {
                    zzBuffer[zzEndRead++] = (char)c;
                    return false;
                }
            }

            // numRead < 0
            return true;
        }


        /// <summary>
        /// Disposes the input stream.
        /// </summary>
        public void YyClose()
        {
            zzAtEOF = true;            /* indicate end of file */
            zzEndRead = zzStartRead;  /* invalidate buffer    */

            if (zzReader != null)
                zzReader.Dispose();
        }

        /// <summary>
        /// Resets the scanner to read from a new input stream.
        /// Does not close the old reader.
        /// <para/>
        /// All internal variables are reset, the old input stream 
        /// <b>cannot</b> be reused (internal buffer is discarded and lost).
        /// Lexical state is set to <see cref="YYINITIAL"/>.
        /// <para/>
        /// Internal scan buffer is resized down to its initial length, if it has grown.
        /// </summary>
        /// <param name="reader">the new input stream </param>
        public void YyReset(TextReader reader)
        {
            zzReader = reader;
            //zzAtBOL = true; // LUCENENET: Never read
            zzAtEOF = false;
            //zzEOFDone = false; // LUCENENET: Never read
            zzEndRead = zzStartRead = 0;
            zzCurrentPos = zzMarkedPos = 0;
            //yyline = yyChar = yycolumn = 0; // LUCENENET: Never read
            yyChar = 0;
            zzLexicalState = YYINITIAL;
            if (zzBuffer.Length > ZZ_BUFFERSIZE)
                zzBuffer = new char[ZZ_BUFFERSIZE];
        }


        /// <summary>
        /// Returns the current lexical state.
        /// </summary>
        public int YyState => zzLexicalState;

        /// <summary>
        /// Enters a new lexical state
        /// </summary>
        /// <param name="newState">the new lexical state</param>
        public void YyBegin(int newState)
        {
            zzLexicalState = newState;
        }

        /// <summary>
        /// Returns the text matched by the current regular expression.
        /// </summary>
        public string YyText => new string(zzBuffer, zzStartRead, zzMarkedPos - zzStartRead);

        /// <summary>
        /// Returns the character at position <paramref name="pos"/> from the 
        /// matched text. 
        /// <para/>
        /// It is equivalent to YyText[pos], but faster
        /// </summary>
        /// <param name="pos">
        /// the position of the character to fetch.
        /// A value from 0 to YyLength-1.
        /// </param>
        /// <returns>the character at position pos</returns>
        public char YyCharAt(int pos)
        {
            return zzBuffer[zzStartRead + pos];
        }


        /// <summary>
        /// Returns the length of the matched text region.
        /// </summary>
        public int YyLength => zzMarkedPos - zzStartRead;

        /// <summary>
        /// Reports an error that occured while scanning.
        /// <para/>
        /// In a wellformed scanner (no or only correct usage of 
        /// YyPushBack(int) and a match-all fallback rule) this method 
        /// will only be called with things that "Can't Possibly Happen".
        /// If this method is called, something is seriously wrong
        /// Usual syntax/scanner level error handling should be done
        /// in error fallback rules.
        /// </summary>
        /// <param name="errorCode">the code of the errormessage to display</param>
        private void ZzScanError(int errorCode)
        {
            string message;
            try
            {
                message = ZZ_ERROR_MSG[errorCode];
            }
            catch (IndexOutOfRangeException /*e*/)
            {
                message = ZZ_ERROR_MSG[ZZ_UNKNOWN_ERROR];
            }

            throw new Exception(message);
        }

        /// <summary>
        /// Pushes the specified amount of characters back into the input stream.
        /// <para/>
        /// They will be read again by then next call of the scanning method
        /// </summary>
        /// <param name="number">
        /// the number of characters to be read again.
        /// This number must not be greater than YyLength!
        /// </param>
        public void YyPushBack(int number)
        {
            if (number > YyLength)
                ZzScanError(ZZ_PUSHBACK_2BIG);

            zzMarkedPos -= number;
        }

        /// <summary>
        /// Resumes scanning until the next regular expression is matched,
        /// the end of input is encountered or an I/O-Error occurs.
        /// </summary>
        /// <returns>the next token</returns>
        /// <exception cref="IOException">if any I/O-Error occurs</exception>
        public int GetNextToken()
        {
            int zzInput;
            int zzAction;

            // cached fields:
            int zzCurrentPosL;
            int zzMarkedPosL;
            int zzEndReadL = zzEndRead;
            char[] zzBufferL = zzBuffer;
            char[] zzCMapL = ZZ_CMAP;

            int[] zzTransL = ZZ_TRANS;
            int[] zzRowMapL = ZZ_ROWMAP;
            int[] zzAttrL = ZZ_ATTRIBUTE;

            while (true)
            {
                zzMarkedPosL = zzMarkedPos;

                yyChar += zzMarkedPosL - zzStartRead;

                zzAction = -1;

                zzCurrentPosL = zzCurrentPos = zzStartRead = zzMarkedPosL;

                zzState = ZZ_LEXSTATE[zzLexicalState];

                // set up zzAction for empty match case:
                int zzAttributes = zzAttrL[zzState];
                if ((zzAttributes & 1) == 1)
                {
                    zzAction = zzState;
                }



                while (true)
                {

                    if (zzCurrentPosL < zzEndReadL)
                        zzInput = zzBufferL[zzCurrentPosL++];
                    else if (zzAtEOF)
                    {
                        zzInput = YYEOF;
                        goto zzForActionBreak;
                    }
                    else
                    {
                        // store back cached positions
                        zzCurrentPos = zzCurrentPosL;
                        zzMarkedPos = zzMarkedPosL;
                        bool eof = ZzRefill();
                        // get translated positions and possibly new buffer
                        zzCurrentPosL = zzCurrentPos;
                        zzMarkedPosL = zzMarkedPos;
                        zzBufferL = zzBuffer;
                        zzEndReadL = zzEndRead;
                        if (eof)
                        {
                            zzInput = YYEOF;
                            goto zzForActionBreak;
                        }
                        else
                        {
                            zzInput = zzBufferL[zzCurrentPosL++];
                        }
                    }
                    int zzNext = zzTransL[zzRowMapL[zzState] + zzCMapL[zzInput]];
                    if (zzNext == -1) goto zzForActionBreak;
                    zzState = zzNext;

                    zzAttributes = zzAttrL[zzState];
                    if ((zzAttributes & 1) == 1)
                    {
                        zzAction = zzState;
                        zzMarkedPosL = zzCurrentPosL;
                        if ((zzAttributes & 8) == 8) goto zzForActionBreak;
                    }

                }
                zzForActionBreak:

                // store back cached position
                zzMarkedPos = zzMarkedPosL;

                switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction])
                {
                    case 1:
                        { /* Break so we don't hit fall-through warning: */
                            break; /* Not numeric, word, ideographic, hiragana, or SE Asian -- ignore it. */
                        }
                    case 9: break;
                    case 2:
                        {
                            return WORD_TYPE;
                        }
                    case 10: break;
                    case 3:
                        {
                            return NUMERIC_TYPE;
                        }
                    case 11: break;
                    case 4:
                        {
                            return KATAKANA_TYPE;
                        }
                    case 12: break;
                    case 5:
                        {
                            return SOUTH_EAST_ASIAN_TYPE;
                        }
                    case 13: break;
                    case 6:
                        {
                            return IDEOGRAPHIC_TYPE;
                        }
                    case 14: break;
                    case 7:
                        {
                            return HIRAGANA_TYPE;
                        }
                    case 15: break;
                    case 8:
                        {
                            return HANGUL_TYPE;
                        }
                    case 16: break;
                    default:
                        if (zzInput == YYEOF && zzStartRead == zzCurrentPos)
                        {
                            zzAtEOF = true;
                            {
                                return StandardTokenizerInterface.YYEOF;
                            }
                        }
                        else
                        {
                            ZzScanError(ZZ_NO_MATCH);
                        }
                        break;
                }
            }
        }
    }
}
