/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.adaptivestreaming;

import com.coremedia.iso.Hex;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.SoundMediaHeaderBox;
import com.coremedia.iso.boxes.VideoMediaHeaderBox;
import com.coremedia.iso.boxes.h264.AvcConfigurationBox;
import com.coremedia.iso.boxes.sampleentry.AudioSampleEntry;
import com.coremedia.iso.boxes.sampleentry.VisualSampleEntry;
import com.googlecode.mp4parser.Version;
import com.googlecode.mp4parser.authoring.Movie;
import com.googlecode.mp4parser.authoring.Track;
import com.googlecode.mp4parser.authoring.adaptivestreaming.AbstractManifestWriter;
import com.googlecode.mp4parser.authoring.adaptivestreaming.AudioQuality;
import com.googlecode.mp4parser.authoring.adaptivestreaming.VideoQuality;
import com.googlecode.mp4parser.authoring.builder.FragmentIntersectionFinder;
import com.googlecode.mp4parser.boxes.DTSSpecificBox;
import com.googlecode.mp4parser.boxes.EC3SpecificBox;
import com.googlecode.mp4parser.boxes.mp4.ESDescriptorBox;
import com.googlecode.mp4parser.boxes.mp4.objectdescriptors.AudioSpecificConfig;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlatManifestWriterImpl
extends AbstractManifestWriter {
    private static final Logger LOG = Logger.getLogger(FlatManifestWriterImpl.class.getName());

    protected FlatManifestWriterImpl(FragmentIntersectionFinder intersectionFinder) {
        super(intersectionFinder);
    }

    protected Document customizeManifest(Document manifest) {
        return manifest;
    }

    public String getManifest(Movie movie) throws IOException {
        DocumentBuilder documentBuilder;
        LinkedList<VideoQuality> videoQualities = new LinkedList<VideoQuality>();
        long videoTimescale = -1L;
        LinkedList<AudioQuality> audioQualities = new LinkedList<AudioQuality>();
        long audioTimescale = -1L;
        for (Track track : movie.getTracks()) {
            SampleDescriptionBox stsd;
            if (track.getMediaHeaderBox() instanceof VideoMediaHeaderBox) {
                this.videoFragmentsDurations = this.checkFragmentsAlign(this.videoFragmentsDurations, this.calculateFragmentDurations(track, movie));
                stsd = track.getSampleDescriptionBox();
                videoQualities.add(this.getVideoQuality(track, (VisualSampleEntry)stsd.getSampleEntry()));
                if (videoTimescale == -1L) {
                    videoTimescale = track.getTrackMetaData().getTimescale();
                } else assert (videoTimescale == track.getTrackMetaData().getTimescale());
            }
            if (!(track.getMediaHeaderBox() instanceof SoundMediaHeaderBox)) continue;
            this.audioFragmentsDurations = this.checkFragmentsAlign(this.audioFragmentsDurations, this.calculateFragmentDurations(track, movie));
            stsd = track.getSampleDescriptionBox();
            audioQualities.add(this.getAudioQuality(track, (AudioSampleEntry)stsd.getSampleEntry()));
            if (audioTimescale == -1L) {
                audioTimescale = track.getTrackMetaData().getTimescale();
                continue;
            }
            assert (audioTimescale == track.getTrackMetaData().getTimescale());
        }
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        Document document = documentBuilder.newDocument();
        Element smoothStreamingMedia = document.createElement("SmoothStreamingMedia");
        document.appendChild(smoothStreamingMedia);
        smoothStreamingMedia.setAttribute("MajorVersion", "2");
        smoothStreamingMedia.setAttribute("MinorVersion", "1");
        smoothStreamingMedia.setAttribute("Duration", "0");
        smoothStreamingMedia.appendChild(document.createComment(Version.VERSION));
        Element videoStreamIndex = document.createElement("StreamIndex");
        videoStreamIndex.setAttribute("Type", "video");
        videoStreamIndex.setAttribute("TimeScale", Long.toString(videoTimescale));
        videoStreamIndex.setAttribute("Chunks", Integer.toString(this.videoFragmentsDurations.length));
        videoStreamIndex.setAttribute("Url", "video/{bitrate}/{start time}");
        videoStreamIndex.setAttribute("QualityLevels", Integer.toString(videoQualities.size()));
        smoothStreamingMedia.appendChild(videoStreamIndex);
        int i = 0;
        while (i < videoQualities.size()) {
            VideoQuality vq = (VideoQuality)videoQualities.get(i);
            Element qualityLevel = document.createElement("QualityLevel");
            qualityLevel.setAttribute("Index", Integer.toString(i));
            qualityLevel.setAttribute("Bitrate", Long.toString(vq.bitrate));
            qualityLevel.setAttribute("FourCC", vq.fourCC);
            qualityLevel.setAttribute("MaxWidth", Long.toString(vq.width));
            qualityLevel.setAttribute("MaxHeight", Long.toString(vq.height));
            qualityLevel.setAttribute("CodecPrivateData", vq.codecPrivateData);
            qualityLevel.setAttribute("NALUnitLengthField", Integer.toString(vq.nalLength));
            videoStreamIndex.appendChild(qualityLevel);
            ++i;
        }
        i = 0;
        while (i < this.videoFragmentsDurations.length) {
            Element c = document.createElement("c");
            c.setAttribute("n", Integer.toString(i));
            c.setAttribute("d", Long.toString(this.videoFragmentsDurations[i]));
            videoStreamIndex.appendChild(c);
            ++i;
        }
        if (this.audioFragmentsDurations != null) {
            Element audioStreamIndex = document.createElement("StreamIndex");
            audioStreamIndex.setAttribute("Type", "audio");
            audioStreamIndex.setAttribute("TimeScale", Long.toString(audioTimescale));
            audioStreamIndex.setAttribute("Chunks", Integer.toString(this.audioFragmentsDurations.length));
            audioStreamIndex.setAttribute("Url", "audio/{bitrate}/{start time}");
            audioStreamIndex.setAttribute("QualityLevels", Integer.toString(audioQualities.size()));
            smoothStreamingMedia.appendChild(audioStreamIndex);
            int i2 = 0;
            while (i2 < audioQualities.size()) {
                AudioQuality aq = (AudioQuality)audioQualities.get(i2);
                Element qualityLevel = document.createElement("QualityLevel");
                qualityLevel.setAttribute("Index", Integer.toString(i2));
                qualityLevel.setAttribute("FourCC", aq.fourCC);
                qualityLevel.setAttribute("Bitrate", Long.toString(aq.bitrate));
                qualityLevel.setAttribute("AudioTag", Integer.toString(aq.audioTag));
                qualityLevel.setAttribute("SamplingRate", Long.toString(aq.samplingRate));
                qualityLevel.setAttribute("Channels", Integer.toString(aq.channels));
                qualityLevel.setAttribute("BitsPerSample", Integer.toString(aq.bitPerSample));
                qualityLevel.setAttribute("PacketSize", Integer.toString(aq.packetSize));
                qualityLevel.setAttribute("CodecPrivateData", aq.codecPrivateData);
                audioStreamIndex.appendChild(qualityLevel);
                ++i2;
            }
            i2 = 0;
            while (i2 < this.audioFragmentsDurations.length) {
                Element c = document.createElement("c");
                c.setAttribute("n", Integer.toString(i2));
                c.setAttribute("d", Long.toString(this.audioFragmentsDurations[i2]));
                audioStreamIndex.appendChild(c);
                ++i2;
            }
        }
        document.setXmlStandalone(true);
        DOMSource source = new DOMSource(this.customizeManifest(document));
        StringWriter stringWriter = new StringWriter();
        StreamResult result = new StreamResult(stringWriter);
        TransformerFactory factory = TransformerFactory.newInstance();
        try {
            Transformer transformer = factory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(source, result);
        }
        catch (TransformerConfigurationException e) {
            throw new IOException(e);
        }
        catch (TransformerException e) {
            throw new IOException(e);
        }
        return stringWriter.getBuffer().toString();
    }

    private AudioQuality getAudioQuality(Track track, AudioSampleEntry ase) {
        if (this.getFormat(ase).equals("mp4a")) {
            return this.getAacAudioQuality(track, ase);
        }
        if (this.getFormat(ase).equals("ec-3")) {
            return this.getEc3AudioQuality(track, ase);
        }
        if (this.getFormat(ase).startsWith("dts")) {
            return this.getDtsAudioQuality(track, ase);
        }
        throw new InternalError("I don't know what to do with audio of type " + this.getFormat(ase));
    }

    private AudioQuality getAacAudioQuality(Track track, AudioSampleEntry ase) {
        AudioQuality l = new AudioQuality();
        ESDescriptorBox esDescriptorBox = ase.getBoxes(ESDescriptorBox.class).get(0);
        AudioSpecificConfig audioSpecificConfig = esDescriptorBox.getEsDescriptor().getDecoderConfigDescriptor().getAudioSpecificInfo();
        l.fourCC = audioSpecificConfig.getSbrPresentFlag() == 1 ? "AACH" : (audioSpecificConfig.getPsPresentFlag() == 1 ? "AACP" : "AACL");
        l.bitrate = this.getBitrate(track);
        l.audioTag = 255;
        l.samplingRate = ase.getSampleRate();
        l.channels = ase.getChannelCount();
        l.bitPerSample = ase.getSampleSize();
        l.packetSize = 4;
        l.codecPrivateData = this.getAudioCodecPrivateData(audioSpecificConfig);
        return l;
    }

    private AudioQuality getEc3AudioQuality(Track track, AudioSampleEntry ase) {
        EC3SpecificBox ec3SpecificBox = ase.getBoxes(EC3SpecificBox.class).get(0);
        if (ec3SpecificBox == null) {
            throw new RuntimeException("EC-3 track misses EC3SpecificBox!");
        }
        int nfchans = 0;
        int lfechans = 0;
        byte dWChannelMaskFirstByte = 0;
        byte dWChannelMaskSecondByte = 0;
        for (EC3SpecificBox.Entry entry : ec3SpecificBox.getEntries()) {
            switch (entry.acmod) {
                case 0: {
                    nfchans = (short)(nfchans + 2);
                    throw new RuntimeException("Smooth Streaming doesn't support DDP 1+1 mode");
                }
                case 1: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 1);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0x20);
                    break;
                }
                case 2: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 2);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0xC0);
                    break;
                }
                case 3: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 3);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0xE0);
                    break;
                }
                case 4: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 3);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0xC0);
                    dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | 0x80);
                    break;
                }
                case 5: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 4);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0xE0);
                    dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | 0x80);
                    break;
                }
                case 6: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 4);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0xCC);
                    break;
                }
                case 7: {
                    DependentSubstreamMask dependentSubstreamMask;
                    nfchans = (short)(nfchans + 5);
                    if (entry.num_dep_sub > 0) {
                        dependentSubstreamMask = new DependentSubstreamMask(dWChannelMaskFirstByte, dWChannelMaskSecondByte, entry).process();
                        dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | dependentSubstreamMask.getdWChannelMaskFirstByte());
                        dWChannelMaskSecondByte = (byte)(dWChannelMaskSecondByte | dependentSubstreamMask.getdWChannelMaskSecondByte());
                        break;
                    }
                    dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0xEC);
                }
            }
            if (entry.lfeon != 1) continue;
            lfechans = (short)(lfechans + 1);
            dWChannelMaskFirstByte = (byte)(dWChannelMaskFirstByte | 0x10);
        }
        ByteBuffer waveformatex = ByteBuffer.allocate(22);
        byte[] byArray = new byte[2];
        byArray[1] = 6;
        waveformatex.put(byArray);
        waveformatex.put(dWChannelMaskFirstByte);
        waveformatex.put(dWChannelMaskSecondByte);
        waveformatex.put(new byte[2]);
        waveformatex.put(new byte[]{-81, -121, -5, -89, 2, 45, -5, 66, -92, -44, 5, -51, -109, -124, 59, -35});
        ByteBuffer dec3Content = ByteBuffer.allocate((int)ec3SpecificBox.getContentSize());
        ec3SpecificBox.getContent(dec3Content);
        AudioQuality l = new AudioQuality();
        l.fourCC = "EC-3";
        l.bitrate = this.getBitrate(track);
        l.audioTag = 65534;
        l.samplingRate = ase.getSampleRate();
        l.channels = nfchans + lfechans;
        l.bitPerSample = 16;
        l.packetSize = (int)track.getSamples().get(0).getSize();
        l.codecPrivateData = String.valueOf(Hex.encodeHex(waveformatex.array())) + Hex.encodeHex(dec3Content.array());
        return l;
    }

    private AudioQuality getDtsAudioQuality(Track track, AudioSampleEntry ase) {
        DTSSpecificBox dtsSpecificBox = ase.getBoxes(DTSSpecificBox.class).get(0);
        if (dtsSpecificBox == null) {
            throw new RuntimeException("DTS track misses DTSSpecificBox!");
        }
        ByteBuffer waveformatex = ByteBuffer.allocate(22);
        int frameDuration = dtsSpecificBox.getFrameDuration();
        int samplesPerBlock = 0;
        switch (frameDuration) {
            case 0: {
                samplesPerBlock = 512;
                break;
            }
            case 1: {
                samplesPerBlock = 1024;
                break;
            }
            case 2: {
                samplesPerBlock = 2048;
                break;
            }
            case 3: {
                samplesPerBlock = 4096;
            }
        }
        waveformatex.put((byte)(samplesPerBlock & 0xFF));
        waveformatex.put((byte)(samplesPerBlock >>> 8));
        int dwChannelMask = this.getNumChannelsAndMask(dtsSpecificBox)[1];
        waveformatex.put((byte)(dwChannelMask & 0xFF));
        waveformatex.put((byte)(dwChannelMask >>> 8));
        waveformatex.put((byte)(dwChannelMask >>> 16));
        waveformatex.put((byte)(dwChannelMask >>> 24));
        waveformatex.put(new byte[]{-82, -28, -65, 94, 97, 94, 65, -121, -110, -4, -92, -127, 38, -103, 2, 17});
        ByteBuffer dtsCodecPrivateData = ByteBuffer.allocate(8);
        dtsCodecPrivateData.put((byte)dtsSpecificBox.getStreamConstruction());
        int channelLayout = dtsSpecificBox.getChannelLayout();
        dtsCodecPrivateData.put((byte)(channelLayout & 0xFF));
        dtsCodecPrivateData.put((byte)(channelLayout >>> 8));
        dtsCodecPrivateData.put((byte)(channelLayout >>> 16));
        dtsCodecPrivateData.put((byte)(channelLayout >>> 24));
        byte dtsFlags = (byte)(dtsSpecificBox.getMultiAssetFlag() << 1);
        dtsFlags = (byte)(dtsFlags | dtsSpecificBox.getLBRDurationMod());
        dtsCodecPrivateData.put(dtsFlags);
        dtsCodecPrivateData.put(new byte[2]);
        AudioQuality l = new AudioQuality();
        l.fourCC = this.getFormat(ase);
        l.bitrate = dtsSpecificBox.getAvgBitRate();
        l.audioTag = 65534;
        l.samplingRate = dtsSpecificBox.getDTSSamplingFrequency();
        l.channels = this.getNumChannelsAndMask(dtsSpecificBox)[0];
        l.bitPerSample = 16;
        l.packetSize = (int)track.getSamples().get(0).getSize();
        l.codecPrivateData = String.valueOf(Hex.encodeHex(waveformatex.array())) + Hex.encodeHex(dtsCodecPrivateData.array());
        return l;
    }

    private int[] getNumChannelsAndMask(DTSSpecificBox dtsSpecificBox) {
        int channelLayout = dtsSpecificBox.getChannelLayout();
        int numChannels = 0;
        int dwChannelMask = 0;
        if ((channelLayout & 1) == 1) {
            ++numChannels;
            dwChannelMask |= 4;
        }
        if ((channelLayout & 2) == 2) {
            numChannels += 2;
            dwChannelMask |= 1;
            dwChannelMask |= 2;
        }
        if ((channelLayout & 4) == 4) {
            numChannels += 2;
            dwChannelMask |= 0x10;
            dwChannelMask |= 0x20;
        }
        if ((channelLayout & 8) == 8) {
            ++numChannels;
            dwChannelMask |= 8;
        }
        if ((channelLayout & 0x10) == 16) {
            ++numChannels;
            dwChannelMask |= 0x100;
        }
        if ((channelLayout & 0x20) == 32) {
            numChannels += 2;
            dwChannelMask |= 0x1000;
            dwChannelMask |= 0x4000;
        }
        if ((channelLayout & 0x40) == 64) {
            numChannels += 2;
            dwChannelMask |= 0x10;
            dwChannelMask |= 0x20;
        }
        if ((channelLayout & 0x80) == 128) {
            ++numChannels;
            dwChannelMask |= 0x2000;
        }
        if ((channelLayout & 0x100) == 256) {
            ++numChannels;
            dwChannelMask |= 0x800;
        }
        if ((channelLayout & 0x200) == 512) {
            numChannels += 2;
            dwChannelMask |= 0x40;
            dwChannelMask |= 0x80;
        }
        if ((channelLayout & 0x400) == 1024) {
            numChannels += 2;
            dwChannelMask |= 0x200;
            dwChannelMask |= 0x400;
        }
        if ((channelLayout & 0x800) == 2048) {
            numChannels += 2;
            dwChannelMask |= 0x10;
            dwChannelMask |= 0x20;
        }
        if ((channelLayout & 0x1000) == 4096) {
            ++numChannels;
            dwChannelMask |= 8;
        }
        if ((channelLayout & 0x2000) == 8192) {
            numChannels += 2;
            dwChannelMask |= 0x10;
            dwChannelMask |= 0x20;
        }
        if ((channelLayout & 0x4000) == 16384) {
            ++numChannels;
            dwChannelMask |= 0x10000;
        }
        if ((channelLayout & 0x8000) == 32768) {
            numChannels += 2;
            dwChannelMask |= 0x8000;
            dwChannelMask |= 0x20000;
        }
        if ((channelLayout & 0x10000) == 65536) {
            ++numChannels;
        }
        if ((channelLayout & 0x20000) == 131072) {
            numChannels += 2;
        }
        return new int[]{numChannels, dwChannelMask};
    }

    private String getAudioCodecPrivateData(AudioSpecificConfig audioSpecificConfig) {
        byte[] configByteArray = audioSpecificConfig.getConfigBytes();
        return Hex.encodeHex(configByteArray);
    }

    private VideoQuality getVideoQuality(Track track, VisualSampleEntry vse) {
        if (!"avc1".equals(this.getFormat(vse))) {
            throw new InternalError("I don't know how to handle video of type " + this.getFormat(vse));
        }
        AvcConfigurationBox avcConfigurationBox = vse.getBoxes(AvcConfigurationBox.class).get(0);
        VideoQuality l = new VideoQuality();
        l.bitrate = this.getBitrate(track);
        l.codecPrivateData = Hex.encodeHex(this.getAvcCodecPrivateData(avcConfigurationBox));
        l.fourCC = "AVC1";
        l.width = vse.getWidth();
        l.height = vse.getHeight();
        l.nalLength = avcConfigurationBox.getLengthSizeMinusOne() + 1;
        return l;
    }

    private byte[] getAvcCodecPrivateData(AvcConfigurationBox avcConfigurationBox) {
        List<byte[]> sps = avcConfigurationBox.getSequenceParameterSets();
        List<byte[]> pps = avcConfigurationBox.getPictureParameterSets();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            byte[] byArray = new byte[4];
            byArray[3] = 1;
            baos.write(byArray);
            for (byte[] sp : sps) {
                baos.write(sp);
            }
            byte[] byArray2 = new byte[4];
            byArray2[3] = 1;
            baos.write(byArray2);
            for (byte[] pp : pps) {
                baos.write(pp);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException("ByteArrayOutputStream do not throw IOException ?!?!?");
        }
        return baos.toByteArray();
    }

    private class DependentSubstreamMask {
        private byte dWChannelMaskFirstByte;
        private byte dWChannelMaskSecondByte;
        private EC3SpecificBox.Entry entry;

        public DependentSubstreamMask(byte dWChannelMaskFirstByte, byte dWChannelMaskSecondByte, EC3SpecificBox.Entry entry) {
            this.dWChannelMaskFirstByte = dWChannelMaskFirstByte;
            this.dWChannelMaskSecondByte = dWChannelMaskSecondByte;
            this.entry = entry;
        }

        public byte getdWChannelMaskFirstByte() {
            return this.dWChannelMaskFirstByte;
        }

        public byte getdWChannelMaskSecondByte() {
            return this.dWChannelMaskSecondByte;
        }

        public DependentSubstreamMask process() {
            switch (this.entry.chan_loc) {
                case 0: {
                    this.dWChannelMaskFirstByte = (byte)(this.dWChannelMaskFirstByte | 3);
                    break;
                }
                case 1: {
                    this.dWChannelMaskFirstByte = (byte)(this.dWChannelMaskFirstByte | 0xC);
                    break;
                }
                case 2: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 0x80);
                    break;
                }
                case 3: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 8);
                    break;
                }
                case 6: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 5);
                    break;
                }
                case 7: {
                    this.dWChannelMaskSecondByte = (byte)(this.dWChannelMaskSecondByte | 2);
                }
            }
            return this;
        }
    }
}

