/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.apache.manifoldcf.agents.interfaces.ServiceInterruption;
import org.apache.manifoldcf.core.connector.BaseConnector;
import org.apache.manifoldcf.core.interfaces.Configuration;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.Specification;
import org.apache.manifoldcf.core.interfaces.VersionContext;
import org.apache.manifoldcf.crawler.interfaces.DocumentSpecification;
import org.apache.manifoldcf.crawler.interfaces.DocumentVersions;
import org.apache.manifoldcf.crawler.interfaces.IDocumentIdentifierStream;
import org.apache.manifoldcf.crawler.interfaces.IExistingVersions;
import org.apache.manifoldcf.crawler.interfaces.IProcessActivity;
import org.apache.manifoldcf.crawler.interfaces.IRepositoryConnector;
import org.apache.manifoldcf.crawler.interfaces.ISeedingActivity;
import org.apache.manifoldcf.crawler.interfaces.IVersionActivity;

public abstract class BaseRepositoryConnector
extends BaseConnector
implements IRepositoryConnector {
    public static final String _rcsid = "@(#)$Id: BaseRepositoryConnector.java 996524 2010-09-13 13:38:01Z kwright $";

    @Override
    public int getConnectorModel() {
        return 0;
    }

    @Override
    public String[] getActivitiesList() {
        return new String[0];
    }

    @Override
    public String[] getRelationshipTypes() {
        return new String[0];
    }

    @Override
    public String[] getBinNames(String documentIdentifier) {
        return new String[]{""};
    }

    @Override
    public boolean requestInfo(Configuration output, String command) throws ManifoldCFException {
        return false;
    }

    @Override
    public String addSeedDocuments(ISeedingActivity activities, Specification spec, String lastSeedVersion, long seedTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        long startTime = lastSeedVersion == null ? 0L : new Long(lastSeedVersion);
        this.addSeedDocuments(activities, spec, startTime, seedTime, jobMode);
        return new Long(seedTime).toString();
    }

    public void addSeedDocuments(ISeedingActivity activities, Specification spec, long startTime, long endTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.addSeedDocuments(activities, (DocumentSpecification)spec, startTime, endTime, jobMode);
    }

    public void addSeedDocuments(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.addSeedDocuments(activities, spec, startTime, endTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSeedDocuments(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        String id;
        IDocumentIdentifierStream ids = this.getDocumentIdentifiers(activities, spec, startTime, endTime);
        if (ids != null) {
            try {
                while ((id = ids.getNextIdentifier()) != null) {
                    activities.addSeedDocument(id);
                }
            }
            finally {
                ids.close();
            }
        }
        if ((ids = this.getRemainingDocumentIdentifiers(activities, spec, startTime, endTime)) != null) {
            try {
                while ((id = ids.getNextIdentifier()) != null) {
                    activities.addUnqueuedSeedDocument(id);
                }
            }
            finally {
                ids.close();
            }
        }
    }

    public IDocumentIdentifierStream getDocumentIdentifiers(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        return this.getDocumentIdentifiers(spec, startTime, endTime);
    }

    public IDocumentIdentifierStream getDocumentIdentifiers(DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        return null;
    }

    public IDocumentIdentifierStream getRemainingDocumentIdentifiers(ISeedingActivity activities, DocumentSpecification spec, long startTime, long endTime) throws ManifoldCFException, ServiceInterruption {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processDocuments(String[] documentIdentifiers, IExistingVersions statuses, Specification spec, IProcessActivity activities, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String[] oldVersions = new String[documentIdentifiers.length];
        for (int i = 0; i < oldVersions.length; ++i) {
            oldVersions[i] = statuses.getIndexedVersionString(documentIdentifiers[i]);
        }
        DocumentVersions dv = new DocumentVersions();
        this.getDocumentVersions(dv, documentIdentifiers, oldVersions, activities, spec, jobMode, usesDefaultAuthority);
        try {
            HashSet<String> fetchDocuments = new HashSet<String>();
            HashSet<String> scanDocuments = new HashSet<String>();
            for (int i = 0; i < documentIdentifiers.length; ++i) {
                String documentIdentifier = documentIdentifiers[i];
                VersionContext vc = dv.getDocumentVersion(documentIdentifier);
                if (vc != null) {
                    if (dv.isAlwaysRefetch(documentIdentifier) || activities.checkDocumentNeedsReindexing(documentIdentifier, vc.getVersionString())) {
                        fetchDocuments.add(documentIdentifier);
                    }
                    scanDocuments.add(documentIdentifier);
                    continue;
                }
                activities.deleteDocument(documentIdentifier);
            }
            String[] processIDs = new String[scanDocuments.size()];
            boolean[] scanOnly = new boolean[scanDocuments.size()];
            int index = 0;
            for (int i = 0; i < documentIdentifiers.length; ++i) {
                String documentIdentifier = documentIdentifiers[i];
                if (!scanDocuments.contains(documentIdentifier)) continue;
                processIDs[index] = documentIdentifier;
                scanOnly[index] = !fetchDocuments.contains(documentIdentifier);
                ++index;
            }
            this.processDocuments(processIDs, dv, activities, scanOnly, jobMode);
        }
        finally {
            this.releaseDocumentVersions(documentIdentifiers, dv);
        }
    }

    public void getDocumentVersions(DocumentVersions documentVersions, String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, Specification spec, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        String[] rval = this.getDocumentVersions(documentIdentifiers, oldVersions, activities, spec, jobMode, usesDefaultAuthority);
        for (int i = 0; i < rval.length; ++i) {
            if (rval[i] == null) continue;
            documentVersions.setDocumentVersion(documentIdentifiers[i], new VersionContext(rval[i], this.params, spec));
            if (rval[i].length() != 0) continue;
            documentVersions.alwaysRefetch(documentIdentifiers[i]);
        }
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, Specification spec, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        return this.getDocumentVersions(documentIdentifiers, oldVersions, activities, (DocumentSpecification)spec, jobMode, usesDefaultAuthority);
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, DocumentSpecification spec, int jobMode, boolean usesDefaultAuthority) throws ManifoldCFException, ServiceInterruption {
        return this.getDocumentVersions(documentIdentifiers, oldVersions, activities, spec, jobMode);
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, DocumentSpecification spec, int jobMode) throws ManifoldCFException, ServiceInterruption {
        return this.getDocumentVersions(documentIdentifiers, oldVersions, activities, spec);
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, String[] oldVersions, IVersionActivity activities, DocumentSpecification spec) throws ManifoldCFException, ServiceInterruption {
        return this.getDocumentVersions(documentIdentifiers, activities, spec);
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, IVersionActivity activities, DocumentSpecification spec) throws ManifoldCFException, ServiceInterruption {
        return this.getDocumentVersions(documentIdentifiers, spec);
    }

    public String[] getDocumentVersions(String[] documentIdentifiers, DocumentSpecification spec) throws ManifoldCFException, ServiceInterruption {
        String[] rval = new String[documentIdentifiers.length];
        int i = 0;
        while (i < rval.length) {
            rval[i++] = "";
        }
        return rval;
    }

    public void releaseDocumentVersions(String[] documentIdentifiers, DocumentVersions versions) throws ManifoldCFException {
        String[] versionStrings = new String[documentIdentifiers.length];
        for (int i = 0; i < versionStrings.length; ++i) {
            VersionContext vc = versions.getDocumentVersion(documentIdentifiers[i]);
            boolean alwaysFetch = versions.isAlwaysRefetch(documentIdentifiers[i]);
            versionStrings[i] = alwaysFetch ? "" : (vc == null ? null : vc.getVersionString());
        }
        this.releaseDocumentVersions(documentIdentifiers, versionStrings);
    }

    public void releaseDocumentVersions(String[] documentIdentifiers, String[] versions) throws ManifoldCFException {
    }

    @Override
    public int getMaxDocumentRequest() {
        return 1;
    }

    public void processDocuments(String[] documentIdentifiers, DocumentVersions versions, IProcessActivity activities, boolean[] scanOnly, int jobMode) throws ManifoldCFException, ServiceInterruption {
        Specification spec = null;
        String[] versionStrings = new String[documentIdentifiers.length];
        for (int i = 0; i < versionStrings.length; ++i) {
            boolean alwaysFetch;
            VersionContext vc = versions.getDocumentVersion(documentIdentifiers[i]);
            if (vc != null) {
                spec = vc.getSpecification();
            }
            versionStrings[i] = (alwaysFetch = versions.isAlwaysRefetch(documentIdentifiers[i])) ? "" : (vc == null ? null : vc.getVersionString());
        }
        if (spec != null) {
            this.processDocuments(documentIdentifiers, versionStrings, activities, spec, scanOnly, jobMode);
        }
    }

    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, Specification spec, boolean[] scanOnly, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.processDocuments(documentIdentifiers, versions, activities, (DocumentSpecification)spec, scanOnly, jobMode);
    }

    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, DocumentSpecification spec, boolean[] scanOnly, int jobMode) throws ManifoldCFException, ServiceInterruption {
        this.processDocuments(documentIdentifiers, versions, activities, spec, scanOnly);
    }

    public void processDocuments(String[] documentIdentifiers, String[] versions, IProcessActivity activities, DocumentSpecification spec, boolean[] scanOnly) throws ManifoldCFException, ServiceInterruption {
    }

    @Override
    public String getFormCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "checkSpecification";
    }

    @Override
    public String getFormPresaveCheckJavascriptMethodName(int connectionSequenceNumber) {
        return "checkSpecificationForSave";
    }

    @Override
    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, List<String> tabsArray) throws ManifoldCFException, IOException {
        this.outputSpecificationHeader(out, locale, (DocumentSpecification)ds, tabsArray);
    }

    public void outputSpecificationHeader(IHTTPOutput out, Locale locale, DocumentSpecification ds, List<String> tabsArray) throws ManifoldCFException, IOException {
        this.outputSpecificationHeader(out, ds, tabsArray);
    }

    public void outputSpecificationHeader(IHTTPOutput out, DocumentSpecification ds, List<String> tabsArray) throws ManifoldCFException, IOException {
        ArrayList<Object> localTabsArray = new ArrayList<Object>();
        this.outputSpecificationHeader(out, ds, localTabsArray);
        for (Object o : localTabsArray) {
            tabsArray.add((String)o);
        }
    }

    public void outputSpecificationHeader(IHTTPOutput out, DocumentSpecification ds, ArrayList<Object> tabsArray) throws ManifoldCFException, IOException {
    }

    @Override
    public void outputSpecificationBody(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber, int actualSequenceNumber, String tabName) throws ManifoldCFException, IOException {
        this.outputSpecificationBody(out, locale, (DocumentSpecification)ds, tabName);
    }

    public void outputSpecificationBody(IHTTPOutput out, Locale locale, DocumentSpecification ds, String tabName) throws ManifoldCFException, IOException {
        this.outputSpecificationBody(out, ds, tabName);
    }

    public void outputSpecificationBody(IHTTPOutput out, DocumentSpecification ds, String tabName) throws ManifoldCFException, IOException {
    }

    @Override
    public String processSpecificationPost(IPostParameters variableContext, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException {
        return this.processSpecificationPost(variableContext, locale, (DocumentSpecification)ds);
    }

    public String processSpecificationPost(IPostParameters variableContext, Locale locale, DocumentSpecification ds) throws ManifoldCFException {
        return this.processSpecificationPost(variableContext, ds);
    }

    public String processSpecificationPost(IPostParameters variableContext, DocumentSpecification ds) throws ManifoldCFException {
        return null;
    }

    @Override
    public void viewSpecification(IHTTPOutput out, Locale locale, Specification ds, int connectionSequenceNumber) throws ManifoldCFException, IOException {
        this.viewSpecification(out, locale, (DocumentSpecification)ds);
    }

    public void viewSpecification(IHTTPOutput out, Locale locale, DocumentSpecification ds) throws ManifoldCFException, IOException {
        this.viewSpecification(out, ds);
    }

    public void viewSpecification(IHTTPOutput out, DocumentSpecification ds) throws ManifoldCFException, IOException {
    }
}

