/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.crawler.connectors.webcrawler;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.crawler.connectors.webcrawler.AuthenticationCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.LoginParameters;
import org.apache.manifoldcf.crawler.connectors.webcrawler.PageCredentials;
import org.apache.manifoldcf.crawler.connectors.webcrawler.SequenceCredentials;
import org.apache.manifoldcf.crawler.system.ManifoldCF;

public class CredentialsDescription {
    public static final String _rcsid = "@(#)$Id: CredentialsDescription.java 988245 2010-08-23 18:39:35Z kwright $";
    protected HashMap patternHash = new HashMap();

    public CredentialsDescription(ConfigParams configData) throws ManifoldCFException {
        int i = 0;
        while (i < configData.getChildCount()) {
            ConfigNode node;
            if (!(node = configData.getChild(i++)).getType().equals("accesscredential")) continue;
            String urlDescription = node.getAttributeValue("urlregexp");
            try {
                Pattern p;
                try {
                    p = Pattern.compile(urlDescription, 64);
                }
                catch (PatternSyntaxException e) {
                    throw new ManifoldCFException("Access credential regular expression '" + urlDescription + "' is illegal: " + e.getMessage(), (Throwable)e);
                }
                CredentialsItem ti = new CredentialsItem(p);
                String type = node.getAttributeValue("type");
                String userName = node.getAttributeValue("username");
                String password = node.getAttributeValue("password");
                if (password != null) {
                    password = ManifoldCF.deobfuscate((String)password);
                }
                if (type.equals("basic")) {
                    ti.setCredential(new BasicCredential(userName, password));
                } else if (type.equals("ntlm")) {
                    String domain = node.getAttributeValue("domain");
                    ti.setCredential(new NTLMCredential(domain, userName, password));
                } else if (type.equals("session")) {
                    SessionCredential sc = new SessionCredential(urlDescription);
                    int j = 0;
                    while (j < node.getChildCount()) {
                        Pattern matchPattern;
                        Pattern authPattern;
                        ConfigNode child;
                        if (!(child = node.getChild(j++)).getType().equals("authpage")) continue;
                        String authPageRegexp = child.getAttributeValue("urlregexp");
                        String pageType = child.getAttributeValue("type");
                        String matchRegexp = child.getAttributeValue("match");
                        String overrideTargetURL = child.getAttributeValue("overridetargeturl");
                        if (overrideTargetURL != null && overrideTargetURL.length() == 0) {
                            overrideTargetURL = null;
                        }
                        try {
                            authPattern = Pattern.compile(authPageRegexp, 64);
                        }
                        catch (PatternSyntaxException e) {
                            throw new ManifoldCFException("Authentication page regular expression '" + authPageRegexp + "' is illegal: " + e.getMessage(), (Throwable)e);
                        }
                        try {
                            matchPattern = Pattern.compile(matchRegexp, 64);
                        }
                        catch (PatternSyntaxException e) {
                            throw new ManifoldCFException("Match regular expression '" + matchRegexp + "' is illegal: " + e.getMessage(), (Throwable)e);
                        }
                        if (pageType.equals("form")) {
                            sc.addAuthPage(authPageRegexp, authPattern, overrideTargetURL, null, null, matchRegexp, matchPattern, null, null, null, null);
                        } else if (pageType.equals("link")) {
                            sc.addAuthPage(authPageRegexp, authPattern, overrideTargetURL, matchRegexp, matchPattern, null, null, null, null, null, null);
                        } else if (pageType.equals("redirection")) {
                            sc.addAuthPage(authPageRegexp, authPattern, overrideTargetURL, null, null, null, null, matchRegexp, matchPattern, null, null);
                        } else if (pageType.equals("content")) {
                            sc.addAuthPage(authPageRegexp, authPattern, overrideTargetURL, null, null, null, null, null, null, matchRegexp, matchPattern);
                        } else {
                            throw new ManifoldCFException("Invalid page type: " + pageType);
                        }
                        int k = 0;
                        while (k < child.getChildCount()) {
                            Pattern paramNamePattern;
                            ConfigNode paramNode;
                            if (!(paramNode = child.getChild(k++)).getType().equals("authparameter")) continue;
                            String paramName = paramNode.getAttributeValue("name");
                            try {
                                paramNamePattern = Pattern.compile(paramName, 64);
                            }
                            catch (PatternSyntaxException e) {
                                throw new ManifoldCFException("Parameter name regular expression '" + paramName + "' is illegal: " + e.getMessage(), (Throwable)e);
                            }
                            String passwordValue = paramNode.getAttributeValue("password");
                            String paramValue = paramNode.getAttributeValue("value");
                            if (passwordValue != null) {
                                paramValue = ManifoldCF.deobfuscate((String)passwordValue);
                            }
                            sc.addPageParameter(authPageRegexp, paramName, paramNamePattern, paramValue);
                        }
                    }
                    ti.setCredential(sc);
                } else {
                    throw new ManifoldCFException("Illegal credential type: " + type);
                }
                this.patternHash.put(urlDescription, ti);
            }
            catch (PatternSyntaxException e) {
                throw new ManifoldCFException("Bad pattern syntax in '" + urlDescription + "'", (Throwable)e);
            }
        }
    }

    public PageCredentials getPageCredential(String url) {
        PageCredentials c = null;
        for (String urlDescription : this.patternHash.keySet()) {
            Matcher m;
            CredentialsItem ti = (CredentialsItem)this.patternHash.get(urlDescription);
            Pattern p = ti.getPattern();
            AuthenticationCredentials ac = ti.getCredential();
            if (!(ac instanceof PageCredentials) || !(m = p.matcher(url)).find()) continue;
            if (c != null) {
                return null;
            }
            c = (PageCredentials)ac;
        }
        return c;
    }

    public SequenceCredentials getSequenceCredential(String url) {
        SequenceCredentials c = null;
        for (String urlDescription : this.patternHash.keySet()) {
            Matcher m;
            CredentialsItem ti = (CredentialsItem)this.patternHash.get(urlDescription);
            Pattern p = ti.getPattern();
            AuthenticationCredentials ac = ti.getCredential();
            if (!(ac instanceof SequenceCredentials) || !(m = p.matcher(url)).find()) continue;
            if (c != null) {
                return null;
            }
            c = (SequenceCredentials)ac;
        }
        return c;
    }

    protected static class NTLMCredential
    implements PageCredentials {
        protected String domain;
        protected String userName;
        protected String password;

        public NTLMCredential(String domain, String userName, String password) {
            this.domain = domain;
            this.userName = userName;
            this.password = password;
        }

        @Override
        public Credentials makeCredentialsObject(String targetHostName) throws ManifoldCFException {
            return new NTCredentials(this.userName, this.password, targetHostName, this.domain);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof NTLMCredential)) {
                return false;
            }
            NTLMCredential b = (NTLMCredential)o;
            return b.userName.equals(this.userName) && b.password.equals(this.password) && b.domain.equals(this.domain);
        }

        @Override
        public int hashCode() {
            return this.userName.hashCode() + this.password.hashCode() + this.domain.hashCode();
        }
    }

    protected static class BasicCredential
    implements PageCredentials {
        protected String userName;
        protected String password;
        protected UsernamePasswordCredentials credentialsObject;

        public BasicCredential(String userName, String password) {
            this.userName = userName;
            this.password = password;
            this.credentialsObject = new UsernamePasswordCredentials(userName, password);
        }

        @Override
        public Credentials makeCredentialsObject(String targetHostName) throws ManifoldCFException {
            return this.credentialsObject;
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof BasicCredential)) {
                return false;
            }
            BasicCredential b = (BasicCredential)o;
            return b.userName.equals(this.userName) && b.password.equals(this.password);
        }

        @Override
        public int hashCode() {
            return this.userName.hashCode() + this.password.hashCode();
        }
    }

    protected static class SessionCredential
    implements SequenceCredentials {
        protected String sequenceKey;
        protected Map sessionPages = new HashMap();

        public SessionCredential(String sequenceKey) {
            this.sequenceKey = sequenceKey;
        }

        public void addAuthPage(String urlregexp, Pattern urlPattern, String overrideTargetURL, String preferredLinkRegexp, Pattern preferredLinkPattern, String formNameRegexp, Pattern formNamePattern, String preferredRedirectionRegexp, Pattern preferredRedirectionPattern, String contentRegexp, Pattern contentPattern) throws ManifoldCFException {
            this.sessionPages.put(urlregexp, new SessionCredentialItem(urlregexp, urlPattern, overrideTargetURL, preferredLinkRegexp, preferredLinkPattern, formNameRegexp, formNamePattern, preferredRedirectionRegexp, preferredRedirectionPattern, contentRegexp, contentPattern));
        }

        public void addPageParameter(String urlregexp, String paramNameRegexp, Pattern paramNamePattern, String paramValue) {
            SessionCredentialItem sci = (SessionCredentialItem)this.sessionPages.get(urlregexp);
            sci.addParameter(paramNameRegexp, paramNamePattern, paramValue);
        }

        @Override
        public String getSequenceKey() {
            return this.sequenceKey;
        }

        @Override
        public Iterator findLoginParameters(String documentIdentifier) throws ManifoldCFException {
            return new LoginParameterIterator(this.sessionPages, documentIdentifier);
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof SessionCredential)) {
                return false;
            }
            SessionCredential b = (SessionCredential)o;
            if (b.sessionPages.size() != this.sessionPages.size()) {
                return false;
            }
            for (String key : this.sessionPages.keySet()) {
                SessionCredentialItem sci = (SessionCredentialItem)this.sessionPages.get(key);
                SessionCredentialItem bsci = (SessionCredentialItem)b.sessionPages.get(key);
                if (bsci == null) {
                    return false;
                }
                if (sci.equals(bsci)) continue;
                return false;
            }
            return true;
        }

        @Override
        public int hashCode() {
            int rval = 0;
            for (String key : this.sessionPages.keySet()) {
                SessionCredentialItem sci = (SessionCredentialItem)this.sessionPages.get(key);
                rval += sci.hashCode();
            }
            return rval;
        }
    }

    protected static class LoginParameterIterator
    implements Iterator {
        protected Map sessionPages;
        protected Iterator sessionPageIterator;
        protected String documentIdentifier;
        protected LoginParameters currentOne = null;

        public LoginParameterIterator(Map sessionPages, String documentIdentifier) {
            this.sessionPages = sessionPages;
            this.documentIdentifier = documentIdentifier;
            this.sessionPageIterator = sessionPages.keySet().iterator();
        }

        protected void findNextOne() {
            if (this.currentOne != null) {
                return;
            }
            while (this.sessionPageIterator.hasNext()) {
                String key = (String)this.sessionPageIterator.next();
                SessionCredentialItem sci = (SessionCredentialItem)this.sessionPages.get(key);
                Matcher m = sci.getPattern().matcher(this.documentIdentifier);
                if (!m.find()) continue;
                this.currentOne = sci;
                return;
            }
        }

        @Override
        public boolean hasNext() {
            this.findNextOne();
            return this.currentOne != null;
        }

        public Object next() {
            this.findNextOne();
            LoginParameters rval = this.currentOne;
            this.currentOne = null;
            return rval;
        }

        @Override
        public void remove() {
            throw new Error("Unimplemented function");
        }
    }

    protected static class SessionCredentialItem
    implements LoginParameters {
        protected final String regexp;
        protected final Pattern pattern;
        protected final String overrideTargetURL;
        protected final String preferredRedirectionRegexp;
        protected final Pattern preferredRedirectionPattern;
        protected final String preferredLinkRegexp;
        protected final Pattern preferredLinkPattern;
        protected final String formNameRegexp;
        protected final Pattern formNamePattern;
        protected final String contentRegexp;
        protected final Pattern contentPattern;
        protected final List parameters = new ArrayList();

        public SessionCredentialItem(String regexp, Pattern p, String overrideTargetURL, String preferredLinkRegexp, Pattern preferredLinkPattern, String formNameRegexp, Pattern formNamePattern, String preferredRedirectionRegexp, Pattern preferredRedirectionPattern, String contentRegexp, Pattern contentPattern) {
            this.regexp = regexp;
            this.pattern = p;
            this.overrideTargetURL = overrideTargetURL;
            this.preferredLinkRegexp = preferredLinkRegexp;
            this.preferredLinkPattern = preferredLinkPattern;
            this.formNameRegexp = formNameRegexp;
            this.formNamePattern = formNamePattern;
            this.preferredRedirectionRegexp = preferredRedirectionRegexp;
            this.preferredRedirectionPattern = preferredRedirectionPattern;
            this.contentRegexp = contentRegexp;
            this.contentPattern = contentPattern;
        }

        public void addParameter(String nameRegexp, Pattern namePattern, String value) {
            this.parameters.add(new SessionCredentialParameter(nameRegexp, namePattern, value));
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        @Override
        public String getOverrideTargetURL() {
            return this.overrideTargetURL;
        }

        @Override
        public Pattern getPreferredRedirectionPattern() {
            return this.preferredRedirectionPattern;
        }

        @Override
        public Pattern getPreferredLinkPattern() {
            return this.preferredLinkPattern;
        }

        @Override
        public Pattern getFormNamePattern() {
            return this.formNamePattern;
        }

        @Override
        public Pattern getContentPattern() {
            return this.contentPattern;
        }

        @Override
        public Pattern getParameterNamePattern(int index) {
            return this.getParameter(index).getNamePattern();
        }

        @Override
        public String getParameterValue(int index) {
            return this.getParameter(index).getValue();
        }

        @Override
        public int getParameterCount() {
            return this.parameters.size();
        }

        public SessionCredentialParameter getParameter(int index) {
            return (SessionCredentialParameter)this.parameters.get(index);
        }

        public boolean equals(Object o) {
            if (!(o instanceof SessionCredentialItem)) {
                return false;
            }
            SessionCredentialItem sci = (SessionCredentialItem)o;
            if (!this.regexp.equals(sci.regexp)) {
                return false;
            }
            if (this.preferredRedirectionRegexp == null || sci.preferredRedirectionRegexp == null ? this.preferredRedirectionRegexp != sci.preferredRedirectionRegexp : !this.preferredRedirectionRegexp.equals(sci.preferredRedirectionRegexp)) {
                return false;
            }
            if (this.preferredLinkRegexp == null || sci.preferredLinkRegexp == null ? this.preferredLinkRegexp != sci.preferredLinkRegexp : !this.preferredLinkRegexp.equals(sci.preferredLinkRegexp)) {
                return false;
            }
            if (this.formNameRegexp == null || sci.formNameRegexp == null ? this.formNameRegexp != sci.formNameRegexp : !this.formNameRegexp.equals(sci.formNameRegexp)) {
                return false;
            }
            if (this.contentRegexp == null || sci.contentRegexp == null ? this.contentRegexp != sci.contentRegexp : !this.contentRegexp.equals(sci.contentRegexp)) {
                return false;
            }
            if (this.parameters.size() != sci.parameters.size()) {
                return false;
            }
            for (int i = 0; i < this.parameters.size(); ++i) {
                if (((SessionCredentialParameter)this.parameters.get(i)).equals((SessionCredentialParameter)sci.parameters.get(i))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int rval = this.regexp.hashCode() + (this.preferredRedirectionRegexp == null ? 0 : this.preferredRedirectionRegexp.hashCode()) + (this.preferredLinkRegexp == null ? 0 : this.preferredLinkRegexp.hashCode()) + (this.formNameRegexp == null ? 0 : this.formNameRegexp.hashCode()) + (this.contentRegexp == null ? 0 : this.contentRegexp.hashCode());
            for (int i = 0; i < this.parameters.size(); ++i) {
                rval += this.parameters.get(i).hashCode();
            }
            return rval;
        }
    }

    protected static class SessionCredentialParameter {
        protected String nameRegexp;
        protected Pattern namePattern;
        protected String value;

        public SessionCredentialParameter(String nameRegexp, Pattern namePattern, String value) {
            this.nameRegexp = nameRegexp;
            this.namePattern = namePattern;
            this.value = value;
        }

        public Pattern getNamePattern() {
            return this.namePattern;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SessionCredentialParameter)) {
                return false;
            }
            SessionCredentialParameter sc = (SessionCredentialParameter)o;
            return this.nameRegexp.equals(sc.nameRegexp) && this.value.equals(sc.value);
        }

        public int hashCode() {
            return this.nameRegexp.hashCode() + this.value.hashCode();
        }
    }

    protected static class CredentialsItem {
        protected Pattern pattern;
        protected AuthenticationCredentials authentication;

        public CredentialsItem(Pattern p) {
            this.pattern = p;
        }

        public Pattern getPattern() {
            return this.pattern;
        }

        public void setCredential(AuthenticationCredentials authentication) {
            this.authentication = authentication;
        }

        public AuthenticationCredentials getCredential() {
            return this.authentication;
        }
    }
}

