/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.impl.FSClassRegistry;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.TypeImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;

class CASMetadata {
    final TypeSystemImpl ts;
    final FSClassRegistry fsClassRegistry;
    int[] featureOffset;
    int[] fsSpaceReq;
    boolean[] creatableType;
    private static final String[] nonCreatableTypes = new String[]{"uima.cas.Integer", "uima.cas.Float", "uima.cas.String", "uima.cas.ArrayBase", "uima.cas.FSArray", "uima.cas.IntegerArray", "uima.cas.FloatArray", "uima.cas.StringArray", "uima.cas.Sofa", "uima.cas.Byte", "uima.cas.ByteArray", "uima.cas.Boolean", "uima.cas.BooleanArray", "uima.cas.Short", "uima.cas.ShortArray", "uima.cas.Long", "uima.cas.LongArray", "uima.cas.Double", "uima.cas.DoubleArray"};

    CASMetadata(TypeSystemImpl ts, FSClassRegistry fsClassRegistry) {
        this.ts = ts;
        this.fsClassRegistry = fsClassRegistry;
    }

    CASMetadata(TypeSystemImpl ts) {
        this.ts = ts;
        this.fsClassRegistry = new FSClassRegistry(ts);
    }

    void setupFeaturesAndCreatableTypes() {
        this.computeFeatureOffsets();
        int numTypes = this.ts.getNumberOfTypes();
        this.fsSpaceReq = new int[numTypes + 1];
        for (int i = 1; i <= numTypes; ++i) {
            this.fsSpaceReq[i] = this.ts.ll_getAppropriateFeatures(i).length + 1;
        }
        this.initCreatableTypeTable();
    }

    private final void computeFeatureOffsets() {
        int numFeats = this.ts.getNumberOfFeatures();
        this.featureOffset = new int[numFeats + 1];
        Type startType = this.ts.getTopType();
        this.computeFeatureOffsets(startType, 0);
    }

    private final void computeFeatureOffsets(Type t, int offset) {
        List<Feature> allFeats = t.getFeatures();
        ArrayList<Feature> introFeats = new ArrayList<Feature>();
        int numAllFeats = allFeats.size();
        for (int i = 0; i < numAllFeats; ++i) {
            Feature feat = allFeats.get(i);
            if (feat.getDomain() != t) continue;
            introFeats.add(feat);
        }
        int numFeats = introFeats.size();
        for (int i = 0; i < numFeats; ++i) {
            int featCode = ((FeatureImpl)introFeats.get(i)).getCode();
            this.featureOffset[featCode] = offset + 1 + i;
        }
        Vector<Type> immediateSubtypes = this.ts.getDirectlySubsumedTypes(t);
        int numTypes = immediateSubtypes.size();
        for (int i = 0; i < numTypes; ++i) {
            this.computeFeatureOffsets(immediateSubtypes.get(i), offset + numFeats);
        }
    }

    private void initCreatableTypeTable() {
        this.creatableType = new boolean[this.ts.getTypeArraySize()];
        Arrays.fill(this.creatableType, true);
        for (int i = 0; i < nonCreatableTypes.length; ++i) {
            int typeCode = ((TypeImpl)this.ts.getType(nonCreatableTypes[i])).getCode();
            for (int subType = this.ts.getSmallestType(); subType < this.creatableType.length; ++subType) {
                if (!this.ts.subsumes(typeCode, subType)) continue;
                this.creatableType[subType] = false;
            }
        }
    }
}

