/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.segments;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.Region;
import org.apache.pdfbox.jbig2.SegmentHeader;
import org.apache.pdfbox.jbig2.err.InvalidHeaderValueException;
import org.apache.pdfbox.jbig2.image.Bitmaps;
import org.apache.pdfbox.jbig2.io.SubInputStream;
import org.apache.pdfbox.jbig2.segments.GenericRegion;
import org.apache.pdfbox.jbig2.segments.PatternDictionary;
import org.apache.pdfbox.jbig2.segments.RegionSegmentInformation;
import org.apache.pdfbox.jbig2.util.CombinationOperator;
import org.apache.pdfbox.jbig2.util.log.Logger;
import org.apache.pdfbox.jbig2.util.log.LoggerFactory;

public class HalftoneRegion
implements Region {
    private final Logger log = LoggerFactory.getLogger(HalftoneRegion.class);
    private SubInputStream subInputStream;
    private SegmentHeader segmentHeader;
    private long dataHeaderOffset;
    private long dataHeaderLength;
    private long dataOffset;
    private long dataLength;
    private RegionSegmentInformation regionInfo;
    private byte hDefaultPixel;
    private CombinationOperator hCombinationOperator;
    private boolean hSkipEnabled;
    private byte hTemplate;
    private boolean isMMREncoded;
    private int hGridWidth;
    private int hGridHeight;
    private int hGridX;
    private int hGridY;
    private int hRegionX;
    private int hRegionY;
    private Bitmap halftoneRegionBitmap;
    private ArrayList<Bitmap> patterns;

    public HalftoneRegion() {
    }

    public HalftoneRegion(SubInputStream subInputStream) {
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    public HalftoneRegion(SubInputStream subInputStream, SegmentHeader segmentHeader) {
        this.subInputStream = subInputStream;
        this.segmentHeader = segmentHeader;
        this.regionInfo = new RegionSegmentInformation(subInputStream);
    }

    private void parseHeader() throws IOException, InvalidHeaderValueException {
        this.regionInfo.parseHeader();
        this.hDefaultPixel = (byte)this.subInputStream.readBit();
        this.hCombinationOperator = CombinationOperator.translateOperatorCodeToEnum((short)(this.subInputStream.readBits(3) & 0xFL));
        if (this.subInputStream.readBit() == 1) {
            this.hSkipEnabled = true;
        }
        this.hTemplate = (byte)(this.subInputStream.readBits(2) & 0xFL);
        if (this.subInputStream.readBit() == 1) {
            this.isMMREncoded = true;
        }
        this.hGridWidth = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.hGridHeight = (int)(this.subInputStream.readBits(32) & 0xFFFFFFFFFFFFFFFFL);
        this.hGridX = (int)this.subInputStream.readBits(32);
        this.hGridY = (int)this.subInputStream.readBits(32);
        this.hRegionX = (int)this.subInputStream.readBits(16) & 0xFFFF;
        this.hRegionY = (int)this.subInputStream.readBits(16) & 0xFFFF;
        this.computeSegmentDataStructure();
        this.checkInput();
    }

    private void computeSegmentDataStructure() throws IOException {
        this.dataOffset = this.subInputStream.getStreamPosition();
        this.dataHeaderLength = this.dataOffset - this.dataHeaderOffset;
        this.dataLength = this.subInputStream.length() - this.dataHeaderLength;
    }

    private void checkInput() throws InvalidHeaderValueException {
        if (this.isMMREncoded) {
            if (this.hTemplate != 0) {
                this.log.info("hTemplate = " + this.hTemplate + " (should contain the value 0)");
            }
            if (this.hSkipEnabled) {
                this.log.info("hSkipEnabled 0 " + this.hSkipEnabled + " (should contain the value false)");
            }
        }
    }

    @Override
    public Bitmap getRegionBitmap() throws IOException, InvalidHeaderValueException {
        if (null == this.halftoneRegionBitmap) {
            this.halftoneRegionBitmap = new Bitmap(this.regionInfo.getBitmapWidth(), this.regionInfo.getBitmapHeight());
            if (this.patterns == null) {
                this.patterns = this.getPatterns();
            }
            if (this.hDefaultPixel == 1) {
                Arrays.fill(this.halftoneRegionBitmap.getByteArray(), (byte)-1);
            }
            int n = (int)Math.ceil(Math.log(this.patterns.size()) / Math.log(2.0));
            int[][] nArray = this.grayScaleDecoding(n);
            this.renderPattern(nArray);
        }
        return this.halftoneRegionBitmap;
    }

    private void renderPattern(int[][] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < this.hGridHeight; ++i) {
            for (int j = 0; j < this.hGridWidth; ++j) {
                n = this.computeX(i, j);
                n2 = this.computeY(i, j);
                Bitmap bitmap = this.patterns.get(nArray[i][j]);
                Bitmaps.blit(bitmap, this.halftoneRegionBitmap, n + this.hGridX, n2 + this.hGridY, this.hCombinationOperator);
            }
        }
    }

    private ArrayList<Bitmap> getPatterns() throws InvalidHeaderValueException, IOException {
        ArrayList<Bitmap> arrayList = new ArrayList<Bitmap>();
        for (SegmentHeader segmentHeader : this.segmentHeader.getRtSegments()) {
            PatternDictionary patternDictionary = (PatternDictionary)segmentHeader.getSegmentData();
            arrayList.addAll(patternDictionary.getDictionary());
        }
        return arrayList;
    }

    private int[][] grayScaleDecoding(int n) throws IOException {
        short[] sArray = null;
        short[] sArray2 = null;
        if (!this.isMMREncoded) {
            sArray = new short[4];
            sArray2 = new short[4];
            if (this.hTemplate <= 1) {
                sArray[0] = 3;
            } else if (this.hTemplate >= 2) {
                sArray[0] = 2;
            }
            sArray2[0] = -1;
            sArray[1] = -3;
            sArray2[1] = -1;
            sArray[2] = 2;
            sArray2[2] = -2;
            sArray[3] = -2;
            sArray2[3] = -2;
        }
        Bitmap[] bitmapArray = new Bitmap[n];
        GenericRegion genericRegion = new GenericRegion(this.subInputStream);
        genericRegion.setParameters(this.isMMREncoded, this.dataOffset, this.dataLength, this.hGridHeight, this.hGridWidth, this.hTemplate, false, this.hSkipEnabled, sArray, sArray2);
        int n2 = n - 1;
        bitmapArray[n2] = genericRegion.getRegionBitmap();
        while (n2 > 0) {
            genericRegion.resetBitmap();
            bitmapArray[--n2] = genericRegion.getRegionBitmap();
            bitmapArray = this.combineGrayScalePlanes(bitmapArray, n2);
        }
        return this.computeGrayScaleValues(bitmapArray, n);
    }

    private Bitmap[] combineGrayScalePlanes(Bitmap[] bitmapArray, int n) {
        int n2 = 0;
        for (int i = 0; i < bitmapArray[n].getHeight(); ++i) {
            for (int j = 0; j < bitmapArray[n].getWidth(); j += 8) {
                byte by = bitmapArray[n + 1].getByte(n2);
                byte by2 = bitmapArray[n].getByte(n2);
                bitmapArray[n].setByte(n2++, Bitmaps.combineBytes(by2, by, CombinationOperator.XOR));
            }
        }
        return bitmapArray;
    }

    private int[][] computeGrayScaleValues(Bitmap[] bitmapArray, int n) {
        int[][] nArray = new int[this.hGridHeight][this.hGridWidth];
        for (int i = 0; i < this.hGridHeight; ++i) {
            for (int j = 0; j < this.hGridWidth; j += 8) {
                int n2 = this.hGridWidth - j > 8 ? 8 : this.hGridWidth - j;
                int n3 = bitmapArray[0].getByteIndex(j, i);
                for (int k = 0; k < n2; ++k) {
                    int n4 = k + j;
                    nArray[i][n4] = 0;
                    for (int i2 = 0; i2 < n; ++i2) {
                        int[] nArray2 = nArray[i];
                        int n5 = n4;
                        nArray2[n5] = nArray2[n5] + (bitmapArray[i2].getByte(n3) >> (7 - n4 & 7) & 1) * (1 << i2);
                    }
                }
            }
        }
        return nArray;
    }

    private int computeX(int n, int n2) {
        return this.shiftAndFill(this.hGridX + n * this.hRegionY + n2 * this.hRegionX);
    }

    private int computeY(int n, int n2) {
        return this.shiftAndFill(this.hGridY + n * this.hRegionX - n2 * this.hRegionY);
    }

    private int shiftAndFill(int n) {
        if ((n >>= 8) < 0) {
            int n2 = (int)(Math.log(Integer.highestOneBit(n)) / Math.log(2.0));
            for (int i = 1; i < 31 - n2; ++i) {
                n |= 1 << 31 - i;
            }
        }
        return n;
    }

    @Override
    public void init(SegmentHeader segmentHeader, SubInputStream subInputStream) throws InvalidHeaderValueException, IOException {
        this.segmentHeader = segmentHeader;
        this.subInputStream = subInputStream;
        this.regionInfo = new RegionSegmentInformation(this.subInputStream);
        this.parseHeader();
    }

    public CombinationOperator getCombinationOperator() {
        return this.hCombinationOperator;
    }

    @Override
    public RegionSegmentInformation getRegionInfo() {
        return this.regionInfo;
    }

    protected byte getHTemplate() {
        return this.hTemplate;
    }

    protected boolean isHSkipEnabled() {
        return this.hSkipEnabled;
    }

    protected boolean isMMREncoded() {
        return this.isMMREncoded;
    }

    protected int getHGridWidth() {
        return this.hGridWidth;
    }

    protected int getHGridHeight() {
        return this.hGridHeight;
    }

    protected int getHGridX() {
        return this.hGridX;
    }

    protected int getHGridY() {
        return this.hGridY;
    }

    protected int getHRegionX() {
        return this.hRegionX;
    }

    protected int getHRegionY() {
        return this.hRegionY;
    }

    protected byte getHDefaultPixel() {
        return this.hDefaultPixel;
    }
}

