/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.server;

import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinitionContainer;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUpdateConflictException;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.DocumentVersion;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.ObjectStore;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoreManager;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.StoredObject;
import org.apache.chemistry.opencmis.inmemory.storedobj.api.VersionedDocument;

public class AbstractServiceImpl {
    protected final StoreManager fStoreManager;

    protected AbstractServiceImpl(StoreManager storeManager) {
        this.fStoreManager = storeManager;
    }

    protected StoredObject checkStandardParameters(String repositoryId, String objectId) {
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (objStore == null) {
            throw new CmisObjectNotFoundException("Unknown repository id: " + repositoryId);
        }
        StoredObject so = objStore.getObjectById(objectId);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        return so;
    }

    protected StoredObject checkExistingObjectId(ObjectStore objStore, String objectId) {
        StoredObject so = objStore.getObjectById(objectId);
        if (so == null) {
            throw new CmisObjectNotFoundException("Unknown object id: " + objectId);
        }
        return so;
    }

    protected void checkRepositoryId(String repositoryId) {
        ObjectStore objStore = this.fStoreManager.getObjectStore(repositoryId);
        if (objStore == null) {
            throw new CmisObjectNotFoundException("Unknown repository id: " + repositoryId);
        }
    }

    protected TypeDefinition getTypeDefinition(String repositoryId, Properties properties, boolean cmis11) {
        String typeId = (String)((PropertyData)properties.getProperties().get("cmis:objectTypeId")).getFirstValue();
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, typeId, cmis11);
        if (typeDefC == null) {
            throw new CmisInvalidArgumentException("Cannot create object, a type with id " + typeId + " is unknown");
        }
        return typeDefC.getTypeDefinition();
    }

    protected TypeDefinition getTypeDefinition(String repositoryId, StoredObject obj, boolean cmis11) {
        TypeDefinitionContainer typeDefC = this.fStoreManager.getTypeById(repositoryId, obj.getTypeId(), cmis11);
        return typeDefC.getTypeDefinition();
    }

    protected VersionedDocument getVersionedDocumentOfObjectId(StoredObject so) {
        VersionedDocument verDoc = so instanceof DocumentVersion ? ((DocumentVersion)so).getParentDocument() : (VersionedDocument)so;
        return verDoc;
    }

    protected VersionedDocument testIsNotCheckedOutBySomeoneElse(StoredObject so, String user) {
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        if (verDoc.isCheckedOut()) {
            this.testCheckedOutByCurrentUser(user, verDoc);
        }
        return verDoc;
    }

    protected VersionedDocument testHasProperCheckedOutStatus(StoredObject so, String user) {
        this.checkIsVersionableObject(so);
        VersionedDocument verDoc = this.getVersionedDocumentOfObjectId(so);
        this.checkHasUser(user);
        this.testIsCheckedOut(verDoc);
        this.testCheckedOutByCurrentUser(user, verDoc);
        return verDoc;
    }

    protected void checkIsVersionableObject(StoredObject so) {
        if (!(so instanceof VersionedDocument) && !(so instanceof DocumentVersion)) {
            throw new CmisInvalidArgumentException("Object " + so.getId() + " must of a versionable type.");
        }
    }

    protected void checkHasUser(String user) {
        if (null == user || user.length() == 0) {
            throw new CmisUpdateConflictException("Object can't be checked-in, no user is given.");
        }
    }

    protected void testCheckedOutByCurrentUser(String user, VersionedDocument verDoc) {
        if (!user.equals(verDoc.getCheckedOutBy())) {
            throw new CmisUpdateConflictException("Object can't be checked-in, user " + verDoc.getCheckedOutBy() + " has checked out the document.");
        }
    }

    protected void testIsCheckedOut(VersionedDocument verDoc) {
        if (!verDoc.isCheckedOut()) {
            throw new CmisUpdateConflictException("Canot check-in: Document " + verDoc.getId() + " is not checked out.");
        }
    }
}

