/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.jbig2.image;

import java.awt.image.WritableRaster;
import org.apache.pdfbox.jbig2.Bitmap;
import org.apache.pdfbox.jbig2.image.Scanline;
import org.apache.pdfbox.jbig2.image.Weighttab;

final class BitmapScanline
extends Scanline {
    private Bitmap bitmap;
    private WritableRaster raster;
    private int[] lineBuffer;

    public BitmapScanline(Bitmap bitmap, WritableRaster writableRaster, int n) {
        super(n);
        this.bitmap = bitmap;
        this.raster = writableRaster;
        this.lineBuffer = new int[this.length];
    }

    @Override
    protected void clear() {
        this.lineBuffer = new int[this.length];
    }

    @Override
    protected void fetch(int n, int n2) {
        this.lineBuffer = new int[this.length];
        int n3 = this.bitmap.getByteIndex(n, n2);
        while (n < this.length) {
            byte by = ~this.bitmap.getByte(n3++);
            int n4 = this.bitmap.getWidth() - n > 8 ? 8 : this.bitmap.getWidth() - n;
            int n5 = n4 - 1;
            while (n5 >= 0) {
                if ((by >> n5 & 1) != 0) {
                    this.lineBuffer[n] = 255;
                }
                --n5;
                ++n;
            }
        }
    }

    @Override
    protected void filter(int[] nArray, int[] nArray2, Weighttab[] weighttabArray, Scanline scanline) {
        BitmapScanline bitmapScanline = (BitmapScanline)scanline;
        int n = scanline.length;
        int n2 = 1 << nArray2[0] - 1;
        int[] nArray3 = this.lineBuffer;
        int[] nArray4 = bitmapScanline.lineBuffer;
        int n3 = nArray[0];
        int n4 = nArray2[0];
        if (n3 != 0) {
            int n5 = 0;
            for (int i = 0; i < n; ++i) {
                int n6;
                Weighttab weighttab = weighttabArray[i];
                int n7 = weighttab.weights.length;
                int n8 = n2;
                int n9 = weighttab.i0;
                for (n6 = 0; n6 < n7 && n9 < nArray3.length; ++n6) {
                    n8 += weighttab.weights[n6] * (nArray3[n9++] >> n3);
                }
                n6 = n8 >> n4;
                nArray4[n5++] = n6 < 0 ? 0 : (n6 > 255 ? 255 : n6);
            }
        } else {
            int n10 = 0;
            for (int i = 0; i < n; ++i) {
                Weighttab weighttab = weighttabArray[i];
                int n11 = weighttab.weights.length;
                int n12 = n2;
                int n13 = weighttab.i0;
                for (int j = 0; j < n11 && n13 < nArray3.length; ++j) {
                    n12 += weighttab.weights[j] * nArray3[n13++];
                }
                nArray4[n10++] = n12 >> n4;
            }
        }
    }

    @Override
    protected void accumulate(int n, Scanline scanline) {
        BitmapScanline bitmapScanline = (BitmapScanline)scanline;
        int[] nArray = this.lineBuffer;
        int[] nArray2 = bitmapScanline.lineBuffer;
        for (int i = 0; i < nArray2.length; ++i) {
            int n2 = i;
            nArray2[n2] = nArray2[n2] + n * nArray[i];
        }
    }

    @Override
    protected void shift(int[] nArray) {
        int n = nArray[0];
        int n2 = 1 << n - 1;
        int[] nArray2 = this.lineBuffer;
        for (int i = 0; i < nArray2.length; ++i) {
            int n3 = nArray2[i] + n2 >> n;
            nArray2[i] = n3 < 0 ? 0 : (n3 > 255 ? 255 : n3);
        }
    }

    @Override
    protected void store(int n, int n2) {
        this.raster.setSamples(n, n2, this.length, 1, 0, this.lineBuffer);
    }
}

