/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentiment;

import java.io.IOException;
import opennlp.tools.sentiment.SentimentSample;
import opennlp.tools.tokenize.WhitespaceTokenizer;
import opennlp.tools.util.FilterObjectStream;
import opennlp.tools.util.ObjectStream;

public class SentimentSampleStream
extends FilterObjectStream<String, SentimentSample> {
    public SentimentSampleStream(ObjectStream<String> samples) {
        super(samples);
    }

    public SentimentSample read() throws IOException {
        String sentence = (String)this.samples.read();
        if (sentence != null) {
            String[] tokens = WhitespaceTokenizer.INSTANCE.tokenize(sentence);
            if (tokens.length <= 1) {
                throw new IOException("Empty lines, or lines with only a category string are not allowed!");
            }
            String sentiment = tokens[0];
            String[] sentTokens = new String[tokens.length - 1];
            System.arraycopy(tokens, 1, sentTokens, 0, tokens.length - 1);
            SentimentSample sample = new SentimentSample(sentiment, sentTokens);
            return sample;
        }
        return null;
    }
}

