/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.codehaus.plexus.util.StringUtils;
import org.jdom2.Content;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.Parent;
import org.jdom2.Text;
import org.jdom2.filter.Filters;

public class JDomUtils {
    private static final Map<String, List<String>> ELEMENT_ORDER = new HashMap<String, List<String>>();

    private JDomUtils() {
    }

    public static Element insertNewElement(String name, Element root) {
        return JDomUtils.insertNewElement(name, root, JDomUtils.calcNewElementIndex(name, root));
    }

    public static Element insertNewElement(String name, Element root, int index) {
        boolean parentHasMinimalContent;
        String indent = JDomUtils.detectIndentation(root);
        Element newElement = JDomUtils.createElement(name, root.getNamespace());
        boolean bl = parentHasMinimalContent = root.getContentSize() == 1 && root.getContent(0) instanceof Text && ((Text)root.getContent(0)).getText().trim().isEmpty();
        if (parentHasMinimalContent) {
            root.removeContent();
            index = 0;
        }
        root.addContent(index, (Content)newElement);
        JDomUtils.addAppropriateSpacing(root, index, name, indent);
        JDomUtils.ensureProperClosingTagFormatting(root);
        JDomUtils.ensureProperClosingTagFormatting(newElement);
        return newElement;
    }

    private static Element createElement(String name, Namespace namespace) {
        Element newElement = new Element(name, namespace);
        newElement.addContent((Content)new Text(""));
        return newElement;
    }

    private static void addAppropriateSpacing(Element root, int index, String elementName, String indent) {
        Content prevContent;
        String prependingElementName = "";
        if (index > 0 && (prevContent = root.getContent(index - 1)) instanceof Element) {
            prependingElementName = ((Element)prevContent).getName();
        }
        if (JDomUtils.isBlankLineBetweenElements(prependingElementName, elementName, root)) {
            root.addContent(index, (Content)new Text("\n"));
            root.addContent(index + 1, (Content)new Text("\n" + indent));
        } else {
            root.addContent(index, (Content)new Text("\n" + indent));
        }
    }

    private static void ensureProperClosingTagFormatting(Element parent) {
        List contents = parent.getContent();
        String parentIndent = JDomUtils.detectParentIndentation(parent);
        if (contents.isEmpty() || contents.size() == 1 && contents.get(0) instanceof Text && ((Text)contents.get(0)).getText().trim().isEmpty()) {
            parent.removeContent();
            parent.addContent((Content)new Text("\n" + parentIndent));
            return;
        }
        Content lastContent = (Content)contents.get(contents.size() - 1);
        if (lastContent instanceof Text) {
            String text = ((Text)lastContent).getText();
            if (!text.endsWith("\n" + parentIndent)) {
                if (text.trim().isEmpty()) {
                    parent.removeContent(lastContent);
                    parent.addContent((Content)new Text("\n" + parentIndent));
                } else {
                    parent.addContent((Content)new Text("\n" + parentIndent));
                }
            }
        } else {
            parent.addContent((Content)new Text("\n" + parentIndent));
        }
    }

    private static String detectParentIndentation(Element element) {
        Parent parent = element.getParent();
        if (parent instanceof Element) {
            return JDomUtils.detectIndentation((Element)parent);
        }
        return "";
    }

    public static Element insertContentElement(Element parent, String name, String content) {
        Element element = JDomUtils.insertNewElement(name, parent);
        element.setText(content);
        return element;
    }

    public static String detectIndentation(Element element) {
        Iterator iterator = element.getContent(Filters.textOnly()).iterator();
        while (iterator.hasNext()) {
            String text = ((Text)iterator.next()).getText();
            int lastLsIndex = StringUtils.lastIndexOfAny((String)text, (String[])new String[]{"\n", "\r"});
            if (lastLsIndex <= -1) continue;
            String indent = text.substring(lastLsIndex + 1);
            if (iterator.hasNext()) {
                return indent;
            }
            String baseIndent = JDomUtils.detectBaseIndentationUnit(element);
            return indent + baseIndent;
        }
        Parent parent = element.getParent();
        if (parent instanceof Element) {
            String baseIndent = JDomUtils.detectBaseIndentationUnit(element);
            return JDomUtils.detectIndentation((Element)parent) + baseIndent;
        }
        return "";
    }

    public static String detectBaseIndentationUnit(Element element) {
        Element root = element;
        while (root.getParent() instanceof Element) {
            root = (Element)root.getParent();
        }
        HashMap<String, Integer> indentationCounts = new HashMap<String, Integer>();
        JDomUtils.collectIndentationSamples(root, indentationCounts, "");
        return JDomUtils.analyzeIndentationPattern(indentationCounts);
    }

    private static void collectIndentationSamples(Element element, Map<String, Integer> indentationCounts, String parentIndent) {
        Iterator iterator = element.getContent(Filters.textOnly()).iterator();
        while (iterator.hasNext()) {
            String text = ((Text)iterator.next()).getText();
            int lastLsIndex = StringUtils.lastIndexOfAny((String)text, (String[])new String[]{"\n", "\r"});
            if (lastLsIndex <= -1) continue;
            String indent = text.substring(lastLsIndex + 1);
            if (!iterator.hasNext() || indent.isEmpty() || indent.length() <= parentIndent.length()) continue;
            String indentDiff = indent.substring(parentIndent.length());
            indentationCounts.merge(indentDiff, 1, Integer::sum);
        }
        for (Element child : element.getChildren()) {
            String childIndent = JDomUtils.detectIndentationForElement(element, child);
            if (childIndent == null || childIndent.length() <= parentIndent.length()) continue;
            String indentDiff = childIndent.substring(parentIndent.length());
            indentationCounts.merge(indentDiff, 1, Integer::sum);
            JDomUtils.collectIndentationSamples(child, indentationCounts, childIndent);
        }
    }

    private static String detectIndentationForElement(Element parent, Element child) {
        String text;
        int lastLsIndex;
        Content prevContent;
        int childIndex = parent.indexOf((Content)child);
        if (childIndex > 0 && (prevContent = parent.getContent(childIndex - 1)) instanceof Text && (lastLsIndex = StringUtils.lastIndexOfAny((String)(text = ((Text)prevContent).getText()), (String[])new String[]{"\n", "\r"})) > -1) {
            return text.substring(lastLsIndex + 1);
        }
        return null;
    }

    private static String analyzeIndentationPattern(Map<String, Integer> indentationCounts) {
        if (indentationCounts.isEmpty()) {
            return "  ";
        }
        String mostCommon = indentationCounts.entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey).orElse("  ");
        if (mostCommon.matches("^\\s+$")) {
            return mostCommon;
        }
        Set<String> patterns = indentationCounts.keySet();
        if (patterns.stream().anyMatch(p -> p.equals("    "))) {
            return "    ";
        }
        if (patterns.stream().anyMatch(p -> p.equals("\t"))) {
            return "\t";
        }
        if (patterns.stream().anyMatch(p -> p.equals("  "))) {
            return "  ";
        }
        return mostCommon.isEmpty() ? "  " : mostCommon;
    }

    private static int calcNewElementIndex(String elementName, Element parent) {
        List<String> elementOrder = ELEMENT_ORDER.get(parent.getName());
        if (elementOrder == null || elementOrder.isEmpty()) {
            return parent.getContentSize();
        }
        int targetIndex = elementOrder.indexOf(elementName);
        if (targetIndex == -1) {
            return parent.getContentSize();
        }
        List contents = parent.getContent();
        for (int i = contents.size() - 1; i >= 0; --i) {
            Element element;
            int currentIndex;
            Content content = (Content)contents.get(i);
            if (!(content instanceof Element) || (currentIndex = elementOrder.indexOf((element = (Element)content).getName())) == -1 || currentIndex > targetIndex) continue;
            return i + 1;
        }
        return 0;
    }

    private static boolean isBlankLineBetweenElements(String prependingElementName, String elementName, Element parent) {
        List<String> elementOrder = ELEMENT_ORDER.get(parent.getName());
        if (elementOrder == null || elementOrder.isEmpty()) {
            return false;
        }
        int prependingIndex = elementOrder.indexOf(prependingElementName);
        int currentIndex = elementOrder.indexOf(elementName);
        if (prependingIndex == -1 || currentIndex == -1) {
            return false;
        }
        for (int i = prependingIndex + 1; i < currentIndex; ++i) {
            if (!elementOrder.get(i).isEmpty()) continue;
            return true;
        }
        return false;
    }

    static {
        ELEMENT_ORDER.put("project", Arrays.asList("modelVersion", "", "parent", "", "groupId", "artifactId", "version", "packaging", "", "name", "description", "url", "inceptionYear", "organization", "licenses", "", "developers", "contributors", "", "mailingLists", "", "prerequisites", "", "modules", "", "scm", "issueManagement", "ciManagement", "distributionManagement", "", "properties", "", "dependencyManagement", "dependencies", "", "repositories", "pluginRepositories", "", "build", "", "reporting", "", "profiles"));
        ELEMENT_ORDER.put("build", Arrays.asList("defaultGoal", "directory", "finalName", "sourceDirectory", "scriptSourceDirectory", "testSourceDirectory", "outputDirectory", "testOutputDirectory", "extensions", "", "pluginManagement", "plugins"));
        ELEMENT_ORDER.put("plugin", Arrays.asList("groupId", "artifactId", "version", "extensions", "executions", "dependencies", "goals", "inherited", "configuration"));
        ELEMENT_ORDER.put("dependency", Arrays.asList("groupId", "artifactId", "version", "classifier", "type", "scope", "systemPath", "optional", "exclusions"));
    }
}

