/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

/**
 * Provides the API for the Maven Shell tool ({@code mvnsh}).
 *
 * <p>This package contains interfaces and classes for the interactive Maven shell,
 * which provides a command-line interface for executing Maven commands and
 * managing build environments.</p>
 *
 * <p>Key features include:</p>
 * <ul>
 *   <li>Interactive command-line interface</li>
 *   <li>Command history and completion</li>
 *   <li>Built-in shell commands</li>
 *   <li>Project navigation and management</li>
 * </ul>
 *
 * @see org.apache.maven.api.cli.Tools#MVNSHELL_CMD
 * @see org.apache.maven.api.cli.Tools#MVNSHELL_NAME
 * @since 4.0.0
 */
package org.apache.maven.api.cli.mvnsh;
