/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.util.diff;

import java.util.List;
import java.util.Objects;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.util.Preconditions;
import org.assertj.core.util.diff.Chunk;

public abstract class Delta<T> {
    public static final String DEFAULT_END = "]";
    public static final String DEFAULT_START = "[";
    private Chunk<T> original;
    private Chunk<T> revised;

    public Delta(Chunk<T> original, Chunk<T> revised) {
        Preconditions.checkArgument(original != null, "original must not be null", new Object[0]);
        Preconditions.checkArgument(revised != null, "revised must not be null", new Object[0]);
        this.original = original;
        this.revised = revised;
    }

    public abstract void verify(List<T> var1) throws IllegalStateException;

    public abstract void applyTo(List<T> var1) throws IllegalStateException;

    public abstract TYPE getType();

    public Chunk<T> getOriginal() {
        return this.original;
    }

    public Chunk<T> getRevised() {
        return this.revised;
    }

    public int hashCode() {
        return Objects.hash(this.original, this.revised);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Delta other = (Delta)obj;
        return Objects.equals(this.original, other.original) && Objects.equals(this.revised, other.revised);
    }

    public int lineNumber() {
        return this.getOriginal().getPosition() + 1;
    }

    public String toString() {
        return ConfigurationProvider.CONFIGURATION_PROVIDER.representation().toStringOf(this);
    }

    public static enum TYPE {
        CHANGE,
        DELETE,
        INSERT;

    }
}

