/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.signature;

import java.security.spec.ECParameterSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.cipher.ECCurves;
import org.apache.sshd.common.config.NamedFactoriesListParseResult;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureDSA;
import org.apache.sshd.common.signature.SignatureECDSA;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.signature.SignatureRSASHA1;
import org.apache.sshd.common.signature.SignatureRSASHA256;
import org.apache.sshd.common.signature.SignatureRSASHA512;
import org.apache.sshd.common.signature.SignatureSkECDSA;
import org.apache.sshd.common.signature.SignatureSkED25519;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.security.SecurityUtils;

public enum BuiltinSignatures implements SignatureFactory
{
    dsa("ssh-dss"){

        @Override
        public Signature create() {
            return new SignatureDSA();
        }
    }
    ,
    dsa_cert("ssh-dss-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureDSA();
        }
    }
    ,
    rsa("ssh-rsa"){

        @Override
        public Signature create() {
            return new SignatureRSASHA1();
        }
    }
    ,
    rsa_cert("ssh-rsa-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureRSASHA1();
        }
    }
    ,
    rsaSHA256("rsa-sha2-256"){

        @Override
        public Signature create() {
            return new SignatureRSASHA256();
        }
    }
    ,
    rsaSHA256_cert("rsa-sha2-256-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureRSASHA256();
        }
    }
    ,
    rsaSHA512("rsa-sha2-512"){
        private final AtomicReference<Boolean> supportHolder = new AtomicReference();

        @Override
        public Signature create() {
            return new SignatureRSASHA512();
        }

        @Override
        public boolean isSupported() {
            Boolean supported = this.supportHolder.get();
            if (supported == null) {
                try {
                    java.security.Signature sig = SecurityUtils.getSignature("SHA512withRSA");
                    supported = sig != null;
                }
                catch (Exception e) {
                    supported = Boolean.FALSE;
                }
                this.supportHolder.set(supported);
            }
            return supported;
        }
    }
    ,
    rsaSHA512_cert("rsa-sha2-512-cert-v01@openssh.com"){
        private final AtomicReference<Boolean> supportHolder = new AtomicReference();

        @Override
        public Signature create() {
            return new SignatureRSASHA512();
        }

        @Override
        public boolean isSupported() {
            Boolean supported = this.supportHolder.get();
            if (supported == null) {
                try {
                    java.security.Signature sig = SecurityUtils.getSignature("SHA512withRSA");
                    supported = sig != null;
                }
                catch (Exception e) {
                    supported = Boolean.FALSE;
                }
                this.supportHolder.set(supported);
            }
            return supported;
        }
    }
    ,
    nistp256(KeyPairProvider.ECDSA_SHA2_NISTP256){

        @Override
        public Signature create() {
            return new SignatureECDSA.SignatureECDSA256();
        }
    }
    ,
    nistp256_cert("ecdsa-sha2-nistp256-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureECDSA.SignatureECDSA256();
        }
    }
    ,
    nistp384(KeyPairProvider.ECDSA_SHA2_NISTP384){

        @Override
        public Signature create() {
            return new SignatureECDSA.SignatureECDSA384();
        }
    }
    ,
    nistp384_cert("ecdsa-sha2-nistp384-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureECDSA.SignatureECDSA384();
        }
    }
    ,
    nistp521(KeyPairProvider.ECDSA_SHA2_NISTP521){

        @Override
        public Signature create() {
            return new SignatureECDSA.SignatureECDSA521();
        }
    }
    ,
    nistp521_cert("ecdsa-sha2-nistp521-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureECDSA.SignatureECDSA521();
        }
    }
    ,
    sk_ecdsa_sha2_nistp256("sk-ecdsa-sha2-nistp256@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureSkECDSA();
        }
    }
    ,
    ed25519("ssh-ed25519"){

        @Override
        public Signature create() {
            return SecurityUtils.getEDDSASigner();
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isEDDSACurveSupported();
        }
    }
    ,
    ed25519_cert("ssh-ed25519-cert-v01@openssh.com"){

        @Override
        public Signature create() {
            return SecurityUtils.getEDDSASigner();
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isEDDSACurveSupported();
        }
    }
    ,
    sk_ssh_ed25519("sk-ssh-ed25519@openssh.com"){

        @Override
        public Signature create() {
            return new SignatureSkED25519();
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isEDDSACurveSupported();
        }
    };

    public static final Set<BuiltinSignatures> VALUES;
    private static final Map<String, SignatureFactory> EXTENSIONS;
    private final String factoryName;

    private BuiltinSignatures(String facName) {
        this.factoryName = facName;
    }

    public static BuiltinSignatures getFactoryByCurveSize(ECParameterSpec params) {
        int curveSize = ECCurves.getCurveSize(params);
        if (curveSize <= 256) {
            return nistp256;
        }
        if (curveSize <= 384) {
            return nistp384;
        }
        return nistp521;
    }

    public static Signature getSignerByCurveSize(ECParameterSpec params) {
        BuiltinSignatures factory = BuiltinSignatures.getFactoryByCurveSize(params);
        return factory == null ? null : (Signature)factory.create();
    }

    @Override
    public final String getName() {
        return this.factoryName;
    }

    public final String toString() {
        return this.getName();
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerExtension(SignatureFactory extension) {
        String name = Objects.requireNonNull(extension, "No extension provided").getName();
        ValidateUtils.checkTrue(BuiltinSignatures.fromFactoryName(name) == null, "Extension overrides built-in: %s", (Object)name);
        Map<String, SignatureFactory> map = EXTENSIONS;
        synchronized (map) {
            ValidateUtils.checkTrue(!EXTENSIONS.containsKey(name), "Extension overrides existing: %s", (Object)name);
            EXTENSIONS.put(name, extension);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NavigableSet<SignatureFactory> getRegisteredExtensions() {
        Map<String, SignatureFactory> map = EXTENSIONS;
        synchronized (map) {
            return GenericUtils.asSortedSet(NamedResource.BY_NAME_COMPARATOR, EXTENSIONS.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignatureFactory unregisterExtension(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        Map<String, SignatureFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.remove(name);
        }
    }

    public static BuiltinSignatures fromString(String s) {
        if (GenericUtils.isEmpty(s)) {
            return null;
        }
        for (BuiltinSignatures c : VALUES) {
            if (!s.equalsIgnoreCase(c.name())) continue;
            return c;
        }
        return null;
    }

    public static BuiltinSignatures fromFactory(NamedFactory<Signature> factory) {
        if (factory == null) {
            return null;
        }
        return BuiltinSignatures.fromFactoryName(factory.getName());
    }

    public static BuiltinSignatures fromFactoryName(String name) {
        return NamedResource.findByName(name, String.CASE_INSENSITIVE_ORDER, VALUES);
    }

    public static ParseResult parseSignatureList(String sigs) {
        return BuiltinSignatures.parseSignatureList(GenericUtils.split(sigs, ','));
    }

    public static ParseResult parseSignatureList(String ... sigs) {
        return BuiltinSignatures.parseSignatureList(GenericUtils.isEmpty((Object[])sigs) ? Collections.emptyList() : Arrays.asList(sigs));
    }

    public static ParseResult parseSignatureList(Collection<String> sigs) {
        if (GenericUtils.isEmpty(sigs)) {
            return ParseResult.EMPTY;
        }
        ArrayList<SignatureFactory> factories = new ArrayList<SignatureFactory>(sigs.size());
        List<String> unknown = Collections.emptyList();
        for (String name : sigs) {
            SignatureFactory s = BuiltinSignatures.resolveFactory(name);
            if (s != null) {
                factories.add(s);
                continue;
            }
            if (unknown.isEmpty()) {
                unknown = new ArrayList<String>();
            }
            unknown.add(name);
        }
        return new ParseResult((List<SignatureFactory>)factories, unknown);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignatureFactory resolveFactory(String name) {
        if (GenericUtils.isEmpty(name)) {
            return null;
        }
        BuiltinSignatures s = BuiltinSignatures.fromFactoryName(name);
        if (s != null) {
            return s;
        }
        Map<String, SignatureFactory> map = EXTENSIONS;
        synchronized (map) {
            return EXTENSIONS.get(name);
        }
    }

    static {
        VALUES = Collections.unmodifiableSet(EnumSet.allOf(BuiltinSignatures.class));
        EXTENSIONS = new TreeMap<String, SignatureFactory>(String.CASE_INSENSITIVE_ORDER);
    }

    public static final class ParseResult
    extends NamedFactoriesListParseResult<Signature, SignatureFactory> {
        public static final ParseResult EMPTY = new ParseResult(Collections.emptyList(), Collections.emptyList());

        public ParseResult(List<SignatureFactory> parsed, List<String> unsupported) {
            super(parsed, unsupported);
        }
    }
}

