/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.session.proxy;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.sshd.client.session.proxy.AbstractAuthenticationHandler;
import org.apache.sshd.client.session.proxy.GssApiMechanisms;
import org.ietf.jgss.GSSContext;

public abstract class GssApiAuthentication<P, T>
extends AbstractAuthenticationHandler<P, T> {
    protected byte[] token;
    private GSSContext context;

    protected GssApiAuthentication(InetSocketAddress proxy) {
        super(proxy);
    }

    @Override
    public void close() {
        GssApiMechanisms.closeContextSilently(this.context);
        this.context = null;
        this.done = true;
    }

    @Override
    public final void start() throws IOException {
        try {
            this.context = this.createContext();
            this.context.requestMutualAuth(true);
            this.context.requestConf(false);
            this.context.requestInteg(false);
            byte[] empty = new byte[]{};
            this.token = this.context.initSecContext(empty, 0, 0);
        }
        catch (Exception e) {
            this.close();
            throw new IOException(e);
        }
    }

    @Override
    public final void process() throws Exception {
        if (this.context == null) {
            throw new IOException("Cannot authenticate using GSS-API at " + this.proxy);
        }
        try {
            byte[] received = this.extractToken(this.params);
            this.token = this.context.initSecContext(received, 0, received.length);
            this.checkDone();
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    private void checkDone() throws Exception {
        this.done = this.context.isEstablished();
        if (this.done) {
            this.context.dispose();
            this.context = null;
        }
    }

    protected abstract GSSContext createContext() throws Exception;

    protected abstract byte[] extractToken(P var1) throws Exception;
}

