/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets.tag.composite;

import jakarta.faces.view.facelets.FaceletContext;
import jakarta.faces.view.facelets.Tag;
import jakarta.faces.view.facelets.TagAttribute;
import java.beans.FeatureDescriptor;
import java.util.Arrays;

public final class CompositeTagAttributeUtils {
    private CompositeTagAttributeUtils() {
    }

    public static void addUnspecifiedAttributes(FeatureDescriptor descriptor, Tag tag, String[] standardAttributesSorted, FaceletContext ctx) {
        for (TagAttribute attribute : tag.getAttributes().getAll()) {
            String name = attribute.getLocalName();
            if (Arrays.binarySearch(standardAttributesSorted, name) >= 0) continue;
            descriptor.setValue(name, attribute.getValueExpression(ctx, Object.class));
        }
    }

    public static boolean containsUnspecifiedAttributes(Tag tag, String[] standardAttributesSorted) {
        for (TagAttribute attribute : tag.getAttributes().getAll()) {
            String name = attribute.getLocalName();
            if (Arrays.binarySearch(standardAttributesSorted, name) >= 0) continue;
            return true;
        }
        return false;
    }

    public static void addDevelopmentAttributes(FeatureDescriptor descriptor, FaceletContext ctx, TagAttribute displayName, TagAttribute shortDescription, TagAttribute expert, TagAttribute hidden, TagAttribute preferred) {
        if (displayName != null) {
            descriptor.setDisplayName(displayName.getValue(ctx));
        }
        if (shortDescription != null) {
            descriptor.setShortDescription(shortDescription.getValue(ctx));
        }
        if (expert != null) {
            descriptor.setExpert(expert.getBoolean(ctx));
        }
        if (hidden != null) {
            descriptor.setHidden(hidden.getBoolean(ctx));
        }
        if (preferred != null) {
            descriptor.setPreferred(preferred.getBoolean(ctx));
        }
    }

    public static void addDevelopmentAttributesLiteral(FeatureDescriptor descriptor, TagAttribute displayName, TagAttribute shortDescription, TagAttribute expert, TagAttribute hidden, TagAttribute preferred) {
        if (displayName != null) {
            descriptor.setDisplayName(displayName.getValue());
        }
        if (shortDescription != null) {
            descriptor.setShortDescription(shortDescription.getValue());
        }
        if (expert != null) {
            descriptor.setExpert(Boolean.valueOf(expert.getValue()));
        }
        if (hidden != null) {
            descriptor.setHidden(Boolean.valueOf(hidden.getValue()));
        }
        if (preferred != null) {
            descriptor.setPreferred(Boolean.valueOf(preferred.getValue()));
        }
    }

    public static boolean areAttributesLiteral(TagAttribute ... attributes) {
        for (TagAttribute attribute : attributes) {
            if (attribute == null || attribute.isLiteral()) continue;
            return false;
        }
        return true;
    }
}

