/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.jpa.impl.transaction.context;

import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.jpa.impl.transaction.context.TransactionBeanEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Typed
public class TransactionBeanStorage {
    private static final Logger LOGGER = Logger.getLogger(TransactionBeanStorage.class.getName());
    private static ThreadLocal<TransactionBeanStorage> currentStorage = new ThreadLocal();
    private Map<String, Stack<Map<Contextual, TransactionBeanEntry>>> storedTransactionContexts = new HashMap<String, Stack<Map<Contextual, TransactionBeanEntry>>>();
    private Map<Contextual, TransactionBeanEntry> activeTransactionContext;
    private String activeTransactionKey = null;

    private TransactionBeanStorage() {
    }

    public static TransactionBeanStorage getStorage() {
        return currentStorage.get();
    }

    public static TransactionBeanStorage activateNewStorage() {
        TransactionBeanStorage previousStorage = currentStorage.get();
        currentStorage.set(new TransactionBeanStorage());
        return previousStorage;
    }

    public static void resetStorage() {
        currentStorage.remove();
        currentStorage.set(null);
    }

    public void startTransactionScope(String transactionKey) {
        Stack<Map<Object, TransactionBeanEntry<Object>>> transStack;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("starting TransactionScope " + transactionKey);
        }
        if ((transStack = this.storedTransactionContexts.get(transactionKey)) == null) {
            transStack = new Stack();
            this.storedTransactionContexts.put(transactionKey, transStack);
        }
        transStack.push(new HashMap());
    }

    public void endTransactionScope(String transactionKey) {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("ending TransactionScope " + transactionKey);
        }
        Stack<Map<Contextual, TransactionBeanEntry>> transStack = this.storedTransactionContexts.get(transactionKey);
        Map<Contextual, TransactionBeanEntry> beans = transStack.pop();
        this.destroyBeans(beans);
        if (transStack.size() == 0) {
            this.storedTransactionContexts.remove(transactionKey);
        }
    }

    public String activateTransactionScope(String transactionKey) {
        Stack<Map<Contextual, TransactionBeanEntry>> transStack;
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("activating TransactionScope " + transactionKey);
        }
        if (transactionKey == null && this.activeTransactionKey == null) {
            this.activeTransactionKey = null;
            this.activeTransactionContext = new HashMap<Contextual, TransactionBeanEntry>();
            return null;
        }
        String oldTransactionContextKey = this.activeTransactionKey;
        if (transactionKey == null) {
            transactionKey = this.activeTransactionKey;
        }
        if ((transStack = this.storedTransactionContexts.get(transactionKey)) == null) {
            throw new IllegalStateException("Cannot activate TransactionScope with key " + transactionKey);
        }
        this.activeTransactionContext = transStack.peek();
        this.activeTransactionKey = transactionKey;
        return oldTransactionContextKey;
    }

    public String getActiveTransactionKey() {
        return this.activeTransactionKey;
    }

    public void endAllTransactionScopes() {
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer("destroying all TransactionScopes");
        }
        for (Stack<Map<Contextual, TransactionBeanEntry>> transStack : this.storedTransactionContexts.values()) {
            while (!transStack.isEmpty()) {
                Map<Contextual, TransactionBeanEntry> beans = transStack.pop();
                this.destroyBeans(beans);
            }
        }
        this.storedTransactionContexts.clear();
        this.activeTransactionContext = null;
        this.activeTransactionKey = null;
    }

    public Map<Contextual, TransactionBeanEntry> getActiveTransactionContext() {
        return this.activeTransactionContext;
    }

    private void destroyBeans(Map<Contextual, TransactionBeanEntry> activeBeans) {
        for (TransactionBeanEntry beanBag : activeBeans.values()) {
            beanBag.getBean().destroy(beanBag.getContextualInstance(), beanBag.getCreationalContext());
        }
    }
}

