/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.extensions.cdi.core.impl.util;

import java.util.logging.Logger;
import javax.enterprise.inject.Typed;
import org.apache.myfaces.extensions.cdi.core.api.Aggregatable;
import org.apache.myfaces.extensions.cdi.core.api.activation.AbstractClassDeactivator;
import org.apache.myfaces.extensions.cdi.core.api.activation.ClassDeactivator;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivatorAggregator;
import org.apache.myfaces.extensions.cdi.core.impl.util.ClassDeactivatorStorage;
import org.apache.myfaces.extensions.cdi.core.impl.util.CodiUtils;

@Typed
public class ClassDeactivation {
    private static final Logger LOGGER = Logger.getLogger(ClassDeactivation.class.getName());

    private ClassDeactivation() {
    }

    public static boolean isClassActivated(Class targetClass) {
        boolean classDeactivated;
        ClassDeactivator classDeactivator = ClassDeactivatorStorage.getClassDeactivator();
        if (classDeactivator == null) {
            classDeactivator = ClassDeactivation.getClassDeactivator();
        }
        return !(classDeactivated = classDeactivator.getDeactivatedClasses().contains(targetClass));
    }

    public static void setClassDeactivator(ClassDeactivator classDeactivator) {
        ClassDeactivatorStorage.setClassDeactivator(classDeactivator);
    }

    private static ClassDeactivator getClassDeactivator() {
        ClassDeactivator classDeactivator = (ClassDeactivator)CodiUtils.lookupFromEnvironment(ClassDeactivator.class, (Aggregatable)new ClassDeactivatorAggregator(), null);
        if (classDeactivator == null) {
            classDeactivator = ClassDeactivation.createClassDeactivatorPlaceholder();
        } else {
            LOGGER.info("used class deactivator: " + classDeactivator.toString());
            for (Class deactivatedClass : classDeactivator.getDeactivatedClasses()) {
                LOGGER.info("deactivate: " + deactivatedClass);
            }
        }
        ClassDeactivatorStorage.setClassDeactivator(classDeactivator);
        return classDeactivator;
    }

    private static AbstractClassDeactivator createClassDeactivatorPlaceholder() {
        return new AbstractClassDeactivator(){
            private static final long serialVersionUID = 3365575383802245760L;

            protected void deactivateClasses() {
            }
        };
    }
}

