/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.test.mock;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;
import javax.faces.context.ResponseWriter;

class _ELText {
    protected final String literal;

    public _ELText(String literal) {
        this.literal = literal;
    }

    public boolean isLiteral() {
        return true;
    }

    public _ELText apply(ExpressionFactory factory, ELContext ctx) {
        return this;
    }

    public void write(Writer out, ELContext ctx) throws ELException, IOException {
        out.write(this.literal);
    }

    public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
        out.writeText((Object)this.literal, null);
    }

    public String toString(ELContext ctx) throws ELException {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    public static boolean isLiteral(String in) {
        _ELText txt = _ELText.parse(in);
        return txt == null || txt.isLiteral();
    }

    public static _ELText parse(String in) throws ELException {
        return _ELText.parse(null, null, in);
    }

    public static _ELText parse(ExpressionFactory fact, ELContext ctx, String in) throws ELException {
        char[] ca = in.toCharArray();
        int i = 0;
        char c = '\u0000';
        int len = ca.length;
        int end = len - 1;
        boolean esc = false;
        int vlen = 0;
        StringBuffer buff = new StringBuffer(128);
        ArrayList<_ELText> text = new ArrayList<_ELText>();
        ELTextVariable t = null;
        ValueExpression ve = null;
        while (i < len) {
            c = ca[i];
            if ('\\' == c) {
                boolean bl = esc = !esc;
                if (esc && i < end && (ca[i + 1] == '$' || ca[i + 1] == '#')) {
                    ++i;
                    continue;
                }
            } else if (!(esc || '$' != c && '#' != c || i >= end || '{' != ca[i + 1])) {
                if (buff.length() > 0) {
                    text.add(new _ELText(buff.toString()));
                    buff.setLength(0);
                }
                vlen = _ELText.findVarLength(ca, i);
                if (ctx != null && fact != null) {
                    ve = fact.createValueExpression(ctx, new String(ca, i, vlen), String.class);
                    t = new ELTextVariable(ve);
                } else {
                    t = new ELTextVariable(new LiteralValueExpression(new String(ca, i, vlen)));
                }
                text.add(t);
                i += vlen;
                continue;
            }
            esc = false;
            buff.append(c);
            ++i;
        }
        if (buff.length() > 0) {
            text.add(new _ELText(new String(buff.toString())));
            buff.setLength(0);
        }
        if (text.size() == 0) {
            return null;
        }
        if (text.size() == 1) {
            return (_ELText)text.get(0);
        }
        _ELText[] ta = text.toArray(new _ELText[text.size()]);
        return new ELTextComposite(ta);
    }

    private static int findVarLength(char[] ca, int s) throws ELException {
        int i;
        int len = ca.length;
        char c = '\u0000';
        char str = '\u0000';
        for (i = s; i < len; ++i) {
            c = ca[i];
            if ('\\' == c && i < len - 1) {
                ++i;
                continue;
            }
            if ('\'' == c || '\"' == c) {
                if (str == c) {
                    str = '\u0000';
                    continue;
                }
                str = c;
                continue;
            }
            if (str != '\u0000' || '}' != c) continue;
            return i - s + 1;
        }
        throw new ELException("EL Expression Unbalanced: ... " + new String(ca, s, i - s));
    }

    private static final class ELTextVariable
    extends _ELText {
        private final ValueExpression ve;

        public ELTextVariable(ValueExpression ve) {
            super(ve.getExpressionString());
            this.ve = ve;
        }

        public boolean isLiteral() {
            return false;
        }

        public _ELText apply(ExpressionFactory factory, ELContext ctx) {
            return new ELTextVariable(factory.createValueExpression(ctx, this.ve.getExpressionString(), String.class));
        }

        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.write((String)v);
            }
        }

        public String toString(ELContext ctx) throws ELException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                return v.toString();
            }
            return null;
        }

        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            Object v = this.ve.getValue(ctx);
            if (v != null) {
                out.writeText((Object)((String)v), null);
            }
        }
    }

    private static final class ELTextComposite
    extends _ELText {
        private final _ELText[] txt;

        public ELTextComposite(_ELText[] txt) {
            super(null);
            this.txt = txt;
        }

        public void write(Writer out, ELContext ctx) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].write(out, ctx);
            }
        }

        public void writeText(ResponseWriter out, ELContext ctx) throws ELException, IOException {
            for (int i = 0; i < this.txt.length; ++i) {
                this.txt[i].writeText(out, ctx);
            }
        }

        public String toString(ELContext ctx) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                sb.append(this.txt[i].toString(ctx));
            }
            return sb.toString();
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < this.txt.length; ++i) {
                sb.append(this.txt[i].toString());
            }
            return sb.toString();
        }

        public boolean isLiteral() {
            return false;
        }

        public _ELText apply(ExpressionFactory factory, ELContext ctx) {
            int len = this.txt.length;
            _ELText[] nt = new _ELText[len];
            for (int i = 0; i < len; ++i) {
                nt[i] = this.txt[i].apply(factory, ctx);
            }
            return new ELTextComposite(nt);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LiteralValueExpression
    extends ValueExpression {
        private static final long serialVersionUID = 1L;
        private final String text;

        public LiteralValueExpression(String text) {
            this.text = text;
        }

        public boolean isLiteralText() {
            return false;
        }

        public int hashCode() {
            return 0;
        }

        public String getExpressionString() {
            return this.text;
        }

        public boolean equals(Object obj) {
            return false;
        }

        public void setValue(ELContext context, Object value) {
        }

        public boolean isReadOnly(ELContext context) {
            return false;
        }

        public Object getValue(ELContext context) {
            return null;
        }

        public Class<?> getType(ELContext context) {
            return null;
        }

        public Class<?> getExpectedType() {
            return null;
        }
    }
}

