/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit.html.standard.standard.tag;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.validator.LengthValidator;
import javax.faces.validator.Validator;
import org.apache.myfaces.tobago.internal.component.AbstractUIIn;
import org.apache.myfaces.tobago.internal.component.AbstractUIInput;
import org.apache.myfaces.tobago.internal.util.FacesContextUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.layout.LayoutBase;
import org.apache.myfaces.tobago.renderkit.InputRendererBase;
import org.apache.myfaces.tobago.renderkit.css.Classes;
import org.apache.myfaces.tobago.renderkit.css.Style;
import org.apache.myfaces.tobago.renderkit.html.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InRenderer
extends InputRendererBase {
    private static final Logger LOG = LoggerFactory.getLogger(InRenderer.class);

    public void decode(FacesContext facesContext, UIComponent component) {
        super.decode(facesContext, component);
        String clientId = component.getClientId(facesContext);
        if (clientId.equals(FacesContextUtils.getActionId((FacesContext)facesContext))) {
            facesContext.renderResponse();
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        AbstractUIInput input = (AbstractUIInput)component;
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, (UIComponent)input);
        String currentValue = this.getCurrentValue(facesContext, (UIComponent)input);
        boolean password = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"password");
        if (LOG.isDebugEnabled()) {
            LOG.debug("currentValue = '{}'", (Object)StringUtils.toConfidentialString((String)currentValue, (boolean)password));
        }
        String type = password ? "password" : "text";
        String id = input.getClientId(facesContext);
        boolean readonly = input.isReadonly();
        boolean disabled = input.isDisabled();
        boolean required = ComponentUtils.getBooleanAttribute((UIComponent)input, (String)"required");
        TobagoResponseWriter writer = HtmlRendererUtils.getTobagoResponseWriter(facesContext);
        writer.startElement("input", (UIComponent)input);
        writer.writeAttribute("type", type, false);
        writer.writeNameAttribute(id);
        writer.writeIdAttribute(id);
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, (UIComponent)input);
        if (currentValue != null && !password) {
            writer.writeAttribute("value", currentValue, true);
        }
        if (title != null) {
            writer.writeAttribute("title", title, true);
        }
        int maxLength = 0;
        String pattern = null;
        for (Validator validator : input.getValidators()) {
            if (!(validator instanceof LengthValidator)) continue;
            LengthValidator lengthValidator = (LengthValidator)validator;
            maxLength = lengthValidator.getMaximum();
        }
        if (maxLength > 0) {
            writer.writeAttribute("maxlength", maxLength);
        }
        if (pattern != null) {
            writer.writeAttribute("pattern", pattern, false);
        }
        writer.writeAttribute("readonly", readonly);
        writer.writeAttribute("disabled", disabled);
        Integer tabIndex = input.getTabIndex();
        if (tabIndex != null) {
            writer.writeAttribute("tabindex", tabIndex.intValue());
        }
        Style style = new Style(facesContext, (LayoutBase)input);
        writer.writeStyleAttribute(style);
        if (!disabled && !readonly) {
            writer.writeAttribute("placeholder", input.getPlaceholder(), true);
        }
        if (input instanceof AbstractUIIn && ((AbstractUIIn)input).getSuggest() != null) {
            writer.writeAttribute("autocomplete", "off", false);
        }
        writer.writeClassAttribute(Classes.create((UIComponent)input));
        writer.writeAttribute("required", required);
        HtmlRendererUtils.renderFocus(id, input.isFocus(), ComponentUtils.isError((UIInput)input), facesContext, writer);
        this.writeAdditionalAttributes(facesContext, writer, input);
        HtmlRendererUtils.renderCommandFacet((UIComponent)input, facesContext, writer);
        writer.endElement("input");
    }

    protected void writeAdditionalAttributes(FacesContext facesContext, TobagoResponseWriter writer, AbstractUIInput input) throws IOException {
    }
}

