/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.internal.renderkit.renderer;

import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIParameter;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.apache.myfaces.tobago.component.Attributes;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.SupportsAccessKey;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.internal.component.AbstractUIBadge;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUICommandBase;
import org.apache.myfaces.tobago.internal.component.AbstractUIFormBase;
import org.apache.myfaces.tobago.internal.component.AbstractUILink;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectBooleanCheckbox;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectBooleanToggle;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectManyCheckbox;
import org.apache.myfaces.tobago.internal.component.AbstractUISelectOneRadio;
import org.apache.myfaces.tobago.internal.component.AbstractUISeparator;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.renderkit.renderer.DecodingCommandRendererBase;
import org.apache.myfaces.tobago.internal.util.AccessKeyLogger;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.renderkit.LabelWithAccessKey;
import org.apache.myfaces.tobago.renderkit.css.BootstrapClass;
import org.apache.myfaces.tobago.renderkit.css.CssItem;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.Arias;
import org.apache.myfaces.tobago.renderkit.html.DataAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlButtonTypes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommandRendererBase<T extends AbstractUICommand>
extends DecodingCommandRendererBase<T> {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public void encodeBeginInternal(FacesContext facesContext, T component) throws IOException {
        String clientId = component.getClientId(facesContext);
        boolean disabled = ((AbstractUICommandBase)((Object)component)).isDisabled();
        LabelWithAccessKey label = new LabelWithAccessKey((SupportsAccessKey)component);
        String image = ((AbstractUICommand)component).getImage();
        UIComponent labelFacet = ComponentUtils.getFacet(component, Facets.label);
        boolean anchor = (((AbstractUICommandBase)((Object)component)).getLink() != null || ((AbstractUICommandBase)((Object)component)).getOutcome() != null) && !disabled;
        String target = ((AbstractUICommandBase)((Object)component)).getTarget();
        boolean autoSpacing = component.getAutoSpacing(facesContext);
        boolean parentOfCommands = ((AbstractUICommand)component).isParentOfCommands();
        boolean dropdownSubmenu = this.isInside(facesContext, HtmlElements.COMMAND);
        Markup markup = component.getMarkup() != null ? component.getMarkup() : Markup.NULL;
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        this.encodeBeginOuter(facesContext, component);
        if (anchor) {
            writer.startElement(HtmlElements.A);
        } else {
            writer.startElement(HtmlElements.BUTTON);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TYPE, HtmlButtonTypes.BUTTON);
        }
        writer.writeIdAttribute(((AbstractUICommand)component).getFieldId(facesContext));
        writer.writeNameAttribute(clientId);
        writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, disabled);
        if (!disabled) {
            int tabIndex;
            if (anchor) {
                String href = RenderUtils.generateUrl(facesContext, component);
                writer.writeAttribute(HtmlAttributes.HREF, href, true);
                writer.writeAttribute(HtmlAttributes.TARGET, target, true);
                ((AbstractUICommandBase)((Object)component)).setOmit(true);
            }
            if (label.getAccessKey() != null) {
                writer.writeAttribute(HtmlAttributes.ACCESSKEY, Character.toString(label.getAccessKey().charValue()), false);
                AccessKeyLogger.addAccessKey(facesContext, label.getAccessKey(), clientId);
            }
            if ((tabIndex = ComponentUtils.getIntAttribute(component, Attributes.tabIndex)) != 0) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.TABINDEX, tabIndex);
            }
        }
        HtmlRendererUtils.writeDataAttributes(facesContext, writer, component);
        if (parentOfCommands) {
            writer.writeAttribute(Arias.EXPANDED, Boolean.FALSE.toString(), false);
        }
        String title = HtmlRendererUtils.getTitleFromTipAndMessages(facesContext, component);
        writer.writeAttribute(HtmlAttributes.TITLE, title, true);
        writer.writeClassAttribute(this.getRendererCssClass(), this.getCssItems(facesContext, component), new CssItem[]{autoSpacing && !dropdownSubmenu ? TobagoClass.AUTO__SPACING : null, dropdownSubmenu ? BootstrapClass.DROPDOWN_ITEM : null, parentOfCommands && !dropdownSubmenu ? BootstrapClass.DROPDOWN_TOGGLE : null, markup.contains(Markup.HIDE_TOGGLE_ICON) ? TobagoClass.HIDE_TOGGLE_ICON : null, label.getLabel() == null && image == null && labelFacet == null ? BootstrapClass.DROPDOWN_TOGGLE_SPLIT : null, component.getCustomClass(), this.isInside(facesContext, HtmlElements.TOBAGO_LINKS) && !dropdownSubmenu ? BootstrapClass.NAV_LINK : null});
        boolean defaultCommand = ComponentUtils.getBooleanAttribute(component, Attributes.defaultCommand);
        if (defaultCommand) {
            AbstractUIFormBase form = ComponentUtils.findAncestor(component, AbstractUIFormBase.class);
            if (form != null) {
                writer.writeAttribute(DataAttributes.DEFAULT, form.getClientId(facesContext), false);
            } else {
                LOG.warn("No form found for {}", (Object)clientId);
            }
        }
        if (!disabled) {
            this.encodeBehavior(writer, facesContext, (ClientBehaviorHolder)component);
        }
        HtmlRendererUtils.encodeIconOrImage(writer, image);
        if (labelFacet != null) {
            this.insideBegin(facesContext, Facets.label);
            for (UIComponent child : RenderUtils.getFacetChildren(labelFacet)) {
                child.encodeAll(facesContext);
            }
            this.insideEnd(facesContext, Facets.label);
        } else if (label.getLabel() != null) {
            writer.startElement(HtmlElements.SPAN);
            HtmlRendererUtils.writeLabelWithAccessKey(writer, label);
            writer.endElement(HtmlElements.SPAN);
            this.encodeBadge(facesContext, component);
        }
        if (anchor) {
            writer.endElement(HtmlElements.A);
        } else {
            writer.endElement(HtmlElements.BUTTON);
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    @Override
    public void encodeChildrenInternal(FacesContext facesContext, T component) throws IOException {
        block7: {
            block6: {
                boolean parentOfCommands = ((AbstractUICommand)component).isParentOfCommands();
                boolean isInsideInputAfter = this.isInside(facesContext, HtmlElements.TOBAGO_IN) && this.isInside(facesContext, Facets.after);
                boolean disabled = ((AbstractUICommandBase)((Object)component)).isDisabled();
                TobagoResponseWriter writer = this.getResponseWriter(facesContext);
                if (!parentOfCommands) break block6;
                ArrayList<UIComponent> renderLater = null;
                writer.startElement(HtmlElements.DIV);
                writer.writeClassAttribute(TobagoClass.DROPDOWN__MENU, isInsideInputAfter ? BootstrapClass.DROPDOWN_MENU_END : null, disabled ? TobagoClass.DISABLED : null);
                writer.writeAttribute(Arias.LABELLEDBY, ((AbstractUICommand)component).getFieldId(facesContext), false);
                writer.writeAttribute(HtmlAttributes.NAME, component.getClientId(facesContext), false);
                for (UIComponent child : component.getChildren()) {
                    if (!child.isRendered() || child instanceof UIParameter || child instanceof AbstractUIBadge) continue;
                    if (child instanceof AbstractUIStyle) {
                        if (renderLater == null) {
                            renderLater = new ArrayList<UIComponent>();
                        }
                        renderLater.add(child);
                        continue;
                    }
                    if (child instanceof AbstractUILink || child instanceof AbstractUISelectBooleanCheckbox || child instanceof AbstractUISelectBooleanToggle || child instanceof AbstractUISelectManyCheckbox || child instanceof AbstractUISelectOneRadio || child instanceof AbstractUISeparator || UIComponent.isCompositeComponent((UIComponent)child)) {
                        this.insideBegin(facesContext, HtmlElements.COMMAND);
                        child.encodeAll(facesContext);
                        this.insideEnd(facesContext, HtmlElements.COMMAND);
                        continue;
                    }
                    writer.startElement(HtmlElements.DIV);
                    writer.writeClassAttribute(BootstrapClass.DROPDOWN_ITEM);
                    child.encodeAll(facesContext);
                    writer.endElement(HtmlElements.DIV);
                }
                writer.endElement(HtmlElements.DIV);
                if (renderLater == null) break block7;
                for (UIComponent child : renderLater) {
                    child.encodeAll(facesContext);
                }
                break block7;
            }
            for (UIComponent child : component.getChildren()) {
                if (child instanceof AbstractUIBadge) continue;
                child.encodeAll(facesContext);
            }
        }
    }

    @Override
    public void encodeEndInternal(FacesContext facesContext, T component) throws IOException {
        this.encodeEndOuter(facesContext, component);
    }

    protected void encodeBeginOuter(FacesContext facesContext, T command) throws IOException {
        String clientId = command.getClientId(facesContext);
        boolean parentOfCommands = ((AbstractUICommand)command).isParentOfCommands();
        boolean dropdownSubmenu = this.isInside(facesContext, HtmlElements.COMMAND);
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (parentOfCommands) {
            writer.startElement(HtmlElements.TOBAGO_DROPDOWN);
            writer.writeIdAttribute(clientId);
            writer.writeClassAttribute((CssItem)((Object)(dropdownSubmenu ? TobagoClass.DROPDOWN__SUBMENU : BootstrapClass.DROPDOWN)), this.getOuterCssItems(facesContext, command), new CssItem[0]);
        }
    }

    protected void encodeEndOuter(FacesContext facesContext, T command) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        if (((AbstractUICommand)command).isParentOfCommands()) {
            writer.endElement(HtmlElements.TOBAGO_DROPDOWN);
        }
    }

    protected CssItem[] getOuterCssItems(FacesContext facesContext, T command) {
        return null;
    }

    abstract CssItem getRendererCssClass();

    protected CssItem[] getCssItems(FacesContext facesContext, T command) {
        return null;
    }

    protected void encodeBadge(FacesContext facesContext, T command) throws IOException {
    }
}

