/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.renderkit;

import jakarta.el.ValueExpression;
import jakarta.faces.component.EditableValueHolder;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.ValueHolder;
import jakarta.faces.component.behavior.ClientBehavior;
import jakarta.faces.component.behavior.ClientBehaviorBase;
import jakarta.faces.component.behavior.ClientBehaviorContext;
import jakarta.faces.component.behavior.ClientBehaviorHolder;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.convert.Converter;
import jakarta.faces.convert.ConverterException;
import jakarta.faces.model.SelectItem;
import jakarta.faces.model.SelectItemGroup;
import jakarta.faces.render.ClientBehaviorRenderer;
import jakarta.faces.render.Renderer;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.myfaces.tobago.component.ClientBehaviors;
import org.apache.myfaces.tobago.component.Facets;
import org.apache.myfaces.tobago.component.RendererTypes;
import org.apache.myfaces.tobago.component.Tags;
import org.apache.myfaces.tobago.component.Visual;
import org.apache.myfaces.tobago.context.Markup;
import org.apache.myfaces.tobago.context.TobagoContext;
import org.apache.myfaces.tobago.internal.behavior.EventBehavior;
import org.apache.myfaces.tobago.internal.component.AbstractUICommand;
import org.apache.myfaces.tobago.internal.component.AbstractUIEvent;
import org.apache.myfaces.tobago.internal.component.AbstractUIReload;
import org.apache.myfaces.tobago.internal.component.AbstractUIStyle;
import org.apache.myfaces.tobago.internal.renderkit.Collapse;
import org.apache.myfaces.tobago.internal.renderkit.Command;
import org.apache.myfaces.tobago.internal.renderkit.CommandMap;
import org.apache.myfaces.tobago.internal.renderkit.renderer.TobagoClientBehaviorRenderer;
import org.apache.myfaces.tobago.internal.util.ArrayUtils;
import org.apache.myfaces.tobago.internal.util.HtmlRendererUtils;
import org.apache.myfaces.tobago.internal.util.RenderUtils;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.apache.myfaces.tobago.internal.util.StyleRenderUtils;
import org.apache.myfaces.tobago.internal.webapp.TobagoResponseWriterWrapper;
import org.apache.myfaces.tobago.renderkit.css.TobagoClass;
import org.apache.myfaces.tobago.renderkit.html.CustomAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlAttributes;
import org.apache.myfaces.tobago.renderkit.html.HtmlElements;
import org.apache.myfaces.tobago.renderkit.html.MarkupLanguageAttributes;
import org.apache.myfaces.tobago.util.ComponentUtils;
import org.apache.myfaces.tobago.webapp.TobagoResponseWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RendererBase<T extends UIComponent>
extends Renderer {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String FOCUS_KEY = HtmlRendererUtils.class.getName() + ".FocusId";

    public final void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        this.encodeBeginInternal(context, component);
    }

    public void encodeBeginInternal(FacesContext context, T component) throws IOException {
        super.encodeBegin(context, component);
    }

    public final void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.encodeChildrenInternal(context, component);
    }

    public void encodeChildrenInternal(FacesContext context, T component) throws IOException {
        super.encodeChildren(context, component);
    }

    public final void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        this.encodeEndInternal(context, component);
    }

    public void encodeEndInternal(FacesContext context, T component) throws IOException {
        super.encodeEnd(context, component);
    }

    public final void decode(FacesContext context, UIComponent component) {
        this.decodeInternal(context, component);
    }

    public void decodeInternal(FacesContext context, T component) {
        super.decode(context, component);
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        return this.getConvertedValueInternal(facesContext, component, submittedValue);
    }

    public Object getConvertedValueInternal(FacesContext context, T component, Object submittedValue) throws ConverterException {
        if (!(submittedValue instanceof String)) {
            return submittedValue;
        }
        Converter converter = this.getConverter(context, component, submittedValue);
        if (converter != null) {
            return converter.getAsObject(context, component, (String)submittedValue);
        }
        return submittedValue;
    }

    protected String getCurrentValue(FacesContext facesContext, T component) {
        if (component instanceof ValueHolder) {
            EditableValueHolder editableValueHolder;
            Object submittedValue;
            ValueHolder valueHolder = (ValueHolder)component;
            if (valueHolder instanceof EditableValueHolder && ((submittedValue = (editableValueHolder = (EditableValueHolder)component).getSubmittedValue()) != null || !editableValueHolder.isValid())) {
                return (String)submittedValue;
            }
            String currentValue = null;
            Object result = ((ValueHolder)component).getValue();
            if (result != null) {
                currentValue = this.getFormattedValue(facesContext, component, result);
            }
            return currentValue;
        }
        return null;
    }

    public static void renderFocus(String clientId, boolean focus, boolean error, FacesContext facesContext, TobagoResponseWriter writer) throws IOException {
        Map requestMap = facesContext.getExternalContext().getRequestMap();
        if (!requestMap.containsKey(FOCUS_KEY) && (clientId.equals(TobagoContext.getInstance(facesContext).getFocusId()) || focus || error)) {
            requestMap.put(FOCUS_KEY, Boolean.TRUE);
            writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.AUTOFOCUS, true);
        }
    }

    protected TobagoResponseWriter getResponseWriter(FacesContext facesContext) {
        ResponseWriter writer = facesContext.getResponseWriter();
        if (writer instanceof TobagoResponseWriter) {
            return (TobagoResponseWriter)writer;
        }
        return new TobagoResponseWriterWrapper(writer);
    }

    protected void insideBegin(FacesContext facesContext, HtmlElements inside) {
        facesContext.getAttributes().put(inside, Boolean.TRUE);
    }

    protected void insideEnd(FacesContext facesContext, HtmlElements inside) {
        facesContext.getAttributes().remove((Object)inside);
    }

    protected boolean isInside(FacesContext facesContext, HtmlElements inside) {
        return facesContext.getAttributes().get((Object)inside) != null;
    }

    protected void insideBegin(FacesContext facesContext, Facets inside) {
        facesContext.getAttributes().put(inside, Boolean.TRUE);
    }

    protected void insideEnd(FacesContext facesContext, Facets inside) {
        facesContext.getAttributes().remove((Object)inside);
    }

    protected boolean isInside(FacesContext facesContext, Facets inside) {
        return facesContext.getAttributes().get((Object)inside) != null;
    }

    public void encodeReload(FacesContext facesContext, AbstractUIReload reload) throws IOException {
        TobagoResponseWriter writer = this.getResponseWriter(facesContext);
        writer.write("{\"reload\":{\"frequency\":" + reload.getFrequency() + "}}");
    }

    protected void encodeBehavior(TobagoResponseWriter writer, FacesContext facesContext, ClientBehaviorHolder holder) throws IOException {
        if (holder != null) {
            CommandMap behaviorCommands = this.getBehaviorCommands(facesContext, holder);
            this.encodeBehavior(writer, behaviorCommands);
        }
    }

    protected void encodeBehavior(TobagoResponseWriter writer, CommandMap behaviorCommands) throws IOException {
        if (behaviorCommands != null) {
            Map<ClientBehaviors, Command> other;
            Command click = behaviorCommands.getClick();
            if (click != null) {
                this.encodeBehavior(writer, ClientBehaviors.click, click);
            }
            if ((other = behaviorCommands.getOther()) != null) {
                for (Map.Entry<ClientBehaviors, Command> entry : other.entrySet()) {
                    this.encodeBehavior(writer, entry.getKey(), entry.getValue());
                }
            }
        }
    }

    private void encodeBehavior(TobagoResponseWriter writer, ClientBehaviors behaviors, Command command) throws IOException {
        writer.startElement(HtmlElements.TOBAGO_BEHAVIOR);
        writer.writeAttribute(CustomAttributes.EVENT, behaviors.getJsEvent(), false);
        writer.writeAttribute(CustomAttributes.CLIENT_ID, command.getClientId(), false);
        if (StringUtils.notEquals(command.getClientId(), command.getFieldId())) {
            writer.writeAttribute(CustomAttributes.FIELD_ID, command.getFieldId(), false);
        }
        writer.writeAttribute(CustomAttributes.EXECUTE, command.getExecute(), false);
        writer.writeAttribute(CustomAttributes.RENDER, command.getRender(), false);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.OMIT, command.getOmit());
        writer.writeAttribute(CustomAttributes.CONFIRMATION, command.getConfirmation(), true);
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.DECOUPLED, command.getTransition() != null && command.getTransition() == false);
        Collapse collapse = command.getCollapse();
        if (collapse != null) {
            writer.writeAttribute(CustomAttributes.COLLAPSE_OPERATION, collapse.getOperation().name(), false);
            writer.writeAttribute(CustomAttributes.COLLAPSE_TARGET, collapse.getFor(), false);
        }
        writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.DELAY, command.getDelay());
        writer.writeAttribute(HtmlAttributes.TARGET, command.getTarget(), true);
        Boolean resetValues = command.getResetValues();
        if (resetValues != null && resetValues.booleanValue()) {
            writer.writeAttribute((MarkupLanguageAttributes)CustomAttributes.RESET_VALUES, resetValues);
        }
        writer.endElement(HtmlElements.TOBAGO_BEHAVIOR);
    }

    protected CommandMap getBehaviorCommands(FacesContext facesContext, ClientBehaviorHolder clientBehaviorHolder) {
        CommandMap commandMap = null;
        for (Map.Entry entry : clientBehaviorHolder.getClientBehaviors().entrySet()) {
            String eventName = (String)entry.getKey();
            ClientBehaviorContext clientBehaviorContext = RendererBase.getClientBehaviorContext(facesContext, clientBehaviorHolder, eventName);
            for (ClientBehavior clientBehavior : (List)entry.getValue()) {
                EventBehavior eventBehavior;
                AbstractUIEvent abstractUIEvent;
                if (clientBehavior instanceof EventBehavior && (abstractUIEvent = RenderUtils.getAbstractUIEvent((UIComponent)clientBehaviorHolder, eventBehavior = (EventBehavior)clientBehavior)) != null && abstractUIEvent.isRendered() && !abstractUIEvent.isDisabled()) {
                    for (List children : abstractUIEvent.getClientBehaviors().values()) {
                        for (ClientBehavior child : children) {
                            CommandMap childMap = RendererBase.getCommandMap(facesContext, clientBehaviorContext, child);
                            commandMap = CommandMap.merge(commandMap, childMap);
                        }
                    }
                }
                CommandMap map = RendererBase.getCommandMap(facesContext, clientBehaviorContext, clientBehavior);
                commandMap = CommandMap.merge(commandMap, map);
            }
        }
        if ((commandMap == null || commandMap.isEmpty()) && clientBehaviorHolder instanceof AbstractUICommand) {
            if (commandMap == null) {
                commandMap = new CommandMap();
            }
            AbstractUICommand holder = (AbstractUICommand)clientBehaviorHolder;
            commandMap.addCommand(ClientBehaviors.click, new Command(holder.getClientId(facesContext), holder.getFieldId(facesContext), holder.isTransition(), holder.getTarget(), null, null, ComponentUtils.getConfirmation((UIComponent)holder), null, TobagoClientBehaviorRenderer.createCollapsible(facesContext, (UIComponent)holder), holder.isOmit()));
        }
        return commandMap;
    }

    private static ClientBehaviorContext getClientBehaviorContext(FacesContext facesContext, ClientBehaviorHolder clientBehaviorHolder, String eventName) {
        UIComponent component = (UIComponent)clientBehaviorHolder;
        return ClientBehaviorContext.createClientBehaviorContext((FacesContext)facesContext, (UIComponent)component, (String)eventName, (String)component.getClientId(facesContext), null);
    }

    private static CommandMap getCommandMap(FacesContext facesContext, ClientBehaviorContext clientBehaviorContext, ClientBehavior clientBehavior) {
        if (clientBehavior instanceof ClientBehaviorBase) {
            ClientBehaviorRenderer renderer;
            String dummy;
            String type = ((ClientBehaviorBase)clientBehavior).getRendererType();
            if (type.equals("jakarta.faces.behavior.Ajax")) {
                type = "org.apache.myfaces.tobago.behavior.Ajax";
            }
            if ((dummy = (renderer = facesContext.getRenderKit().getClientBehaviorRenderer(type)).getScript(clientBehaviorContext, clientBehavior)) != null) {
                return CommandMap.restoreCommandMap(facesContext);
            }
        } else {
            LOG.warn("Ignoring: '{}'", (Object)clientBehavior);
        }
        return null;
    }

    protected void decodeClientBehaviors(FacesContext facesContext, T component) {
        List clientBehaviorList;
        Map paramMap;
        String behaviorEventName;
        ClientBehaviorHolder clientBehaviorHolder;
        Map clientBehaviors;
        if (component instanceof ClientBehaviorHolder && (clientBehaviors = (clientBehaviorHolder = (ClientBehaviorHolder)component).getClientBehaviors()) != null && !clientBehaviors.isEmpty() && (behaviorEventName = (String)(paramMap = facesContext.getExternalContext().getRequestParameterMap()).get("jakarta.faces.behavior.event")) != null && (clientBehaviorList = (List)clientBehaviors.get(behaviorEventName)) != null && !clientBehaviorList.isEmpty()) {
            String clientId = (String)paramMap.get("jakarta.faces.source");
            if (component.getClientId(facesContext).equals(clientId)) {
                for (ClientBehavior clientBehavior : clientBehaviorList) {
                    clientBehavior.decode(facesContext, component);
                }
            }
        }
    }

    protected void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        this.renderSelectItems(component, optionClass, items, values, submittedValues, null, writer, facesContext);
    }

    protected void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object value, String submittedValue, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        String[] stringArray;
        Object[] objectArray;
        if (value != null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = value;
        } else {
            objectArray = null;
        }
        if (submittedValue != null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = submittedValue;
        } else {
            stringArray = null;
        }
        this.renderSelectItems(component, optionClass, items, objectArray, stringArray, null, writer, facesContext);
    }

    protected void renderSelectItems(UIInput component, TobagoClass optionClass, Iterable<SelectItem> items, Object[] values, String[] submittedValues, Boolean onlySelected, TobagoResponseWriter writer, FacesContext facesContext) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("component id = '{}'", (Object)component.getId());
            LOG.debug("values = '{}'", (Object)Arrays.toString(values));
            LOG.debug("submittedValues = '{}'", (Object)Arrays.toString(submittedValues));
        }
        for (SelectItem item : items) {
            Markup markup;
            String image;
            if (item instanceof SelectItemGroup) {
                writer.startElement(HtmlElements.OPTGROUP);
                writer.writeAttribute(HtmlAttributes.LABEL, item.getLabel(), true);
                if (item.isDisabled()) {
                    writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
                }
                SelectItem[] selectItems = ((SelectItemGroup)item).getSelectItems();
                this.renderSelectItems(component, optionClass, Arrays.asList(selectItems), values, submittedValues, onlySelected, writer, facesContext);
                writer.endElement(HtmlElements.OPTGROUP);
                continue;
            }
            Object itemValue = item.getValue();
            if (itemValue instanceof String && values != null && values.length > 0 && !(values[0] instanceof String)) {
                itemValue = ComponentUtils.getConvertedValue(facesContext, (UIComponent)component, (String)itemValue);
            }
            String formattedValue = this.getFormattedValue(facesContext, component, itemValue);
            boolean contains = submittedValues == null ? ArrayUtils.contains(values, itemValue) : ArrayUtils.contains(submittedValues, formattedValue);
            if (item.isNoSelectionOption() && component.isRequired() && values != null && values.length > 0 && !contains || onlySelected != null && (onlySelected != false ? !contains : contains)) continue;
            writer.startElement(HtmlElements.OPTION);
            writer.writeAttribute(HtmlAttributes.VALUE, formattedValue, true);
            if (item instanceof org.apache.myfaces.tobago.model.SelectItem && (image = ((org.apache.myfaces.tobago.model.SelectItem)item).getImage()) != null) {
                AbstractUIStyle style = (AbstractUIStyle)facesContext.getApplication().createComponent(facesContext, Tags.style.componentType(), RendererTypes.Style.name());
                style.setTransient(true);
                style.setBackgroundImage(image);
                style.setSelector(StyleRenderUtils.encodeIdSelector(component.getClientId(facesContext)) + " option[value=" + formattedValue + "]");
                component.getChildren().add(style);
            }
            Markup markup2 = markup = item instanceof Visual ? ((Visual)item).getMarkup() : Markup.NULL;
            if (onlySelected == null && contains) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.SELECTED, true);
                markup = Markup.SELECTED.add(markup);
            }
            if (item.isDisabled()) {
                writer.writeAttribute((MarkupLanguageAttributes)HtmlAttributes.DISABLED, true);
                markup = Markup.DISABLED.add(markup);
            }
            writer.writeClassAttribute(optionClass);
            String label = item.getLabel();
            if (label != null) {
                writer.writeText(label);
            }
            writer.endElement(HtmlElements.OPTION);
        }
    }

    protected String getFormattedValue(FacesContext facesContext, T component, Object currentValue) throws ConverterException {
        if (currentValue == null) {
            return "";
        }
        Converter converter = this.getConverter(facesContext, component, currentValue);
        if (converter != null) {
            return converter.getAsString(facesContext, component, currentValue);
        }
        return currentValue.toString();
    }

    protected Converter getConverter(FacesContext facesContext, T component, Object value) {
        ValueExpression valueExpression;
        Converter converter = null;
        if (component instanceof ValueHolder) {
            converter = ((ValueHolder)component).getConverter();
        }
        if (converter == null && (valueExpression = component.getValueExpression("value")) != null) {
            Class<?> converterType = null;
            try {
                converterType = valueExpression.getType(facesContext.getELContext());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (converterType == null && value != null) {
                converterType = value.getClass();
            }
            if (converterType != null && converterType != Object.class) {
                converter = facesContext.getApplication().createConverter(converterType);
            }
        }
        return converter;
    }
}

