/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.tobago.layout;

import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.Locale;
import org.apache.myfaces.tobago.internal.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Measure
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final Measure ZERO = Measure.valueOf(0);
    public static final Measure AUTO = Measure.valueOf("auto");
    public static final Measure FRACTION1 = Measure.valueOf("1fr");
    private final float value;
    private final Unit unit;

    private Measure() {
        this.value = 0.0f;
        this.unit = Unit.AUTO;
    }

    public Measure(int i, Unit unit) {
        this.value = i;
        this.unit = unit;
    }

    public Measure(double d, Unit unit) {
        this.value = (float)d;
        this.unit = unit;
    }

    public Measure(String string, Unit unit) {
        this.value = Float.parseFloat(string);
        this.unit = unit;
    }

    public static Measure valueOf(Measure measure) {
        if (measure == null) {
            return ZERO;
        }
        return measure;
    }

    public static Measure valueOf(int value) {
        return new Measure(value, Unit.PX);
    }

    public static Measure valueOf(Integer i) {
        if (i == null) {
            return ZERO;
        }
        return Measure.valueOf((int)i);
    }

    public static Measure valueOf(Number n) {
        if (n == null) {
            return ZERO;
        }
        return Measure.valueOf(n.doubleValue());
    }

    public static Measure valueOf(String s) {
        return Measure.valueOf(s, Unit.PX);
    }

    public static Measure valueOf(String s, Unit defaultUnit) {
        try {
            if (StringUtils.isEmpty(s)) {
                return null;
            }
            int length = s.length();
            if (s.endsWith("%")) {
                return new Measure(s.substring(0, length - 1), Unit.PERCENT);
            }
            if (s.endsWith("*")) {
                if (s.length() == 1) {
                    return new Measure(1, Unit.FR);
                }
                return new Measure(s.substring(0, length - 1), Unit.FR);
            }
            if (s.equals("auto")) {
                return new Measure();
            }
            for (int i = 4; i >= 2; --i) {
                int pos = length - i;
                if (length < i || !Character.isLetter(s.charAt(pos))) continue;
                return new Measure(s.substring(0, pos), Unit.valueOf(s.substring(pos).toUpperCase(Locale.ROOT)));
            }
            return new Measure(s, defaultUnit);
        }
        catch (RuntimeException e) {
            LOG.warn("Can't parse to any measure: '" + s + "'");
            return null;
        }
    }

    public static Measure valueOf(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof Measure) {
            return Measure.valueOf((Measure)object);
        }
        if (object instanceof Number) {
            return Measure.valueOf((Number)object);
        }
        if (object instanceof String) {
            return Measure.valueOf((String)object);
        }
        return Measure.valueOf(object.toString());
    }

    public String serialize() {
        int length;
        StringBuilder builder = new StringBuilder();
        if (this.unit != Unit.AUTO) {
            builder.append(this.value);
        }
        if ((length = builder.length()) >= 3 && builder.charAt(length - 1) == '0' && builder.charAt(length - 2) == '.') {
            builder.deleteCharAt(length - 1);
            builder.deleteCharAt(length - 2);
        }
        builder.append(this.unit.getValue());
        return builder.toString();
    }

    public float getValue() {
        return this.value;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public String toString() {
        return this.serialize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Measure measure = (Measure)o;
        if (Float.compare(measure.value, this.value) != 0) {
            return false;
        }
        return this.unit == measure.unit;
    }

    public int hashCode() {
        int result = this.value != 0.0f ? Float.floatToIntBits(this.value) : 0;
        result = 31 * result + this.unit.hashCode();
        return result;
    }

    public static enum Unit {
        EM,
        PX,
        EX,
        PT,
        CM,
        MM,
        IN,
        PC,
        CH,
        REM,
        VW,
        VH,
        VMIN,
        VMAX,
        PERCENT,
        FR,
        SEG,
        AUTO;

        private final String value = this.name().equals("PERCENT") ? "%" : this.name().toLowerCase(Locale.ROOT);

        String getValue() {
            return this.value;
        }
    }
}

