/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.shared_tomahawk.renderkit.html;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.component.UIOutput;
import javax.faces.component.html.HtmlInputText;
import javax.faces.component.html.HtmlOutputText;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.myfaces.shared_tomahawk.component.EscapeCapable;
import org.apache.myfaces.shared_tomahawk.renderkit.RendererUtils;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HTML;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRenderer;
import org.apache.myfaces.shared_tomahawk.renderkit.html.HtmlRendererUtils;

public class HtmlTextRendererBase
extends HtmlRenderer {
    private static final Log log = LogFactory.getLog(HtmlTextRendererBase.class);
    private static final String AUTOCOMPLETE_VALUE_OFF = "off";

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UIInput) {
            this.renderInput(facesContext, component);
        } else if (component instanceof UIOutput) {
            HtmlTextRendererBase.renderOutput(facesContext, component);
        } else {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    protected static void renderOutput(FacesContext facesContext, UIComponent component) throws IOException {
        String text = RendererUtils.getStringValue(facesContext, component);
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderOutput '" + text + "'"));
        }
        boolean escape = component instanceof HtmlOutputText || component instanceof EscapeCapable ? ((HtmlOutputText)component).isEscape() : RendererUtils.getBooleanAttribute(component, "escape", true);
        HtmlTextRendererBase.renderOutputText(facesContext, component, text, escape);
    }

    public static void renderOutputText(FacesContext facesContext, UIComponent component, String text, boolean escape) throws IOException {
        if (text != null) {
            ResponseWriter writer = facesContext.getResponseWriter();
            boolean span = false;
            if (component.getId() != null && !component.getId().startsWith("j_id")) {
                span = true;
                writer.startElement("span", component);
                HtmlRendererUtils.writeIdIfNecessary(writer, component, facesContext);
                HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            } else {
                span = HtmlRendererUtils.renderHTMLAttributesWithOptionalStartElement(writer, component, "span", HTML.COMMON_PASSTROUGH_ATTRIBUTES);
            }
            if (escape) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("renderOutputText writing '" + text + "'"));
                }
                writer.writeText((Object)text, "value");
            } else {
                writer.write(text);
            }
            if (span) {
                writer.endElement("span");
            }
        }
    }

    protected void renderInput(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = component.getClientId(facesContext);
        String value = RendererUtils.getStringValue(facesContext, component);
        if (log.isDebugEnabled()) {
            log.debug((Object)("renderInput '" + value + "'"));
        }
        writer.startElement("input", component);
        writer.writeAttribute("id", (Object)clientId, null);
        writer.writeAttribute("name", (Object)clientId, null);
        writer.writeAttribute("type", (Object)"text", null);
        if (value != null) {
            writer.writeAttribute("value", (Object)value, "value");
        }
        HtmlRendererUtils.renderHTMLAttributes(writer, component, HTML.INPUT_PASSTHROUGH_ATTRIBUTES_WITHOUT_DISABLED);
        if (this.isDisabled(facesContext, component)) {
            writer.writeAttribute("disabled", (Object)Boolean.TRUE, null);
        }
        if (this.isAutocompleteOff(facesContext, component)) {
            writer.writeAttribute("autocomplete", (Object)AUTOCOMPLETE_VALUE_OFF, "autocomplete");
        }
        writer.endElement("input");
    }

    protected boolean isDisabled(FacesContext facesContext, UIComponent component) {
        if (component instanceof HtmlInputText) {
            return ((HtmlInputText)component).isDisabled();
        }
        return RendererUtils.getBooleanAttribute(component, "disabled", false);
    }

    protected boolean isAutocompleteOff(FacesContext facesContext, UIComponent component) {
        String autocomplete;
        if (component instanceof HtmlInputText && (autocomplete = ((HtmlInputText)component).getAutocomplete()) != null) {
            return autocomplete.equals(AUTOCOMPLETE_VALUE_OFF);
        }
        return false;
    }

    public void decode(FacesContext facesContext, UIComponent component) {
        RendererUtils.checkParamValidity(facesContext, component, null);
        if (component instanceof UIInput) {
            HtmlRendererUtils.decodeUIInput(facesContext, component);
        } else if (!(component instanceof UIOutput)) {
            throw new IllegalArgumentException("Unsupported component class " + component.getClass().getName());
        }
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        RendererUtils.checkParamValidity(facesContext, component, UIOutput.class);
        return RendererUtils.getConvertedUIOutputValue(facesContext, (UIOutput)component, submittedValue);
    }
}

