/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidadinternal.style.xml.parse;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.myfaces.trinidad.context.AccessibilityProfile;
import org.apache.myfaces.trinidadinternal.agent.TrinidadAgent;
import org.apache.myfaces.trinidadinternal.skin.AgentAtRuleMatcher;
import org.apache.myfaces.trinidadinternal.style.util.NameUtils;
import org.apache.myfaces.trinidadinternal.style.xml.parse.IconNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.SkinPropertyNode;
import org.apache.myfaces.trinidadinternal.style.xml.parse.StyleNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleSheetNode {
    private final List<StyleNode> _styles;
    private final List<IconNode> _icons;
    private List<SkinPropertyNode> _skinProperties;
    private final Set<Locale> _locales;
    private final int _direction;
    private final AgentAtRuleMatcher _agentMatcher;
    private final Set<Integer> _platforms;
    private final int _mode;
    private final Set<String> _accProps;
    private final int _id;
    private static final int _NO_MATCH = 0;
    private static final int _ACC_EXACT_MATCH = 0x2000000;
    private static final int _ACC_UNKNOWN_MATCH = 0x1000000;
    private static final int _MODE_EXACT_MATCH = 0x200000;
    private static final int _MODE_UNKNOWN_MATCH = 0x100000;
    private static final int _LOCALE_EXACT_MATCH = 262144;
    private static final int _LOCALE_PARTIAL_MATCH = 131072;
    private static final int _LOCALE_UNKNOWN_MATCH = 65536;
    private static final int _DIRECTION_EXACT_MATCH = 8192;
    private static final int _DIRECTION_UNKNOWN_MATCH = 4096;
    private static final int _BROWSER_EXACT_MATCH = 512;
    private static final int _BROWSER_UNKNOWN_MATCH = 256;
    private static final int _VERSION_EXACT_MATCH = 32;
    private static final int _VERSION_UNKNOWN_MATCH = 16;
    private static final int _OS_EXACT_MATCH = 4;
    private static final int _OS_PARTIAL_MATCH = 2;
    private static final int _OS_UNKNOWN_MATCH = 1;
    private static final String _EMPTY_STRING = "\"\"";
    private static final int[] _UNIX_PLATFORMS = new int[]{3, 4};
    static final int __OS_UNIX = Integer.MAX_VALUE;

    public StyleSheetNode(StyleNode[] styles, Collection<IconNode> icons, Collection<SkinPropertyNode> skinProperties, Set<Locale> locales, int direction, AgentAtRuleMatcher agentMatcher, int[] platforms, int mode, Set<String> accessibilityProperties) {
        this._styles = styles != null ? Collections.unmodifiableList(Arrays.asList(styles)) : Collections.emptyList();
        this._icons = icons != null ? Collections.unmodifiableList(new ArrayList<IconNode>(icons)) : Collections.emptyList();
        this._skinProperties = skinProperties != null ? Collections.unmodifiableList(new ArrayList<SkinPropertyNode>(skinProperties)) : Collections.emptyList();
        this._locales = locales != null ? Collections.unmodifiableSet(locales) : Collections.emptySet();
        this._agentMatcher = agentMatcher;
        if (platforms != null) {
            Set<Integer> platformsSet = StyleSheetNode._copyIntArrayToSet(platforms);
            this._platforms = Collections.unmodifiableSet(platformsSet);
        } else {
            this._platforms = Collections.emptySet();
        }
        if (accessibilityProperties != null) {
            Set<String> accPropsSet = StyleSheetNode._copyAccessibilityProperties(accessibilityProperties);
            this._accProps = Collections.unmodifiableSet(accPropsSet);
        } else {
            this._accProps = Collections.emptySet();
        }
        this._mode = mode;
        this._direction = direction;
        this._id = this._computeStyleSheetId();
    }

    public Collection<StyleNode> getStyles() {
        return this._styles;
    }

    public Collection<IconNode> getIcons() {
        return this._icons;
    }

    public Collection<SkinPropertyNode> getSkinProperties() {
        return this._skinProperties;
    }

    public int getReadingDirection() {
        return this._direction;
    }

    public int getMode() {
        return this._mode;
    }

    public Collection<Locale> getLocales() {
        return this._locales;
    }

    public AgentAtRuleMatcher getAgentMatcher() {
        return this._agentMatcher;
    }

    public Collection<Integer> getPlatforms() {
        return this._platforms;
    }

    public Collection<String> getAccessibilityProperties() {
        return this._accProps;
    }

    public int compareVariants(Locale locale, int direction, TrinidadAgent agent, int mode, AccessibilityProfile accessibilityProfile) {
        int localeMatch = this._compareLocale(locale);
        if (localeMatch == 0) {
            return 0;
        }
        int directionMatch = this._compareDirection(direction);
        if (directionMatch == 0) {
            return 0;
        }
        int browserAndVersionMatch = this._compareBrowserAndVersion(agent);
        if (browserAndVersionMatch == 0) {
            return 0;
        }
        int modeMatch = this._compareMode(mode);
        if (modeMatch == 0) {
            return 0;
        }
        int osMatch = this._compareOS(agent.getAgentOS());
        if (osMatch == 0) {
            return 0;
        }
        int accessibilityMatch = this._compareAccessibility(accessibilityProfile);
        if (accessibilityMatch == 0) {
            return 0;
        }
        return localeMatch | browserAndVersionMatch | osMatch | accessibilityMatch;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        return this.getClass().getName() + "[" + "locales=" + (this._locales != null ? this._locales.toString() : "") + ", " + "direction=" + this._getDirectionString() + ", " + "agentVersions=" + (this._agentMatcher != null ? this._agentMatcher.toString() : "") + ", " + "platforms=" + (this._platforms != null ? this._platforms.toString() : "") + ", " + "styles=" + (this._styles != null ? this._styles.toString() : "") + ", " + "icons=" + (this._icons != null ? this._icons.toString() : "") + ", " + "accessibility-profile=" + (this._accProps != null ? this._accProps.toString() : "") + "]";
    }

    public int getStyleSheetId() {
        return this._id;
    }

    private int _computeStyleSheetId() {
        int hash = 17;
        hash = 37 * hash + this._mode;
        hash = 37 * hash + this._direction;
        hash = 37 * hash + this._locales.hashCode();
        hash = 37 * hash + (this._agentMatcher != null ? this._agentMatcher.hashCode() : 0);
        hash = 37 * hash + this._platforms.hashCode();
        hash = 37 * hash + this._styles.hashCode();
        hash = 37 * hash + this._accProps.hashCode();
        return hash;
    }

    private int _compareLocale(Locale locale) {
        if (this._locales.isEmpty()) {
            return 65536;
        }
        if (locale == null) {
            return 0;
        }
        int match = 0;
        if (this._locales.contains(locale)) {
            return 262144;
        }
        for (Locale tmpLocale : this._locales) {
            if (!tmpLocale.getLanguage().equals(locale.getLanguage())) continue;
            if (tmpLocale.getCountry().equals(locale.getCountry())) {
                match = 262144;
                break;
            }
            match = 131072;
        }
        return match;
    }

    private int _compareDirection(int direction) {
        if (this._direction == 0) {
            return 4096;
        }
        if (direction == this._direction) {
            return 8192;
        }
        return 0;
    }

    private int _compareMode(int mode) {
        if (this._mode == 0) {
            return 0x100000;
        }
        if (mode == this._mode) {
            return 0x200000;
        }
        return 0;
    }

    private int _compareBrowserAndVersion(TrinidadAgent agent) {
        if (this._agentMatcher == null) {
            return 256;
        }
        TrinidadAgent.Application application = agent.getAgentApplication();
        if (application == TrinidadAgent.Application.UNKNOWN) {
            return 0;
        }
        Set<AgentAtRuleMatcher.Match> matches = this._agentMatcher.match(agent);
        int matchResult = 0;
        if (matches.contains((Object)AgentAtRuleMatcher.Match.APPLICATION)) {
            matchResult |= 0x200;
            int versionMatch = matches.contains((Object)AgentAtRuleMatcher.Match.VERSION) ? 32 : 16;
            matchResult |= versionMatch;
        }
        return matchResult;
    }

    private int _compareOS(int os) {
        if (this._platforms.isEmpty()) {
            return 1;
        }
        if (os == 0) {
            return 0;
        }
        if (this._platforms.contains(os)) {
            return 4;
        }
        if (StyleSheetNode._isUnixPlatform(os) && this._platforms.contains(Integer.MAX_VALUE)) {
            return 2;
        }
        return 0;
    }

    private int _compareAccessibility(AccessibilityProfile accProfile) {
        if (this._accProps.isEmpty()) {
            return 0x1000000;
        }
        for (String accProp : this._accProps) {
            if (!(this._isCompoundAccessibilityProperty(accProp) ? this._matchCompoundAccessibilityProperty(accProp, accProfile) : this._matchAccessibilityProperty(accProp, accProfile))) continue;
            return 0x2000000;
        }
        return 0;
    }

    private boolean _isCompoundAccessibilityProperty(String propertyName) {
        return propertyName.contains("&");
    }

    private boolean _matchCompoundAccessibilityProperty(String propertyName, AccessibilityProfile accProfile) {
        StringTokenizer tokens = new StringTokenizer(propertyName, "&");
        while (tokens.hasMoreTokens()) {
            if (this._matchAccessibilityProperty(tokens.nextToken(), accProfile)) continue;
            return false;
        }
        return true;
    }

    private boolean _matchAccessibilityProperty(String propertyName, AccessibilityProfile accProfile) {
        if ("high-contrast".equals(propertyName)) {
            return accProfile.isHighContrast();
        }
        if ("large-fonts".equals(propertyName)) {
            return accProfile.isLargeFonts();
        }
        assert (false);
        return false;
    }

    private String _getDirectionString() {
        if (this._direction == 0) {
            return _EMPTY_STRING;
        }
        return NameUtils.getDirectionName(this._direction);
    }

    private static boolean _containsInt(int n, int[] array) {
        if (array == null) {
            return false;
        }
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != n) continue;
            return true;
        }
        return false;
    }

    private static Set<Integer> _copyIntArrayToSet(int[] array) {
        int arrayCount = array != null ? array.length : 0;
        HashSet<Integer> set = new HashSet<Integer>(arrayCount);
        for (int i = 0; i < arrayCount; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private static Set<Locale> _copyLocaleArrayToSet(Locale[] array) {
        int arrayCount = array != null ? array.length : 0;
        HashSet<Locale> set = new HashSet<Locale>(arrayCount);
        for (int i = 0; i < arrayCount; ++i) {
            set.add(array[i]);
        }
        return set;
    }

    private static Set<String> _copyAccessibilityProperties(Set<String> accProps) {
        return new HashSet<String>(accProps);
    }

    private static boolean _isUnixPlatform(int os) {
        return StyleSheetNode._containsInt(os, _UNIX_PLATFORMS);
    }
}

