/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.text.MessageFormat;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.openide.modules.Dependency;
import org.openide.util.NbBundle;
import org.openide.util.Union2;

final class IllegalModuleException
extends IllegalArgumentException {
    private final Reason reason;
    private final Map<Module, Set<Union2<Dependency, InvalidException>>> bogus;

    IllegalModuleException(Reason reason, Module bogus) {
        this(reason, Collections.singletonMap(bogus, Collections.emptySet()));
    }

    IllegalModuleException(Reason reason, Map<Module, Set<Union2<Dependency, InvalidException>>> bogus) {
        this.reason = reason;
        this.bogus = bogus;
    }

    @Override
    public String getMessage() {
        return MessageFormat.format(this.reason.msg, this.bogus);
    }

    @Override
    public String getLocalizedMessage() {
        if (this.reason.l10n != null) {
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Module, Set<Union2<Dependency, InvalidException>>> entry : this.bogus.entrySet()) {
                Module m = entry.getKey();
                sb.append(m.getDisplayName()).append("[").append(m.getCodeNameBase()).append("]");
                for (Union2<Dependency, InvalidException> u : entry.getValue()) {
                    if (!u.hasFirst()) continue;
                    sb.append("\n - ").append(u.first().toString());
                }
                sb.append("\n");
            }
            return NbBundle.getMessage(Reason.class, this.reason.l10n, sb.toString());
        }
        return this.getMessage();
    }

    static enum Reason {
        DELETE_FIXED_MODULE("fixed module: {0}"),
        DELETE_ENABLED_MODULE("enabled module: {0}"),
        RELOAD_FIXED_MODULE("reload fixed module: {0}"),
        RELOAD_ENABLED_MODULE("reload enabled module: {0}"),
        ENABLE_MISSING("Not all requested modules can be enabled: {0}", "MSG_ENABLE_MISSING"),
        ENABLE_TESTING("Would also need to enable: {0}"),
        DISABLE_TOO("Would also need to disable: {0}"),
        SIMULATE_ENABLE_AUTOLOAD("Cannot simulate enabling an autoload: {0}", "MSG_ENABLE_MISSING"),
        SIMULATE_ENABLE_EAGER("Cannot simulate enabling an eager module: {0}", "MSG_ENABLE_MISSING"),
        SIMULATE_ENABLE_ALREADY("Already enabled: {0}"),
        SIMULATE_ENABLE_INVALID("Not managed by me: {0}"),
        SIMULATE_DISABLE_AUTOLOAD("Cannot disable autoload: {0}"),
        SIMULATE_DISABLE_EAGER("Cannot disable eager module: {0}"),
        SIMULATE_DISABLE_FIXED("Cannot disable fixed module: {0}"),
        SIMULATE_DISABLE_ALREADY("Already disabled: {0}");

        final String msg;
        final String l10n;

        private Reason(String msg) {
            this(msg, null);
        }

        private Reason(String msg, String l10n) {
            this.msg = msg;
            this.l10n = l10n;
        }
    }
}

