/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.jdk;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jpt.sun.source.tree.ClassTree;
import jpt.sun.source.tree.ExpressionStatementTree;
import jpt.sun.source.tree.ExpressionTree;
import jpt.sun.source.tree.IdentifierTree;
import jpt.sun.source.tree.LambdaExpressionTree;
import jpt.sun.source.tree.MemberReferenceTree;
import jpt.sun.source.tree.MemberSelectTree;
import jpt.sun.source.tree.MethodInvocationTree;
import jpt.sun.source.tree.MethodTree;
import jpt.sun.source.tree.NewClassTree;
import jpt.sun.source.tree.ReturnTree;
import jpt.sun.source.tree.Scope;
import jpt.sun.source.tree.Tree;
import jpt.sun.source.tree.VariableTree;
import jpt.sun.source.util.TreePath;
import jpt.sun.source.util.Trees;
import jpt30.lang.model.element.Element;
import jpt30.lang.model.element.ElementKind;
import jpt30.lang.model.element.Modifier;
import jpt30.lang.model.element.Name;
import org.netbeans.api.java.source.TreeMaker;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.java.source.matching.Matcher;
import org.netbeans.api.java.source.matching.Occurrence;
import org.netbeans.api.java.source.matching.Pattern;
import org.netbeans.api.java.source.support.ErrorAwareTreePathScanner;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.modules.java.hints.jdk.ConvertToLambdaPreconditionChecker;
import org.netbeans.modules.java.hints.spiimpl.pm.PatternCompiler;

public class ConvertToLambdaConverter {
    private final TreePath pathToNewClassTree;
    private final NewClassTree newClassTree;
    private final WorkingCopy copy;
    private final Scope localScope;
    private final ConvertToLambdaPreconditionChecker preconditionChecker;

    public ConvertToLambdaConverter(TreePath pathToNewClassTree, WorkingCopy copy) {
        this.pathToNewClassTree = pathToNewClassTree;
        this.newClassTree = (NewClassTree)this.pathToNewClassTree.getLeaf();
        this.copy = copy;
        this.localScope = this.getScopeFromTree(this.pathToNewClassTree);
        this.preconditionChecker = new ConvertToLambdaPreconditionChecker(this.pathToNewClassTree, this.copy);
    }

    public void performRewriteToLambda() {
        LambdaExpressionTree lambdaTree = this.getLambdaTreeFromAnonymous(this.newClassTree, this.copy);
        if (lambdaTree == null) {
            return;
        }
        if (this.preconditionChecker.foundShadowedVariable()) {
            TreePath pathToLambda = new TreePath(this.pathToNewClassTree, lambdaTree);
            this.renameShadowedVariables(pathToLambda);
        }
        ExpressionTree convertedTree = lambdaTree;
        if (this.preconditionChecker.needsCastToExpectedType()) {
            convertedTree = this.getTreeWithCastPrepended(lambdaTree, this.newClassTree.getIdentifier());
        }
        this.copy.rewrite(this.newClassTree, convertedTree);
    }

    private static Tree possiblyCast(WorkingCopy copy, ExpressionTree tree, TreePath path, boolean typeCast) {
        if (!typeCast) {
            return tree;
        }
        NewClassTree nct = (NewClassTree)path.getLeaf();
        return copy.getTreeMaker().TypeCast(nct.getIdentifier(), tree);
    }

    public static Tree newClassToConstructorReference(WorkingCopy copy, Tree tree, TreePath contextPath, List<? extends VariableTree> passedParameters, boolean addTypeCast) {
        NewClassTree nct = (NewClassTree)tree;
        if (passedParameters.size() != nct.getArguments().size()) {
            return null;
        }
        Element e = copy.getTrees().getElement(new TreePath(contextPath, tree));
        if (e == null || e.getKind() != ElementKind.CONSTRUCTOR) {
            return null;
        }
        TreeMaker make = copy.getTreeMaker();
        return ConvertToLambdaConverter.possiblyCast(copy, make.MemberReference(MemberReferenceTree.ReferenceMode.NEW, nct.getIdentifier(), "new", nct.getTypeArguments()), contextPath, addTypeCast);
    }

    public static Tree methodInvocationToMemberReference(WorkingCopy copy, Tree tree, TreePath contextPath, List<? extends VariableTree> passedParameters, boolean addTypeCast) {
        if (tree.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return null;
        }
        ExpressionTree ms = ((MethodInvocationTree)tree).getMethodSelect();
        Element e = copy.getTrees().getElement(new TreePath(contextPath, ms));
        if (e == null || e.getKind() != ElementKind.METHOD) {
            return null;
        }
        Name name = null;
        ExpressionTree expr = null;
        TreeMaker make = copy.getTreeMaker();
        if (ms.getKind() == Tree.Kind.IDENTIFIER) {
            name = ((IdentifierTree)ms).getName();
            expr = e.getModifiers().contains((Object)Modifier.STATIC) ? make.Identifier(e.getEnclosingElement()) : make.Identifier("this");
        } else if (ms.getKind() == Tree.Kind.MEMBER_SELECT) {
            name = ((MemberSelectTree)ms).getIdentifier();
            expr = passedParameters.size() == ((MethodInvocationTree)tree).getArguments().size() ? ((MemberSelectTree)ms).getExpression() : make.Identifier(e.getEnclosingElement());
        }
        if (name == null || expr == null) {
            return null;
        }
        return ConvertToLambdaConverter.possiblyCast(copy, make.MemberReference(MemberReferenceTree.ReferenceMode.INVOKE, expr, name, Collections.emptyList()), contextPath, addTypeCast);
    }

    public void performRewriteToMemberReference() {
        MethodTree methodTree = this.getMethodFromFunctionalInterface(this.newClassTree);
        if (methodTree.getBody() == null || methodTree.getBody().getStatements().size() != 1) {
            return;
        }
        Tree tree = methodTree.getBody().getStatements().get(0);
        if (tree.getKind() == Tree.Kind.EXPRESSION_STATEMENT) {
            tree = ((ExpressionStatementTree)tree).getExpression();
        } else if (tree.getKind() == Tree.Kind.RETURN) {
            tree = ((ReturnTree)tree).getExpression();
        } else {
            return;
        }
        Tree changed = null;
        if (tree.getKind() == Tree.Kind.METHOD_INVOCATION) {
            changed = ConvertToLambdaConverter.methodInvocationToMemberReference(this.copy, tree, this.pathToNewClassTree, methodTree.getParameters(), this.preconditionChecker.needsCastToExpectedType());
        } else if (tree.getKind() == Tree.Kind.NEW_CLASS) {
            changed = ConvertToLambdaConverter.newClassToConstructorReference(this.copy, tree, this.pathToNewClassTree, methodTree.getParameters(), this.preconditionChecker.needsCastToExpectedType());
        }
        if (changed != null) {
            this.copy.rewrite(this.newClassTree, changed);
        }
    }

    private LambdaExpressionTree getLambdaTreeFromAnonymous(NewClassTree newClassTree, WorkingCopy copy) {
        TreeMaker make = copy.getTreeMaker();
        MethodTree methodTree = this.getMethodFromFunctionalInterface(newClassTree);
        Tree lambdaBody = this.getLambdaBody(methodTree, copy);
        if (lambdaBody == null) {
            return null;
        }
        return make.LambdaExpression(methodTree.getParameters(), lambdaBody);
    }

    private MethodTree getMethodFromFunctionalInterface(NewClassTree newClassTree) {
        ClassTree classTree = newClassTree.getClassBody();
        return (MethodTree)classTree.getMembers().get(1);
    }

    private Tree getLambdaBody(MethodTree methodTree, WorkingCopy copy) {
        if (methodTree.getBody() == null) {
            return null;
        }
        TreePath pathToMethodBody = TreePath.getPath(this.pathToNewClassTree, (Tree)methodTree.getBody());
        Pattern pattern = PatternCompiler.compile(copy, "{ return $expression; }", Collections.emptyMap(), Collections.emptyList());
        Collection<? extends Occurrence> matches = Matcher.create(copy).setSearchRoot(pathToMethodBody).setTreeTopSearch().match(pattern);
        if (matches.isEmpty()) {
            return methodTree.getBody();
        }
        return matches.iterator().next().getVariables().get("$expression").getLeaf();
    }

    private void renameShadowedVariables(TreePath treePath) {
        new ShadowedVariableRenameScanner().scan(treePath, this.copy.getTrees());
    }

    private ExpressionTree getTreeWithCastPrepended(ExpressionTree tree, Tree expectedType) {
        TreeMaker make = this.copy.getTreeMaker();
        return make.TypeCast(expectedType, tree);
    }

    private boolean shadowsVariable(CharSequence variableName) {
        return Utilities.isSymbolUsed(this.copy, this.pathToNewClassTree, variableName, this.localScope);
    }

    private Scope getScopeFromTree(TreePath path) {
        return this.copy.getTrees().getScope(path);
    }

    private class ShadowedVariableRenameScanner
    extends ErrorAwareTreePathScanner<Tree, Trees> {
        private final Map<Element, CharSequence> originalToNewName = new HashMap<Element, CharSequence>();

        private ShadowedVariableRenameScanner() {
        }

        @Override
        public Tree visitMethod(MethodTree methodTree, Trees trees) {
            TreePath path = this.getCurrentPath();
            if (ConvertToLambdaConverter.this.copy.getTreeUtilities().isSynthetic(path)) {
                return methodTree;
            }
            return (Tree)super.visitMethod(methodTree, trees);
        }

        @Override
        public Tree visitVariable(VariableTree variableDeclTree, Trees trees) {
            if (this.isNameAlreadyUsed(variableDeclTree.getName())) {
                TreePath path = this.getCurrentPath();
                CharSequence newName = this.getUniqueName(variableDeclTree.getName());
                Element el = trees.getElement(path);
                if (el != null) {
                    this.originalToNewName.put(el, newName);
                }
                VariableTree newTree = ConvertToLambdaConverter.this.copy.getTreeMaker().Variable(variableDeclTree.getModifiers(), newName, variableDeclTree.getType(), variableDeclTree.getInitializer());
                ConvertToLambdaConverter.this.copy.rewrite(variableDeclTree, newTree);
            }
            return (Tree)super.visitVariable(variableDeclTree, trees);
        }

        @Override
        public Tree visitIdentifier(IdentifierTree identifierTree, Trees trees) {
            TreePath currentPath = this.getCurrentPath();
            CharSequence newName = this.originalToNewName.get(trees.getElement(currentPath));
            if (newName != null) {
                IdentifierTree newTree = ConvertToLambdaConverter.this.copy.getTreeMaker().Identifier(newName);
                ConvertToLambdaConverter.this.copy.rewrite(identifierTree, newTree);
            }
            return (Tree)super.visitIdentifier(identifierTree, trees);
        }

        private boolean isNameAlreadyUsed(CharSequence name) {
            return this.originalToNewName.containsValue(name.toString()) || ConvertToLambdaConverter.this.shadowsVariable(name);
        }

        private CharSequence getUniqueName(CharSequence originalName) {
            int counter = 1;
            CharSequence newName = originalName;
            while (this.isNameAlreadyUsed(newName)) {
                newName = this.getNameWithCounterAdded(newName, counter);
                ++counter;
            }
            return newName;
        }

        private CharSequence getNameWithCounterAdded(CharSequence newName, int counter) {
            char lastChar = newName.charAt(newName.length() - 1);
            if (Character.isDigit(lastChar)) {
                return newName.subSequence(0, newName.length() - 1).toString() + counter;
            }
            return newName.toString() + counter;
        }
    }
}

