/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.cast;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlException;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.IntFunction;
import io.questdb.griffin.engine.functions.UnaryFunction;
import io.questdb.griffin.engine.functions.constants.IntConstant;
import io.questdb.std.CharSequenceIntHashMap;
import io.questdb.std.CharSequenceObjHashMap;
import io.questdb.std.IntList;
import io.questdb.std.ObjList;

public class CastStrToRegClassFunctionFactory
implements FunctionFactory {
    private static final CharSequenceObjHashMap<Function> funcMap = new CharSequenceObjHashMap();
    private static final CharSequenceIntHashMap valueMap = new CharSequenceIntHashMap(4, 0.6, Integer.MIN_VALUE);

    @Override
    public String getSignature() {
        return "cast(Sp)";
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) throws SqlException {
        Function arg = args.getQuick(0);
        if (arg.isConstant()) {
            Function result = funcMap.get(arg.getStr(null));
            if (result != null) {
                return result;
            }
            throw SqlException.$(argPositions.getQuick(0), "unsupported class [name=").put(arg.getStr(null)).put(']');
        }
        return new CastStrToRegClassFunction(arg);
    }

    static {
        funcMap.put("pg_namespace", new IntConstant(2615));
        funcMap.put("pg_class", new IntConstant(1259));
        valueMap.put("pg_namespace", 2615);
        valueMap.put("pg_class", 1259);
    }

    private static class CastStrToRegClassFunction
    extends IntFunction
    implements UnaryFunction {
        private final Function arg;

        public CastStrToRegClassFunction(Function arg) {
            this.arg = arg;
        }

        @Override
        public Function getArg() {
            return this.arg;
        }

        @Override
        public int getInt(Record rec) {
            CharSequence val = this.arg.getStr(rec);
            if (val != null) {
                return valueMap.get(val);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.val(this.arg).val("::regclass");
        }
    }
}

