/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.columns;

import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.ScalarFunction;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.engine.functions.UuidFunction;
import io.questdb.std.ObjList;

public final class UuidColumn
extends UuidFunction
implements ScalarFunction {
    private static final ObjList<UuidColumn> COLUMNS = new ObjList(32);
    private final int columnIndex;

    public UuidColumn(int columnIndex) {
        this.columnIndex = columnIndex;
    }

    public static UuidColumn newInstance(int columnIndex) {
        if (columnIndex < 32) {
            return COLUMNS.getQuick(columnIndex);
        }
        return new UuidColumn(columnIndex);
    }

    @Override
    public long getLong128Hi(Record rec) {
        return rec.getLong128Hi(this.columnIndex);
    }

    @Override
    public long getLong128Lo(Record rec) {
        return rec.getLong128Lo(this.columnIndex);
    }

    @Override
    public boolean isReadThreadSafe() {
        return true;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.putColumnName(this.columnIndex);
    }

    static {
        COLUMNS.setPos(32);
        for (int i = 0; i < 32; ++i) {
            COLUMNS.setQuick(i, new UuidColumn(i));
        }
    }
}

