/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.toolkit.configuration.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.apache.nifi.flow.VersionedProcessor;
import org.apache.nifi.minifi.commons.schema.ProcessorSchema;
import org.apache.nifi.minifi.commons.schema.common.CollectionUtil;

public class NiFiRegProcessorSchemaFunction
implements Function<VersionedProcessor, ProcessorSchema> {
    @Override
    public ProcessorSchema apply(VersionedProcessor versionedProcessor) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", versionedProcessor.getName());
        map.put("id", versionedProcessor.getIdentifier());
        map.put("class", versionedProcessor.getType());
        map.put("scheduling strategy", versionedProcessor.getSchedulingStrategy());
        map.put("scheduling period", versionedProcessor.getSchedulingPeriod());
        map.put("max concurrent tasks", versionedProcessor.getConcurrentlySchedulableTaskCount());
        map.put("penalization period", versionedProcessor.getPenaltyDuration());
        map.put("yield period", versionedProcessor.getYieldDuration());
        Long runDurationMillis = versionedProcessor.getRunDurationMillis();
        if (runDurationMillis != null) {
            map.put("run duration nanos", runDurationMillis * 1000L);
        }
        ArrayList autoTerminateRelationships = new ArrayList(CollectionUtil.nullToEmpty((Set)versionedProcessor.getAutoTerminatedRelationships()));
        map.put("auto-terminated relationships list", autoTerminateRelationships);
        map.put("Properties", new HashMap(CollectionUtil.nullToEmpty((Map)versionedProcessor.getProperties())));
        String annotationData = versionedProcessor.getAnnotationData();
        if (annotationData != null && !annotationData.isEmpty()) {
            map.put("annotation data", annotationData);
        }
        return new ProcessorSchema(map);
    }
}

