/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.util.Collection;
import org.apache.nifi.connectable.Connectable;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.controller.ProcessorNode;
import org.apache.nifi.controller.ReportingTaskNode;
import org.apache.nifi.controller.service.ControllerServiceNode;
import org.apache.nifi.controller.service.ControllerServiceProvider;
import org.apache.nifi.groups.AbstractComponentScheduler;
import org.apache.nifi.registry.flow.mapping.VersionedComponentStateLookup;
import org.apache.nifi.remote.RemoteGroupPort;

public class DefaultComponentScheduler
extends AbstractComponentScheduler {
    public DefaultComponentScheduler(ControllerServiceProvider controllerServiceProvider, VersionedComponentStateLookup stateLookup) {
        super(controllerServiceProvider, stateLookup);
    }

    protected void startNow(Connectable component) {
        switch (component.getConnectableType()) {
            case PROCESSOR: {
                ProcessorNode processorNode = (ProcessorNode)component;
                processorNode.getProcessGroup().startProcessor(processorNode, false);
                break;
            }
            case INPUT_PORT: {
                Port port = (Port)component;
                port.getProcessGroup().startInputPort(port);
                break;
            }
            case OUTPUT_PORT: {
                Port port = (Port)component;
                port.getProcessGroup().startOutputPort(port);
                break;
            }
            case REMOTE_INPUT_PORT: 
            case REMOTE_OUTPUT_PORT: {
                RemoteGroupPort port = (RemoteGroupPort)component;
                port.getRemoteProcessGroup().startTransmitting(port);
            }
        }
    }

    protected void enableNow(Collection<ControllerServiceNode> controllerServices) {
        this.getControllerServiceProvider().enableControllerServices(controllerServices);
    }

    protected void startNow(ReportingTaskNode reportingTask) {
        reportingTask.start();
    }
}

