/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.groups;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.nifi.components.state.Scope;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.components.state.StateMap;
import org.apache.nifi.connectable.Connection;
import org.apache.nifi.connectable.Port;
import org.apache.nifi.groups.BatchCounts;
import org.apache.nifi.groups.ProcessGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StandardBatchCounts
implements BatchCounts {
    private static final Logger logger = LoggerFactory.getLogger(StandardBatchCounts.class);
    private final ProcessGroup processGroup;
    private Map<String, Integer> counts = null;
    private boolean hasBeenReset = false;
    private final StateManager stateManager;
    private Map<String, Integer> restoredValues;

    public StandardBatchCounts(ProcessGroup processGroup, StateManager stateManager) {
        this.processGroup = processGroup;
        this.stateManager = stateManager;
    }

    public synchronized void reset() {
        this.counts = null;
        this.hasBeenReset = true;
        try {
            this.stateManager.clear(Scope.LOCAL);
        }
        catch (Exception e) {
            logger.error("Failed to update local state for {}. This could result in the batch.output.* attributes being inaccurate if NiFi is restarted before this is resolved", (Object)this.processGroup, (Object)e);
        }
    }

    public synchronized Map<String, Integer> captureCounts() {
        if (!this.hasBeenReset) {
            return this.restoreState();
        }
        if (this.counts == null) {
            this.counts = new HashMap<String, Integer>();
            HashMap<String, String> stateMapValues = new HashMap<String, String>();
            for (Port outputPort : this.processGroup.getOutputPorts()) {
                int count = 0;
                for (Connection connection : outputPort.getIncomingConnections()) {
                    count += connection.getFlowFileQueue().size().getObjectCount();
                }
                String name = outputPort.getName();
                this.counts.put(name, count);
                stateMapValues.put(name, String.valueOf(count));
            }
            try {
                this.stateManager.setState(stateMapValues, Scope.LOCAL);
            }
            catch (Exception e) {
                logger.error("Failed to update local state for {}. This could result in the batch.output.* attributes being inaccurate if NiFi is restarted before this is resolved", (Object)this.processGroup, (Object)e);
            }
        }
        return this.counts;
    }

    private Map<String, Integer> restoreState() {
        StateMap stateMap;
        if (this.restoredValues != null) {
            return this.restoredValues;
        }
        try {
            stateMap = this.stateManager.getState(Scope.LOCAL);
        }
        catch (IOException e) {
            logger.error("Failed to restore local state for {}. This could result in the batch.output.* attributes being inaccurate for the current batch of FlowFiles", (Object)this.processGroup, (Object)e);
            return Collections.emptyMap();
        }
        this.restoredValues = new HashMap<String, Integer>();
        Map rawValues = stateMap.toMap();
        rawValues.forEach((k, v) -> this.restoredValues.put((String)k, Integer.parseInt(v)));
        return this.restoredValues;
    }
}

