/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.extension;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import org.apache.nifi.authorization.user.NiFiUser;
import org.apache.nifi.flow.resource.ExternalResourceDescriptor;
import org.apache.nifi.flow.resource.ExternalResourceProvider;
import org.apache.nifi.flow.resource.ExternalResourceProviderInitializationContext;
import org.apache.nifi.flow.resource.ImmutableExternalResourceDescriptor;
import org.apache.nifi.registry.extension.ExtensionRegistryException;
import org.apache.nifi.registry.extension.NiFiRegistryExtensionBundleMetadata;
import org.apache.nifi.registry.extension.NiFiRegistryExtensionRegistry;
import org.apache.nifi.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryExternalResourceProvider
implements ExternalResourceProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(NiFiRegistryExternalResourceProvider.class);
    private static final String NIFI_REGISTRY_CLIENT_ID = "nifi-registry-nar-provider";
    private static final String NIFI_REGISTRY_CLIENT_NAME = "NiFi Registry NAR Provider";
    static final String URL_PROPERTY = "url";
    private volatile NiFiRegistryExtensionRegistry extensionRegistry;
    private volatile boolean initialized = false;

    public void initialize(ExternalResourceProviderInitializationContext context) {
        String url = (String)context.getProperties().get(URL_PROPERTY);
        if (StringUtils.isBlank((String)url)) {
            throw new IllegalArgumentException("NiFiRegistryNarProvider requires a `url` property");
        }
        SSLContext sslContext = context.getSSLContext();
        if (url.startsWith("https") && sslContext == null) {
            throw new IllegalStateException("NiFi TLS properties must be specified in order to connect to NiFi Registry via https");
        }
        this.extensionRegistry = new NiFiRegistryExtensionRegistry(NIFI_REGISTRY_CLIENT_ID, url, NIFI_REGISTRY_CLIENT_NAME, sslContext);
        this.initialized = true;
    }

    public Collection<ExternalResourceDescriptor> listResources() throws IOException {
        if (!this.initialized) {
            LOGGER.error("Provider is not initialized");
        }
        try {
            Set<NiFiRegistryExtensionBundleMetadata> bundleMetadata = this.extensionRegistry.getExtensionBundleMetadata(null);
            return bundleMetadata.stream().map(bm -> new ImmutableExternalResourceDescriptor(bm.toLocationString(), bm.getTimestamp())).collect(Collectors.toSet());
        }
        catch (ExtensionRegistryException ere) {
            LOGGER.error("Unable to retrieve listing of NARs from NiFi Registry at [{}]", (Object)this.extensionRegistry.getURL(), (Object)ere);
            return Collections.emptySet();
        }
    }

    public InputStream fetchExternalResource(ExternalResourceDescriptor descriptor) throws IOException {
        if (!this.initialized) {
            LOGGER.error("Provider is not initialized");
        }
        NiFiRegistryExtensionBundleMetadata bundleMetadata = NiFiRegistryExtensionBundleMetadata.fromLocationString(descriptor.getLocation()).registryIdentifier(this.extensionRegistry.getIdentifier()).build();
        LOGGER.debug("Fetching NAR contents for bundleIdentifier [{}] and version [{}]", (Object)bundleMetadata.getBundleIdentifier(), (Object)bundleMetadata.getVersion());
        try {
            return this.extensionRegistry.getExtensionBundleContent((NiFiUser)null, bundleMetadata);
        }
        catch (ExtensionRegistryException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

