/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.cairo.wal;

import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.TableUtils;
import io.questdb.cairo.TxReader;
import io.questdb.cairo.wal.seq.TableSequencerAPI;
import io.questdb.cairo.wal.seq.TransactionLogCursor;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.mp.SimpleWaitingLock;
import io.questdb.mp.SynchronizedJob;
import io.questdb.std.FilesFacade;
import io.questdb.std.FindVisitor;
import io.questdb.std.IntHashSet;
import io.questdb.std.IntList;
import io.questdb.std.Numbers;
import io.questdb.std.NumericException;
import io.questdb.std.ObjList;
import io.questdb.std.datetime.microtime.MicrosecondClock;
import io.questdb.std.datetime.millitime.MillisecondClock;
import io.questdb.std.str.NativeLPSZ;
import io.questdb.std.str.Path;
import io.questdb.std.str.StringSink;
import java.io.Closeable;
import java.util.PrimitiveIterator;

public class WalPurgeJob
extends SynchronizedJob
implements Closeable {
    private static final Log LOG = LogFactory.getLog(WalPurgeJob.class);
    private final TableSequencerAPI.RegisteredTable broadSweepIter;
    private final long checkInterval;
    private final MicrosecondClock clock;
    private final CairoConfiguration configuration;
    private final StringSink debugBuffer = new StringSink();
    private final IntHashSet discoveredWalIds = new IntHashSet();
    private final CairoEngine engine;
    private final FilesFacade ff;
    private final MillisecondClock millisecondClock;
    private final Path path = new Path();
    private final SimpleWaitingLock runLock = new SimpleWaitingLock();
    private final NativeLPSZ segmentName = new NativeLPSZ();
    private final long spinLockTimeout;
    private final ObjList<TableToken> tableTokenBucket = new ObjList();
    private final TxReader txReader;
    private final WalInfoDataFrame walInfoDataFrame = new WalInfoDataFrame();
    private final NativeLPSZ walName = new NativeLPSZ();
    private final IntHashSet walsInUse = new IntHashSet();
    private long last = 0L;
    private TableToken tableToken;
    private final FindVisitor discoverWalDirectoriesIterFunc = this::discoverWalDirectoriesIter;
    private int walId;
    private final FindVisitor deleteClosedSegmentsIterFunc = this::deleteClosedSegmentsIter;
    private int walsLatestSegmentId;
    private final FindVisitor deleteUnreachableSegmentsIterFunc = this::deleteUnreachableSegmentsIter;

    public WalPurgeJob(CairoEngine engine, FilesFacade ff, MicrosecondClock clock) {
        this.engine = engine;
        this.ff = ff;
        this.clock = clock;
        this.checkInterval = engine.getConfiguration().getWalPurgeInterval() * 1000L;
        this.millisecondClock = engine.getConfiguration().getMillisecondClock();
        this.spinLockTimeout = engine.getConfiguration().getSpinLockTimeout();
        this.txReader = new TxReader(ff);
        this.broadSweepIter = this::broadSweep;
        assert ("wal".equals("wal"));
        this.configuration = engine.getConfiguration();
    }

    public WalPurgeJob(CairoEngine engine) {
        this(engine, engine.getConfiguration().getFilesFacade(), engine.getConfiguration().getMicrosecondClock());
    }

    @Override
    public void close() {
        this.txReader.close();
        this.path.close();
    }

    public void delayByHalfInterval() {
        this.last = this.clock.getTicks() - this.checkInterval / 2L;
    }

    public SimpleWaitingLock getRunLock() {
        return this.runLock;
    }

    private static boolean matchesSegmentName(CharSequence name) {
        int n = name.length();
        for (int i = 0; i < n; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean matchesWalNamePattern(CharSequence name) {
        int len = name.length();
        if (len < "wal".length() + 1) {
            return false;
        }
        if (name.charAt(0) != 'w' || name.charAt(1) != 'a' || name.charAt(2) != 'l') {
            return false;
        }
        for (int i = 3; i < len; ++i) {
            char c = name.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private void accumDebugState() {
        this.debugBuffer.clear();
        this.debugBuffer.put("table=").put(this.tableToken.getDirName()).put(", discoveredWalIds=[");
        PrimitiveIterator.OfInt it = this.discoveredWalIds.iterator();
        while (it.hasNext()) {
            int walId = it.nextInt();
            this.debugBuffer.put(walId);
            if (this.walsInUse.contains(walId)) {
                this.debugBuffer.put("(locked)");
            }
            if (!it.hasNext()) continue;
            this.debugBuffer.put(',');
        }
        this.debugBuffer.put("], walInfoDataFrame=[");
        for (int index = 0; index < this.walInfoDataFrame.size(); ++index) {
            this.debugBuffer.put('(').put(this.walInfoDataFrame.walIds.get(index)).put(',').put(this.walInfoDataFrame.segmentIds.get(index)).put(')');
            if (index >= this.walInfoDataFrame.size() - 1) continue;
            this.debugBuffer.put(',');
        }
        this.debugBuffer.put(']');
    }

    private void broadSweep() {
        this.engine.getTableSequencerAPI().forAllWalTables(this.tableTokenBucket, true, this.broadSweepIter);
    }

    private void broadSweep(int tableId, TableToken tableToken, long lastTxn) {
        try {
            this.tableToken = tableToken;
            this.discoveredWalIds.clear();
            this.walsInUse.clear();
            this.walInfoDataFrame.clear();
            this.discoverWalDirectories();
            if (this.discoveredWalIds.size() != 0) {
                this.populateWalInfoDataFrame();
                this.accumDebugState();
                this.deleteUnreachableSegments();
                this.deleteOutstandingWalDirectories();
            }
            if (lastTxn < 0L && this.engine.isTableDropped(tableToken)) {
                this.deleteTableSequencerFiles(tableToken);
                if (TableUtils.exists(this.ff, Path.getThreadLocal(""), this.configuration.getRoot(), tableToken.getDirName()) != 0) {
                    LOG.info().$("table is fully dropped [tableDir=").$(tableToken.getDirName()).I$();
                    this.engine.removeTableToken(tableToken);
                } else {
                    LOG.info().$("table is not fully dropped, pinging WAL Apply job to delete table files [tableDir=").$(tableToken.getDirName()).I$();
                    this.engine.notifyWalTxnRepublisher();
                }
            }
        }
        catch (CairoException ce) {
            LOG.error().$("broad sweep failed [table=").$(tableToken).$(", msg=").$(ce).$(", errno=").$(this.ff.errno()).$(']').$();
        }
    }

    private boolean couldObtainLock(Path path) {
        int lockFd = TableUtils.lock(this.ff, path, false);
        if (lockFd != -1) {
            this.ff.close(lockFd);
            return true;
        }
        return false;
    }

    private void deleteClosedSegments() {
        this.setWalPath(this.tableToken, this.walId);
        this.ff.iterateDir(this.path, this.deleteClosedSegmentsIterFunc);
    }

    private void deleteClosedSegmentsIter(long pUtf8NameZ, int type) {
        if (type == 4 && WalPurgeJob.matchesSegmentName(this.segmentName.of(pUtf8NameZ))) {
            int segmentId;
            try {
                segmentId = Numbers.parseInt(this.segmentName);
            }
            catch (NumericException _ne) {
                return;
            }
            if (this.couldObtainLock(this.setSegmentLockPath(this.tableToken, this.walId, segmentId))) {
                this.deleteSegmentDirectory(this.tableToken, this.walId, segmentId);
            }
        }
    }

    private boolean deleteFile(Path path) {
        int errno;
        if (!this.ff.remove(path) && (errno = this.ff.errno()) != 2) {
            LOG.error().$("Could not delete file [path=").$(path).$(", errno=").$(errno).$(']').$();
            return false;
        }
        return true;
    }

    private void deleteOutstandingWalDirectories() {
        PrimitiveIterator.OfInt it = this.discoveredWalIds.iterator();
        while (it.hasNext()) {
            this.walId = it.nextInt();
            if (this.walsInUse.contains(this.walId)) {
                this.deleteClosedSegments();
                continue;
            }
            this.deleteWalDirectory();
        }
    }

    private void deleteSegmentDirectory(TableToken tableName, int walId, int segmentId) {
        this.mayLogDebugInfo();
        LOG.info().$("deleting WAL segment directory [table=").utf8(tableName.getDirName()).$(", walId=").$(walId).$(", segmentId=").$(segmentId).$(']').$();
        if (this.deleteFile(this.setSegmentLockPath(tableName, walId, segmentId))) {
            this.recursiveDelete(this.setSegmentPath(tableName, walId, segmentId));
        }
    }

    private void deleteTableSequencerFiles(TableToken tableToken) {
        this.setTableSequencerPath(tableToken);
        LOG.info().$("table is dropped, deleting sequencer files [table=").utf8(tableToken.getDirName()).$(']').$();
        this.recursiveDelete(this.path);
    }

    private void deleteUnreachableSegments() {
        for (int index = 0; index < this.walInfoDataFrame.size(); ++index) {
            this.walId = this.walInfoDataFrame.walIds.get(index);
            this.walsLatestSegmentId = this.walInfoDataFrame.segmentIds.get(index);
            this.ff.iterateDir(this.setWalPath(this.tableToken, this.walId), this.deleteUnreachableSegmentsIterFunc);
        }
    }

    private void deleteUnreachableSegmentsIter(long pUtf8NameZ, int type) {
        if (type == 4 && WalPurgeJob.matchesSegmentName(this.segmentName.of(pUtf8NameZ))) {
            int segmentId;
            try {
                segmentId = Numbers.parseInt(this.segmentName);
            }
            catch (NumericException _ne) {
                return;
            }
            if (this.segmentIsReapable(segmentId, this.walsLatestSegmentId)) {
                this.deleteSegmentDirectory(this.tableToken, this.walId, segmentId);
            }
        }
    }

    private void deleteWalDirectory() {
        this.mayLogDebugInfo();
        LOG.info().$("deleting WAL directory [table=").utf8(this.tableToken.getDirName()).$(", walId=").$(this.walId).$(']').$();
        if (this.deleteFile(this.setWalLockPath(this.tableToken, this.walId))) {
            this.recursiveDelete(this.setWalPath(this.tableToken, this.walId));
        }
    }

    private void discoverWalDirectories() {
        this.ff.iterateDir(this.setTablePath(this.tableToken), this.discoverWalDirectoriesIterFunc);
    }

    private void discoverWalDirectoriesIter(long pUtf8NameZ, int type) {
        if (type == 4 && WalPurgeJob.matchesWalNamePattern(this.walName.of(pUtf8NameZ))) {
            int walId;
            try {
                walId = Numbers.parseInt(this.walName, 3, this.walName.length());
            }
            catch (NumericException ne) {
                return;
            }
            this.discoveredWalIds.add(walId);
            if (this.walIsInUse(this.tableToken, walId)) {
                this.walsInUse.add(walId);
            }
        }
    }

    private void mayLogDebugInfo() {
        if (this.debugBuffer.length() > 0) {
            LOG.info().utf8(this.debugBuffer).$();
            this.debugBuffer.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateWalInfoDataFrame() {
        block18: {
            this.setTxnPath(this.tableToken);
            if (!this.engine.isTableDropped(this.tableToken)) {
                try {
                    this.txReader.ofRO(this.path, 3);
                    TableUtils.safeReadTxn(this.txReader, this.millisecondClock, this.spinLockTimeout);
                    long lastAppliedTxn = this.txReader.getSeqTxn();
                    TableSequencerAPI tableSequencerAPI = this.engine.getTableSequencerAPI();
                    try (TransactionLogCursor transactionLogCursor = tableSequencerAPI.getCursor(this.tableToken, lastAppliedTxn);){
                        while (transactionLogCursor.hasNext() && this.discoveredWalIds.size() > 0) {
                            int walId = transactionLogCursor.getWalId();
                            if (!this.discoveredWalIds.contains(walId)) continue;
                            this.walInfoDataFrame.add(walId, transactionLogCursor.getSegmentId());
                            this.discoveredWalIds.remove(walId);
                        }
                        break block18;
                    }
                }
                finally {
                    this.txReader.close();
                }
            }
            PrimitiveIterator.OfInt it = this.discoveredWalIds.iterator();
            while (it.hasNext()) {
                this.walInfoDataFrame.add(it.nextInt(), Integer.MAX_VALUE);
            }
        }
    }

    private void recursiveDelete(Path path) {
        int errno = this.ff.rmdir(path);
        if (errno > 0 && !CairoException.errnoRemovePathDoesNotExist(errno)) {
            LOG.error().$("could not delete directory [path=").utf8(path).$(", errno=").$(errno).$(']').$();
        }
    }

    private boolean segmentIsReapable(int segmentId, int walsLatestSegmentId) {
        return segmentId < walsLatestSegmentId;
    }

    private Path setSegmentLockPath(TableToken tableName, int walId, int segmentId) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).slash().put(segmentId);
        TableUtils.lockName(this.path);
        return this.path;
    }

    private Path setSegmentPath(TableToken tableName, int walId, int segmentId) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).slash().put(segmentId).$();
    }

    private Path setTablePath(TableToken tableName) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).$();
    }

    private void setTableSequencerPath(TableToken tableName) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("txn_seq").$();
    }

    private void setTxnPath(TableToken tableName) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("_txn").$();
    }

    private Path setWalLockPath(TableToken tableName, int walId) {
        this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId);
        TableUtils.lockName(this.path);
        return this.path;
    }

    private Path setWalPath(TableToken tableName, int walId) {
        return this.path.of(this.configuration.getRoot()).concat(tableName).concat("wal").put(walId).$();
    }

    private boolean walIsInUse(TableToken tableName, int walId) {
        return !this.couldObtainLock(this.setWalLockPath(tableName, walId));
    }

    @Override
    protected boolean runSerially() {
        long t = this.clock.getTicks();
        if (this.last + this.checkInterval < t) {
            this.last = t;
            if (this.runLock.tryLock()) {
                try {
                    this.broadSweep();
                }
                finally {
                    this.runLock.unlock();
                }
            } else {
                LOG.info().$("skipping, locked out").$();
            }
        }
        return false;
    }

    private static class WalInfoDataFrame {
        public final IntList segmentIds = new IntList();
        public final IntList walIds = new IntList();

        private WalInfoDataFrame() {
        }

        public void add(int walId, int segmentId) {
            this.walIds.add(walId);
            this.segmentIds.add(segmentId);
        }

        public void clear() {
            this.walIds.clear();
            this.segmentIds.clear();
        }

        public int size() {
            return this.walIds.size();
        }
    }
}

