/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.functions.catalogue;

import io.questdb.TelemetryJob;
import io.questdb.cairo.AbstractRecordCursorFactory;
import io.questdb.cairo.CairoConfiguration;
import io.questdb.cairo.CairoEngine;
import io.questdb.cairo.CairoException;
import io.questdb.cairo.GenericRecordMetadata;
import io.questdb.cairo.PartitionBy;
import io.questdb.cairo.TableColumnMetadata;
import io.questdb.cairo.TableReaderMetadata;
import io.questdb.cairo.TableToken;
import io.questdb.cairo.sql.Function;
import io.questdb.cairo.sql.Record;
import io.questdb.cairo.sql.RecordCursor;
import io.questdb.cairo.sql.RecordMetadata;
import io.questdb.griffin.FunctionFactory;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.CursorFunction;
import io.questdb.log.Log;
import io.questdb.log.LogFactory;
import io.questdb.std.Chars;
import io.questdb.std.IntList;
import io.questdb.std.Misc;
import io.questdb.std.ObjList;
import io.questdb.std.str.Path;

public class TableListFunctionFactory
implements FunctionFactory {
    private static final Log LOG = LogFactory.getLog(TableListFunctionFactory.class);
    private static final RecordMetadata METADATA;
    private static final String SIGNATURE = "tables()";
    private static final int designatedTimestampColumn;
    private static final int idColumn;
    private static final int maxUncommittedRowsColumn;
    private static final int nameColumn;
    private static final int o3MaxLagColumn;
    private static final int partitionByColumn;
    private static final int systemNameColumn;
    private static final int writeModeColumn;

    @Override
    public String getSignature() {
        return SIGNATURE;
    }

    @Override
    public boolean isRuntimeConstant() {
        return true;
    }

    @Override
    public Function newInstance(int position, ObjList<Function> args, IntList argPositions, CairoConfiguration configuration, SqlExecutionContext sqlExecutionContext) {
        return new CursorFunction(new TableListCursorFactory(configuration)){

            @Override
            public boolean isRuntimeConstant() {
                return true;
            }
        };
    }

    static {
        GenericRecordMetadata metadata = new GenericRecordMetadata();
        metadata.add(new TableColumnMetadata("id", 5));
        idColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("name", 11));
        nameColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("designatedTimestamp", 11));
        designatedTimestampColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("partitionBy", 11));
        partitionByColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("maxUncommittedRows", 5));
        maxUncommittedRowsColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("o3MaxLag", 6));
        o3MaxLagColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("walEnabled", 1));
        writeModeColumn = metadata.getColumnCount() - 1;
        metadata.add(new TableColumnMetadata("directoryName", 11));
        systemNameColumn = metadata.getColumnCount() - 1;
        METADATA = metadata;
    }

    private static class TableListCursorFactory
    extends AbstractRecordCursorFactory {
        private final TableListRecordCursor cursor;
        private final boolean hideTelemetryTables;
        private final CharSequence sysTablePrefix;
        private CairoEngine engine;
        private Path path;
        private TableReaderMetadata tableReaderMetadata;

        public TableListCursorFactory(CairoConfiguration configuration) {
            super(METADATA);
            this.path = new Path().of(configuration.getRoot()).$();
            this.sysTablePrefix = configuration.getSystemTableNamePrefix();
            this.cursor = new TableListRecordCursor();
            this.hideTelemetryTables = configuration.getTelemetryConfiguration().hideTables();
            this.tableReaderMetadata = new TableReaderMetadata(configuration);
        }

        @Override
        public RecordCursor getCursor(SqlExecutionContext executionContext) {
            this.engine = executionContext.getCairoEngine();
            this.cursor.toTop();
            return this.cursor;
        }

        @Override
        public boolean recordCursorSupportsRandomAccess() {
            return false;
        }

        @Override
        public void toPlan(PlanSink sink) {
            sink.type(TableListFunctionFactory.SIGNATURE);
        }

        @Override
        protected void _close() {
            this.path = Misc.free(this.path);
            this.tableReaderMetadata = Misc.free(this.tableReaderMetadata);
        }

        private class TableListRecordCursor
        implements RecordCursor {
            private final TableListRecord record = new TableListRecord();
            private final ObjList<TableToken> tableBucket = new ObjList();
            private int tableIndex = -1;
            private TableToken tableToken;

            private TableListRecordCursor() {
            }

            @Override
            public void close() {
                this.tableIndex = -1;
                TableListCursorFactory.this.tableReaderMetadata.clear();
            }

            @Override
            public Record getRecord() {
                return this.record;
            }

            @Override
            public Record getRecordB() {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean hasNext() {
                if (this.tableIndex < 0) {
                    TableListCursorFactory.this.engine.getTableTokens(this.tableBucket, false);
                    this.tableIndex = -1;
                }
                ++this.tableIndex;
                int n = this.tableBucket.size();
                while (this.tableIndex < n) {
                    this.tableToken = this.tableBucket.get(this.tableIndex);
                    if (this.record.open(this.tableToken)) break;
                    ++this.tableIndex;
                }
                return this.tableIndex < n;
            }

            @Override
            public void recordAt(Record record, long atRowId) {
                throw new UnsupportedOperationException();
            }

            @Override
            public long size() {
                return -1L;
            }

            @Override
            public void toTop() {
                this.close();
            }

            public class TableListRecord
            implements Record {
                private int maxUncommittedRows;
                private long o3MaxLag;
                private int partitionBy;
                private int tableId;

                @Override
                public boolean getBool(int col) {
                    if (col == writeModeColumn) {
                        return TableListCursorFactory.this.tableReaderMetadata.isWalEnabled();
                    }
                    return false;
                }

                @Override
                public int getInt(int col) {
                    if (col == idColumn) {
                        return this.tableId;
                    }
                    if (col == maxUncommittedRowsColumn) {
                        return this.maxUncommittedRows;
                    }
                    return Integer.MIN_VALUE;
                }

                @Override
                public long getLong(int col) {
                    if (col == o3MaxLagColumn) {
                        return this.o3MaxLag;
                    }
                    return Long.MIN_VALUE;
                }

                @Override
                public CharSequence getStr(int col) {
                    if (col == nameColumn) {
                        return TableListRecordCursor.this.tableToken.getTableName();
                    }
                    if (col == partitionByColumn) {
                        return PartitionBy.toString(this.partitionBy);
                    }
                    if (col == designatedTimestampColumn && TableListCursorFactory.this.tableReaderMetadata.getTimestampIndex() > -1) {
                        return TableListCursorFactory.this.tableReaderMetadata.getColumnName(TableListCursorFactory.this.tableReaderMetadata.getTimestampIndex());
                    }
                    if (col == systemNameColumn) {
                        return TableListRecordCursor.this.tableToken.getDirName();
                    }
                    return null;
                }

                @Override
                public CharSequence getStrB(int col) {
                    return this.getStr(col);
                }

                @Override
                public int getStrLen(int col) {
                    return this.getStr(col).length();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public boolean open(TableToken tableToken) {
                    if (TableListCursorFactory.this.hideTelemetryTables && (Chars.equals((CharSequence)tableToken.getTableName(), TelemetryJob.tableName) || Chars.equals((CharSequence)tableToken.getTableName(), TelemetryJob.configTableName) || Chars.startsWith((CharSequence)tableToken.getTableName(), TableListCursorFactory.this.sysTablePrefix))) {
                        return false;
                    }
                    int pathLen = TableListCursorFactory.this.path.length();
                    try {
                        TableListCursorFactory.this.path.concat(tableToken).concat("_meta").$();
                        TableListCursorFactory.this.tableReaderMetadata.load(TableListCursorFactory.this.path.$());
                        this.tableId = TableListCursorFactory.this.tableReaderMetadata.getTableId();
                        this.maxUncommittedRows = TableListCursorFactory.this.tableReaderMetadata.getMaxUncommittedRows();
                        this.o3MaxLag = TableListCursorFactory.this.tableReaderMetadata.getO3MaxLag();
                        this.partitionBy = TableListCursorFactory.this.tableReaderMetadata.getPartitionBy();
                    }
                    catch (CairoException e) {
                        LOG.info().$("cannot query table metadata [table=").$(tableToken).$(", error=").$(e.getFlyweightMessage()).$(", errno=").$(e.getErrno()).I$();
                        boolean bl = false;
                        return bl;
                    }
                    finally {
                        TableListCursorFactory.this.path.trimTo(pathLen).$();
                    }
                    return true;
                }
            }
        }
    }
}

