/*
 * Decompiled with CFR 0.152.
 */
package io.questdb.griffin.engine.table;

import io.questdb.MessageBus;
import io.questdb.cairo.BitmapIndexReader;
import io.questdb.cairo.ColumnType;
import io.questdb.cairo.TableReader;
import io.questdb.cairo.sql.DataFrame;
import io.questdb.cairo.sql.SqlExecutionCircuitBreaker;
import io.questdb.cairo.vm.api.MemoryR;
import io.questdb.cutlass.text.AtomicBooleanCircuitBreaker;
import io.questdb.griffin.PlanSink;
import io.questdb.griffin.Plannable;
import io.questdb.griffin.SqlExecutionContext;
import io.questdb.griffin.engine.functions.geohash.GeoHashNative;
import io.questdb.griffin.engine.table.AbstractRecordListCursor;
import io.questdb.griffin.engine.table.LatestByArguments;
import io.questdb.mp.RingQueue;
import io.questdb.mp.SOUnboundedCountDownLatch;
import io.questdb.mp.Sequence;
import io.questdb.std.DirectLongList;
import io.questdb.std.IntList;
import io.questdb.std.Rows;
import io.questdb.std.Vect;
import io.questdb.tasks.LatestByTask;
import org.jetbrains.annotations.NotNull;

class LatestByAllIndexedRecordCursor
extends AbstractRecordListCursor
implements Plannable {
    protected final long indexShift = 0L;
    protected final DirectLongList prefixes;
    private final int columnIndex;
    private final SOUnboundedCountDownLatch doneLatch = new SOUnboundedCountDownLatch();
    private final AtomicBooleanCircuitBreaker sharedCircuitBreaker = new AtomicBooleanCircuitBreaker();
    protected long aIndex;
    protected long aLimit;

    public LatestByAllIndexedRecordCursor(int columnIndex, @NotNull DirectLongList rows, @NotNull IntList columnIndexes, @NotNull DirectLongList prefixes) {
        super(rows, columnIndexes);
        this.columnIndex = columnIndex;
        this.prefixes = prefixes;
    }

    @Override
    public boolean hasNext() {
        if (this.aIndex < this.aLimit) {
            long row = this.rows.get(this.aIndex++) - 1L;
            this.recordA.jumpTo(Rows.toPartitionIndex(row), Rows.toLocalRowID(row));
            return true;
        }
        return false;
    }

    @Override
    public long size() {
        return this.aLimit - 0L;
    }

    @Override
    public void toPlan(PlanSink sink) {
        sink.type("Index backward scan").meta("on").putColumnName(this.columnIndex);
        sink.meta("parallel").val(true);
    }

    @Override
    public void toTop() {
        this.aIndex = 0L;
    }

    private static int getPow2SizeOfGeoHashType(int type) {
        return 1 << ColumnType.pow2SizeOfBits(ColumnType.getGeoHashBits(type));
    }

    private void processTasks(SqlExecutionCircuitBreaker circuitBreaker, RingQueue<LatestByTask> queue, Sequence subSeq, int queuedCount) {
        while (this.doneLatch.getCount() > -queuedCount) {
            long seq = subSeq.next();
            if (seq <= -1L) continue;
            if (circuitBreaker.checkIfTripped()) {
                this.sharedCircuitBreaker.cancel();
            }
            queue.get(seq).run();
            subSeq.done(seq);
        }
        this.doneLatch.await(queuedCount);
    }

    @Override
    protected void buildTreeMap(SqlExecutionContext executionContext) {
        SqlExecutionCircuitBreaker circuitBreaker = executionContext.getCircuitBreaker();
        MessageBus bus = executionContext.getMessageBus();
        RingQueue<LatestByTask> queue = bus.getLatestByQueue();
        Sequence pubSeq = bus.getLatestByPubSeq();
        Sequence subSeq = bus.getLatestBySubSeq();
        int keyCount = this.getSymbolTable(this.columnIndex).getSymbolCount() + 1;
        this.rows.setCapacity(keyCount);
        GeoHashNative.iota(this.rows.getAddress(), this.rows.getCapacity(), 0L);
        int workerCount = executionContext.getSharedWorkerCount();
        long chunkSize = (keyCount + workerCount - 1) / workerCount;
        int taskCount = (int)(((long)keyCount + chunkSize - 1L) / chunkSize);
        long argumentsAddress = LatestByArguments.allocateMemoryArray(taskCount);
        for (long i = 0L; i < (long)taskCount; ++i) {
            long klo = i * chunkSize;
            long khi = Long.min(klo + chunkSize, keyCount);
            long argsAddress = argumentsAddress + i * 56L;
            LatestByArguments.setRowsAddress(argsAddress, this.rows.getAddress());
            LatestByArguments.setRowsCapacity(argsAddress, this.rows.getCapacity());
            LatestByArguments.setKeyLo(argsAddress, klo);
            LatestByArguments.setKeyHi(argsAddress, khi);
            LatestByArguments.setRowsSize(argsAddress, 0L);
        }
        int hashColumnIndex = -1;
        int hashColumnType = 0;
        this.sharedCircuitBreaker.reset();
        long prefixesAddress = 0L;
        long prefixesCount = 0L;
        if (this.prefixes.size() > 2L) {
            hashColumnIndex = (int)this.prefixes.get(0L);
            hashColumnType = (int)this.prefixes.get(1L);
            prefixesAddress = this.prefixes.getAddress() + 16L;
            prefixesCount = this.prefixes.size() - 2L;
        }
        int frameColumnIndex = this.columnIndexes.getQuick(this.columnIndex);
        TableReader reader = this.dataFrameCursor.getTableReader();
        long foundRowCount = 0L;
        int queuedCount = 0;
        try {
            DataFrame frame;
            while ((frame = this.dataFrameCursor.next()) != null && foundRowCount < (long)keyCount) {
                this.doneLatch.reset();
                BitmapIndexReader indexReader = frame.getBitmapIndexReader(frameColumnIndex, 2);
                long rowLo = frame.getRowLo();
                long rowHi = frame.getRowHi() - 1L;
                long keyBaseAddress = indexReader.getKeyBaseAddress();
                long keysMemorySize = indexReader.getKeyMemorySize();
                long valueBaseAddress = indexReader.getValueBaseAddress();
                long valuesMemorySize = indexReader.getValueMemorySize();
                int valueBlockCapacity = indexReader.getValueBlockCapacity();
                long unIndexedNullCount = indexReader.getUnIndexedNullCount();
                int partitionIndex = frame.getPartitionIndex();
                long hashColumnAddress = 0L;
                if (hashColumnIndex > -1) {
                    int columnBase = reader.getColumnBase(partitionIndex);
                    int primaryColumnIndex = TableReader.getPrimaryColumnIndex(columnBase, hashColumnIndex);
                    MemoryR column = reader.getColumn(primaryColumnIndex);
                    hashColumnAddress = column.getPageAddress(0);
                }
                int hashesColumnSize = ColumnType.isGeoHash(hashColumnType) ? LatestByAllIndexedRecordCursor.getPow2SizeOfGeoHashType(hashColumnType) : -1;
                queuedCount = 0;
                for (long i = 0L; i < (long)taskCount; ++i) {
                    long keyLo;
                    long keyHi;
                    long argsAddress = argumentsAddress + i * 56L;
                    long found = LatestByArguments.getRowsSize(argsAddress);
                    if (found >= (keyHi = LatestByArguments.getKeyHi(argsAddress)) - (keyLo = LatestByArguments.getKeyLo(argsAddress))) continue;
                    LatestByArguments.setHashesAddress(argsAddress, hashColumnAddress);
                    long seq = pubSeq.next();
                    if (seq < 0L) {
                        circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                        GeoHashNative.latestByAndFilterPrefix(keyBaseAddress, keysMemorySize, valueBaseAddress, valuesMemorySize, argsAddress, unIndexedNullCount, rowHi, rowLo, partitionIndex, valueBlockCapacity, hashColumnAddress, hashesColumnSize, prefixesAddress, prefixesCount);
                        continue;
                    }
                    queue.get(seq).of(keyBaseAddress, keysMemorySize, valueBaseAddress, valuesMemorySize, argsAddress, unIndexedNullCount, rowHi, rowLo, partitionIndex, valueBlockCapacity, hashColumnAddress, hashesColumnSize, prefixesAddress, prefixesCount, this.doneLatch, this.sharedCircuitBreaker);
                    pubSeq.done(seq);
                    ++queuedCount;
                }
                while (this.doneLatch.getCount() > -queuedCount) {
                    circuitBreaker.statefulThrowExceptionIfTrippedNoThrottle();
                    long seq = subSeq.next();
                    if (seq <= -1L) continue;
                    queue.get(seq).run();
                    subSeq.done(seq);
                }
                this.doneLatch.await(queuedCount);
                foundRowCount = 0L;
                for (int i = 0; i < taskCount; ++i) {
                    long address = argumentsAddress + (long)i * 56L;
                    foundRowCount += LatestByArguments.getRowsSize(address);
                }
            }
        }
        catch (Throwable t) {
            this.sharedCircuitBreaker.cancel();
            throw t;
        }
        finally {
            this.processTasks(circuitBreaker, queue, subSeq, queuedCount);
            if (this.sharedCircuitBreaker.isCanceled()) {
                LatestByArguments.releaseMemoryArray(argumentsAddress, taskCount);
            }
        }
        long rowCount = GeoHashNative.slideFoundBlocks(argumentsAddress, taskCount);
        LatestByArguments.releaseMemoryArray(argumentsAddress, taskCount);
        this.aLimit = rowCount;
        this.aIndex = 0L;
        this.postProcessRows();
    }

    protected void postProcessRows() {
        Vect.sortULongAscInPlace(this.rows.getAddress(), this.aLimit);
    }
}

