/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller.repository.io;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.nifi.controller.repository.io.MemoryManager;

public class ArrayManagedOutputStream
extends OutputStream {
    private final MemoryManager memoryManager;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.rwLock.readLock();
    private final Lock writeLock = this.rwLock.writeLock();
    private final List<byte[]> blocks = new ArrayList<byte[]>();
    private int currentIndex;
    private byte[] currentBlock;
    private long curSize;

    public ArrayManagedOutputStream(MemoryManager memoryManager) {
        this.memoryManager = memoryManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.writeLock.lock();
        try {
            int bytesForCur;
            int bytesFreeThisBlock;
            int n = bytesFreeThisBlock = this.currentBlock == null ? 0 : this.currentBlock.length - this.currentIndex;
            if (bytesFreeThisBlock >= len) {
                System.arraycopy(b, off, this.currentBlock, this.currentIndex, len);
                this.currentIndex += len;
                this.curSize += (long)len;
                return;
            }
            long bytesNeeded = len - bytesFreeThisBlock;
            int blocksNeeded = (int)(bytesNeeded / (long)this.memoryManager.getBlockSize());
            if ((long)(blocksNeeded * this.memoryManager.getBlockSize()) < bytesNeeded) {
                ++blocksNeeded;
            }
            ArrayList<byte[]> newBlocks = new ArrayList<byte[]>(blocksNeeded);
            for (int i = 0; i < blocksNeeded; ++i) {
                byte[] newBlock = this.memoryManager.checkOut();
                if (newBlock == null) {
                    this.memoryManager.checkIn(newBlocks);
                    throw new IOException("No space left in Content Repository");
                }
                newBlocks.add(newBlock);
            }
            long bytesCopied = 0L;
            int n2 = bytesForCur = this.currentBlock == null ? 0 : this.currentBlock.length - this.currentIndex;
            if (bytesForCur > 0) {
                System.arraycopy(b, off, this.currentBlock, this.currentIndex, bytesForCur);
                off += bytesForCur;
                bytesCopied += (long)bytesForCur;
                this.currentBlock = null;
                this.currentIndex = 0;
            }
            for (byte[] block : newBlocks) {
                int bytesToCopy = (int)Math.min((long)len - bytesCopied, (long)block.length);
                System.arraycopy(b, off, block, 0, bytesToCopy);
                this.currentIndex = bytesToCopy;
                this.currentBlock = block;
                off += bytesToCopy;
                bytesCopied += (long)bytesToCopy;
            }
            this.curSize += (long)len;
            this.blocks.addAll(newBlocks);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public void write(int b) throws IOException {
        byte[] bytes = new byte[]{(byte)(b & 0xFF)};
        this.write(bytes);
    }

    public void destroy() {
        this.writeLock.lock();
        try {
            this.memoryManager.checkIn(this.blocks);
            this.blocks.clear();
            this.currentBlock = null;
            this.currentIndex = 0;
            this.curSize = 0L;
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long size() {
        this.readLock.lock();
        try {
            long l = this.curSize;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void reset() {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(OutputStream out) throws IOException {
        this.readLock.lock();
        try {
            int i = 0;
            for (byte[] block : this.blocks) {
                if (++i == this.blocks.size()) {
                    if (this.currentIndex <= 0) continue;
                    out.write(block, 0, this.currentIndex);
                    continue;
                }
                out.write(block);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public int getBufferLength() {
        this.readLock.lock();
        try {
            if (this.currentBlock == null) {
                int n = 0;
                return n;
            }
            int n = this.blocks.size() * this.currentBlock.length;
            return n;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream newInputStream() {
        long totalSize;
        int blockSize;
        this.readLock.lock();
        try {
            if (this.blocks.isEmpty()) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(new byte[0]);
                return byteArrayInputStream;
            }
            blockSize = this.memoryManager.getBlockSize();
            totalSize = this.curSize;
        }
        finally {
            this.readLock.unlock();
        }
        return new InputStream(){
            int blockIndex = 0;
            int byteIndex = 0;
            long bytesRead = 0L;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read() throws IOException {
                ArrayManagedOutputStream.this.readLock.lock();
                try {
                    if (this.bytesRead >= totalSize) {
                        int n = -1;
                        return n;
                    }
                    if (this.byteIndex >= blockSize) {
                        ++this.blockIndex;
                        this.byteIndex = 0;
                    }
                    byte[] buffer = (byte[])ArrayManagedOutputStream.this.blocks.get(this.blockIndex);
                    int b = buffer[this.byteIndex++] & 0xFF;
                    ++this.bytesRead;
                    int n = b;
                    return n;
                }
                finally {
                    ArrayManagedOutputStream.this.readLock.unlock();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                ArrayManagedOutputStream.this.readLock.lock();
                try {
                    if (this.bytesRead >= totalSize) {
                        int n = -1;
                        return n;
                    }
                    if (this.byteIndex >= blockSize) {
                        ++this.blockIndex;
                        this.byteIndex = 0;
                    }
                    byte[] buffer = (byte[])ArrayManagedOutputStream.this.blocks.get(this.blockIndex);
                    long bytesUnread = totalSize - this.bytesRead;
                    int bytesToCopy = (int)Math.min(bytesUnread, (long)Math.min(len, buffer.length - this.byteIndex));
                    System.arraycopy(buffer, this.byteIndex, b, off, bytesToCopy);
                    this.byteIndex += bytesToCopy;
                    this.bytesRead += (long)bytesToCopy;
                    int n = bytesToCopy;
                    return n;
                }
                finally {
                    ArrayManagedOutputStream.this.readLock.unlock();
                }
            }
        };
    }
}

