/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.shell.command;

import java.util.Arrays;
import java.util.List;
import org.apache.nifi.diagnostics.bootstrap.shell.command.AbstractShellCommand;
import org.apache.nifi.diagnostics.bootstrap.shell.result.LineSplittingResult;

public class GetDiskLayoutCommand
extends AbstractShellCommand {
    private static final String COMMAND_NAME = "GetDiskLayout";
    private static final List<String> RESULT_LABELS = Arrays.asList("FileSystem/DeviceId", "Total size", "Used", "Free");
    private static final String REGEX_FOR_SPLITTING = "\\s+";
    private static final String[] GET_DISK_LAYOUT_FOR_MAC = new String[]{"/bin/sh", "-c", "df -Ph | sed 1d"};
    private static final String[] GET_DISK_LAYOUT_FOR_LINUX = new String[]{"/bin/sh", "-c", "df -h --output=source,size,used,avail,target -x tmpfs -x devtmpfs | sed 1d"};
    private static final String[] GET_DISK_LAYOUT_FOR_WINDOWS = new String[]{"powershell.exe", "Get-CIMInstance Win32_LogicalDisk | ft -hideTableHeaders DeviceId, @{n='Size/GB'; e={[math]::truncate($_.Size/1GB)}}, @{n='Used/GB'; e={[math]::truncate($_.Size/1GB - $_.FreeSpace/1GB)}}, @{n='FreeSpace/GB'; e={[math]::truncate($_.freespace/1GB)}}, VolumeName"};

    public GetDiskLayoutCommand() {
        super(COMMAND_NAME, GET_DISK_LAYOUT_FOR_WINDOWS, GET_DISK_LAYOUT_FOR_LINUX, GET_DISK_LAYOUT_FOR_MAC, new LineSplittingResult(REGEX_FOR_SPLITTING, RESULT_LABELS, COMMAND_NAME));
    }
}

