/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.diagnostics.bootstrap.shell.result;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.nifi.diagnostics.bootstrap.shell.result.ShellCommandResult;

public class LineSplittingResult
implements ShellCommandResult {
    private final Pattern regexForSplitting;
    private final List<String> labels;
    private final String commandName;

    public LineSplittingResult(String regexStringForSplitting, List<String> labels, String commandName) {
        this.regexForSplitting = Pattern.compile(regexStringForSplitting);
        this.labels = labels;
        this.commandName = commandName;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Collection<String> createResult(InputStream inputStream) {
        ArrayList<String> result = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.isEmpty()) continue;
                String[] splitResults = this.regexForSplitting.split(line);
                for (int i = 0; i < this.labels.size(); ++i) {
                    result.add(String.format("%s : %s", this.labels.get(i), splitResults[i]));
                }
            }
            ArrayList<String> arrayList = result;
            return arrayList;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to process result for command: %s", this.commandName), e);
        }
    }
}

