/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.remote.protocol;

import java.io.DataInputStream;
import java.io.IOException;
import org.apache.nifi.remote.exception.ProtocolException;
import org.apache.nifi.remote.protocol.ResponseCode;

public class Response {
    private final ResponseCode code;
    private final String message;

    private Response(ResponseCode code, String explanation) {
        this.code = code;
        this.message = explanation;
    }

    public ResponseCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public static Response read(DataInputStream in) throws IOException, ProtocolException {
        ResponseCode code = ResponseCode.readCode(in);
        String message = code.containsMessage() ? in.readUTF() : null;
        return new Response(code, message);
    }

    public String toString() {
        return (Object)((Object)this.code) + ": " + this.message;
    }
}

