/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.c2.protocol.component.api;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.nifi.c2.protocol.component.api.DefinedType;
import org.apache.nifi.c2.protocol.component.api.PropertyAllowableValue;
import org.apache.nifi.c2.protocol.component.api.PropertyDependency;
import org.apache.nifi.c2.protocol.component.api.PropertyResourceDefinition;
import org.apache.nifi.expression.ExpressionLanguageScope;

@ApiModel
public class PropertyDescriptor
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String displayName;
    private String description;
    private List<PropertyAllowableValue> allowableValues;
    private String defaultValue;
    private boolean required;
    private boolean sensitive;
    private ExpressionLanguageScope expressionLanguageScope = ExpressionLanguageScope.NONE;
    private String expressionLanguageScopeDescription = ExpressionLanguageScope.NONE.getDescription();
    private DefinedType typeProvidedByValue;
    private String validRegex;
    private String validator;
    private boolean dynamic;
    private PropertyResourceDefinition resourceDefinition;
    private List<PropertyDependency> dependencies;

    @ApiModelProperty(value="The name of the property key", required=true)
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="The display name of the property key, if different from the name")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @ApiModelProperty(value="The description of what the property does")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @ApiModelProperty(value="A list of the allowable values for the property")
    public List<PropertyAllowableValue> getAllowableValues() {
        return this.allowableValues != null ? Collections.unmodifiableList(this.allowableValues) : null;
    }

    public void setAllowableValues(List<PropertyAllowableValue> allowableValues) {
        this.allowableValues = allowableValues;
    }

    @ApiModelProperty(value="The default value if a user-set value is not specified")
    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    @ApiModelProperty(value="Whether or not  the property is required for the component")
    public boolean getRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @ApiModelProperty(value="Whether or not  the value of the property is considered sensitive (e.g., passwords and keys)")
    public boolean getSensitive() {
        return this.sensitive;
    }

    public void setSensitive(boolean sensitive) {
        this.sensitive = sensitive;
    }

    @ApiModelProperty(value="The scope of expression language supported by this property")
    public ExpressionLanguageScope getExpressionLanguageScope() {
        return this.expressionLanguageScope;
    }

    public void setExpressionLanguageScope(ExpressionLanguageScope expressionLanguageScope) {
        this.expressionLanguageScope = expressionLanguageScope;
        this.expressionLanguageScopeDescription = expressionLanguageScope == null ? null : expressionLanguageScope.getDescription();
    }

    @ApiModelProperty(value="The description of the expression language scope supported by this property", readOnly=true)
    public String getExpressionLanguageScopeDescription() {
        return this.expressionLanguageScope == null ? null : this.expressionLanguageScope.getDescription();
    }

    @ApiModelProperty(value="Indicates that this property is for selecting a controller service of the specified type")
    public DefinedType getTypeProvidedByValue() {
        return this.typeProvidedByValue;
    }

    public void setTypeProvidedByValue(DefinedType typeProvidedByValue) {
        this.typeProvidedByValue = typeProvidedByValue;
    }

    @ApiModelProperty(value="A regular expression that can be used to validate the value of this property")
    public String getValidRegex() {
        return this.validRegex;
    }

    public void setValidRegex(String validRegex) {
        this.validRegex = validRegex;
    }

    @ApiModelProperty(value="Name of the validator used for this property descriptor")
    public String getValidator() {
        return this.validator;
    }

    public void setValidator(String validator) {
        this.validator = validator;
    }

    @ApiModelProperty(value="Whether or not the descriptor is for a dynamically added property")
    public boolean isDynamic() {
        return this.dynamic;
    }

    public void setDynamic(boolean dynamic) {
        this.dynamic = dynamic;
    }

    @ApiModelProperty(value="Indicates that this property references external resources")
    public PropertyResourceDefinition getResourceDefinition() {
        return this.resourceDefinition;
    }

    public void setResourceDefinition(PropertyResourceDefinition resourceDefinition) {
        this.resourceDefinition = resourceDefinition;
    }

    @ApiModelProperty(value="The dependencies that this property has on other properties")
    public List<PropertyDependency> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(List<PropertyDependency> dependencies) {
        this.dependencies = dependencies;
    }
}

