/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.client.impl;

import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

public class ClientUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File getExtensionBundleVersionContent(Response response, File outputDirectory) {
        String contentDispositionHeader = response.getHeaderString("Content-Disposition");
        if (StringUtils.isBlank((CharSequence)contentDispositionHeader)) {
            throw new IllegalStateException("Content-Disposition header was blank or missing");
        }
        int equalsIndex = contentDispositionHeader.lastIndexOf("=");
        String filename = contentDispositionHeader.substring(equalsIndex + 1).trim();
        File bundleFile = new File(outputDirectory, filename);
        try (InputStream responseInputStream = (InputStream)response.readEntity(InputStream.class);){
            Files.copy(responseInputStream, bundleFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            File file = bundleFile;
            return file;
        }
        catch (Exception e) {
            throw new IllegalStateException("Unable to write bundle content due to: " + e.getMessage(), e);
        }
    }
}

