/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.table;

import v14.h2.engine.Session;
import v14.h2.expression.Expression;
import v14.h2.expression.function.FunctionCall;
import v14.h2.expression.function.TableFunction;
import v14.h2.message.DbException;
import v14.h2.result.ResultInterface;
import v14.h2.schema.Schema;
import v14.h2.table.Column;
import v14.h2.table.VirtualConstructedTable;
import v14.h2.value.Value;
import v14.h2.value.ValueNull;
import v14.h2.value.ValueResultSet;

public class FunctionTable
extends VirtualConstructedTable {
    private final FunctionCall function;
    private final long rowCount;
    private Expression functionExpr;

    public FunctionTable(Schema schema, Session session, Expression expression, FunctionCall functionCall) {
        super(schema, 0, functionCall.getName());
        this.functionExpr = expression;
        this.function = functionCall;
        this.rowCount = functionCall instanceof TableFunction ? ((TableFunction)functionCall).getRowCount() : Long.MAX_VALUE;
        functionCall.optimize(session);
        int n = functionCall.getValueType();
        if (n != 18) {
            throw DbException.get(90000, functionCall.getName());
        }
        Expression[] expressionArray = functionCall.getArgs();
        int n2 = expressionArray.length;
        Expression[] expressionArray2 = new Expression[n2];
        for (int i = 0; i < n2; ++i) {
            expressionArray[i] = expressionArray[i].optimize(session);
            expressionArray2[i] = expressionArray[i];
        }
        ValueResultSet valueResultSet = functionCall.getValueForColumnList(session, expressionArray2);
        if (valueResultSet == null) {
            throw DbException.get(90000, functionCall.getName());
        }
        ResultInterface resultInterface = valueResultSet.getResult();
        int n3 = resultInterface.getVisibleColumnCount();
        Column[] columnArray = new Column[n3];
        for (int i = 0; i < n3; ++i) {
            columnArray[i] = new Column(resultInterface.getColumnName(i), resultInterface.getColumnType(i));
        }
        this.setColumns(columnArray);
    }

    @Override
    public boolean canGetRowCount() {
        return this.rowCount != Long.MAX_VALUE;
    }

    @Override
    public long getRowCount(Session session) {
        return this.rowCount;
    }

    @Override
    public long getRowCountApproximation() {
        return this.rowCount;
    }

    @Override
    public ResultInterface getResult(Session session) {
        this.functionExpr = this.functionExpr.optimize(session);
        Value value = this.functionExpr.getValue(session);
        if (value == ValueNull.INSTANCE) {
            return null;
        }
        return ((ValueResultSet)value).getResult();
    }

    @Override
    public String getSQL(boolean bl) {
        return this.function.getSQL(bl);
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder, boolean bl) {
        return stringBuilder.append(this.function.getSQL(bl));
    }

    @Override
    public boolean isDeterministic() {
        return this.function.isDeterministic();
    }
}

