/*
 * Decompiled with CFR 0.152.
 */
package v14.h2.value;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import v14.h2.engine.CastDataProvider;
import v14.h2.engine.SysProperties;
import v14.h2.message.DbException;
import v14.h2.store.DataHandler;
import v14.h2.store.FileStore;
import v14.h2.store.FileStoreInputStream;
import v14.h2.store.RangeInputStream;
import v14.h2.store.RangeReader;
import v14.h2.store.fs.FileUtils;
import v14.h2.util.IOUtils;
import v14.h2.util.MathUtils;
import v14.h2.util.SmallLRUCache;
import v14.h2.util.StringUtils;
import v14.h2.util.Utils;
import v14.h2.value.CompareMode;
import v14.h2.value.ExtTypeInfo;
import v14.h2.value.TypeInfo;
import v14.h2.value.Value;
import v14.h2.value.ValueLobDb;

public class ValueLob
extends Value {
    private static final int BLOCK_COMPARISON_SIZE = 512;
    private static int dirCounter;
    private final int valueType;
    private TypeInfo type;
    private final long precision;
    private final DataHandler handler;
    private int tableId;
    private final int objectId;
    private String fileName;
    private boolean linked;
    private int hash;
    private final boolean compressed;

    private static void rangeCheckUnknown(long l, long l2) {
        if (l < 0L) {
            throw DbException.getInvalidValueException("offset", l + 1L);
        }
        if (l2 < 0L) {
            throw DbException.getInvalidValueException("length", l2);
        }
    }

    static InputStream rangeInputStream(InputStream inputStream, long l, long l2, long l3) {
        if (l3 > 0L) {
            ValueLob.rangeCheck(l - 1L, l2, l3);
        } else {
            ValueLob.rangeCheckUnknown(l - 1L, l2);
        }
        try {
            return new RangeInputStream(inputStream, l - 1L, l2);
        }
        catch (IOException iOException) {
            throw DbException.getInvalidValueException("offset", l);
        }
    }

    static Reader rangeReader(Reader reader, long l, long l2, long l3) {
        if (l3 > 0L) {
            ValueLob.rangeCheck(l - 1L, l2, l3);
        } else {
            ValueLob.rangeCheckUnknown(l - 1L, l2);
        }
        try {
            return new RangeReader(reader, l - 1L, l2);
        }
        catch (IOException iOException) {
            throw DbException.getInvalidValueException("offset", l);
        }
    }

    /*
     * Exception decompiling
     */
    static int compare(Value var0, Value var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 84[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private ValueLob(int n, DataHandler dataHandler, String string, int n2, int n3, boolean bl, long l, boolean bl2) {
        this.valueType = n;
        this.handler = dataHandler;
        this.fileName = string;
        this.tableId = n2;
        this.objectId = n3;
        this.linked = bl;
        this.precision = l;
        this.compressed = bl2;
    }

    private static String getFileName(DataHandler dataHandler, int n, int n2) {
        if (n == 0 && n2 == 0) {
            DbException.throwInternalError("0 LOB");
        }
        String string = n < 0 ? ".temp" : ".t" + n;
        return ValueLob.getFileNamePrefix(dataHandler.getDatabasePath(), n2) + string + ".lob.db";
    }

    public static ValueLob openLinked(int n, DataHandler dataHandler, int n2, int n3, long l, boolean bl) {
        String string = ValueLob.getFileName(dataHandler, n2, n3);
        return new ValueLob(n, dataHandler, string, n2, n3, true, l, bl);
    }

    public static ValueLob openUnlinked(int n, DataHandler dataHandler, int n2, int n3, long l, boolean bl, String string) {
        return new ValueLob(n, dataHandler, string, n2, n3, false, l, bl);
    }

    private static String getFileNamePrefix(String string, int n) {
        int n2 = n % SysProperties.LOB_FILES_PER_DIRECTORY;
        String string2 = n2 > 0 ? SysProperties.FILE_SEPARATOR + n : "";
        n /= SysProperties.LOB_FILES_PER_DIRECTORY;
        while (n > 0) {
            n2 = n % SysProperties.LOB_FILES_PER_DIRECTORY;
            string2 = SysProperties.FILE_SEPARATOR + n2 + ".lobs.db" + string2;
            n /= SysProperties.LOB_FILES_PER_DIRECTORY;
        }
        string2 = FileUtils.toRealPath(string + ".lobs.db" + string2);
        return string2;
    }

    private static int getNewObjectId(DataHandler dataHandler) {
        int n;
        String string;
        String string2 = dataHandler.getDatabasePath();
        if (string2 != null && string2.isEmpty()) {
            string2 = new File(Utils.getProperty("java.io.tmpdir", "."), SysProperties.PREFIX_TEMP_FILE).getAbsolutePath();
        }
        int n2 = 0;
        int n3 = SysProperties.LOB_FILES_PER_DIRECTORY;
        while (true) {
            string = ValueLob.getFileNamePrefix(string2, n2);
            String[] stringArray = ValueLob.getFileList(dataHandler, string);
            int n4 = 0;
            boolean[] blArray = new boolean[n3];
            String[] stringArray2 = stringArray;
            int n5 = stringArray2.length;
            for (int i = 0; i < n5; ++i) {
                int n6;
                String string3 = stringArray2[i];
                if (!string3.endsWith(".db")) continue;
                string3 = FileUtils.getName(string3);
                String string4 = string3.substring(0, string3.indexOf(46));
                try {
                    n6 = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    n6 = -1;
                }
                if (n6 <= 0) continue;
                ++n4;
                blArray[n6 % n3] = true;
            }
            n = -1;
            if (n4 < n3) {
                for (n5 = 1; n5 < n3; ++n5) {
                    if (blArray[n5]) continue;
                    n = n5;
                    break;
                }
            }
            if (n > 0) break;
            if (n2 > Integer.MAX_VALUE / n3) {
                n2 = 0;
                dirCounter = MathUtils.randomInt(n3 - 1) * n3;
                continue;
            }
            n5 = dirCounter++ / (n3 - 1) + 1;
            n2 *= n3;
            n2 += n5 * n3;
        }
        ValueLob.invalidateFileList(dataHandler, string);
        return n2 += n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void invalidateFileList(DataHandler dataHandler, String string) {
        SmallLRUCache<String, String[]> smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache != null) {
            SmallLRUCache<String, String[]> smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                smallLRUCache.remove(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String[] getFileList(DataHandler dataHandler, String string) {
        String[] stringArray;
        SmallLRUCache<String, String[]> smallLRUCache = dataHandler.getLobFileListCache();
        if (smallLRUCache == null) {
            stringArray = FileUtils.newDirectoryStream(string).toArray(new String[0]);
        } else {
            SmallLRUCache<String, String[]> smallLRUCache2 = smallLRUCache;
            synchronized (smallLRUCache2) {
                stringArray = (String[])smallLRUCache.get(string);
                if (stringArray == null) {
                    stringArray = FileUtils.newDirectoryStream(string).toArray(new String[0]);
                    smallLRUCache.put(string, stringArray);
                }
            }
        }
        return stringArray;
    }

    @Override
    protected Value convertTo(int n, ExtTypeInfo extTypeInfo, CastDataProvider castDataProvider, boolean bl, Object object) {
        if (n == this.valueType) {
            return this;
        }
        if (n == 16) {
            return ValueLobDb.createTempClob(this.getReader(), -1L, this.handler);
        }
        if (n == 15) {
            return ValueLobDb.createTempBlob(this.getInputStream(), -1L, this.handler);
        }
        return super.convertTo(n, null, castDataProvider, bl, object);
    }

    @Override
    public boolean isLinkedToTable() {
        return this.linked;
    }

    public String getFileName() {
        return this.fileName;
    }

    @Override
    public void remove() {
        ValueLob.deleteFile(this.handler, this.fileName);
    }

    @Override
    public Value copy(DataHandler dataHandler, int n) {
        if (this.linked) {
            ValueLob valueLob = new ValueLob(this.valueType, this.handler, this.fileName, this.tableId, ValueLob.getNewObjectId(dataHandler), this.linked, this.precision, this.compressed);
            valueLob.hash = this.hash;
            valueLob.tableId = n;
            String string = ValueLob.getFileName(dataHandler, valueLob.tableId, valueLob.objectId);
            ValueLob.copyFileTo(dataHandler, this.fileName, string);
            valueLob.fileName = string;
            valueLob.linked = true;
            return valueLob;
        }
        if (!this.linked) {
            this.tableId = n;
            String string = ValueLob.getFileName(dataHandler, this.tableId, this.objectId);
            ValueLob.renameFile(dataHandler, this.fileName, string);
            this.fileName = string;
            this.linked = true;
        }
        return this;
    }

    @Override
    public int getTableId() {
        return this.tableId;
    }

    public int getObjectId() {
        return this.objectId;
    }

    @Override
    public TypeInfo getType() {
        TypeInfo typeInfo = this.type;
        if (typeInfo == null) {
            this.type = typeInfo = new TypeInfo(this.valueType, this.precision, 0, MathUtils.convertLongToInt(this.precision), null);
        }
        return typeInfo;
    }

    @Override
    public int getValueType() {
        return this.valueType;
    }

    @Override
    public String getString() {
        int n = this.precision > Integer.MAX_VALUE || this.precision == 0L ? Integer.MAX_VALUE : (int)this.precision;
        try {
            if (this.valueType == 16) {
                return IOUtils.readStringAndClose(this.getReader(), n);
            }
            byte[] byArray = IOUtils.readBytesAndClose(this.getInputStream(), n);
            return StringUtils.convertBytesToHex(byArray);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.fileName);
        }
    }

    @Override
    public byte[] getBytes() {
        if (this.valueType == 16) {
            return super.getBytes();
        }
        byte[] byArray = this.getBytesNoCopy();
        return Utils.cloneByteArray(byArray);
    }

    @Override
    public byte[] getBytesNoCopy() {
        if (this.valueType == 16) {
            return super.getBytesNoCopy();
        }
        try {
            return IOUtils.readBytesAndClose(this.getInputStream(), Integer.MAX_VALUE);
        }
        catch (IOException iOException) {
            throw DbException.convertIOException(iOException, this.fileName);
        }
    }

    @Override
    public int hashCode() {
        if (this.hash == 0) {
            if (this.precision > 4096L) {
                return (int)(this.precision ^ this.precision >>> 32);
            }
            this.hash = this.valueType == 16 ? this.getString().hashCode() : Utils.getByteArrayHash(this.getBytes());
        }
        return this.hash;
    }

    @Override
    public int compareTypeSafe(Value value, CompareMode compareMode, CastDataProvider castDataProvider) {
        return ValueLob.compare(this, value);
    }

    @Override
    public Object getObject() {
        if (this.valueType == 16) {
            return this.getReader();
        }
        return this.getInputStream();
    }

    @Override
    public Reader getReader() {
        return IOUtils.getBufferedReader(this.getInputStream());
    }

    @Override
    public Reader getReader(long l, long l2) {
        return ValueLob.rangeReader(this.getReader(), l, l2, this.valueType == 16 ? this.precision : -1L);
    }

    @Override
    public InputStream getInputStream() {
        FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
        boolean bl = SysProperties.lobCloseBetweenReads;
        return new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, this.compressed, bl), 4096);
    }

    @Override
    public InputStream getInputStream(long l, long l2) {
        FileStore fileStore = this.handler.openFile(this.fileName, "r", true);
        boolean bl = SysProperties.lobCloseBetweenReads;
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileStoreInputStream(fileStore, this.handler, this.compressed, bl), 4096);
        return ValueLob.rangeInputStream(bufferedInputStream, l, l2, fileStore.length());
    }

    @Override
    public void set(PreparedStatement preparedStatement, int n) throws SQLException {
        long l = this.precision;
        if (l > Integer.MAX_VALUE || l <= 0L) {
            l = -1L;
        }
        if (this.valueType == 15) {
            preparedStatement.setBinaryStream(n, this.getInputStream(), (int)l);
        } else {
            preparedStatement.setCharacterStream(n, this.getReader(), (int)l);
        }
    }

    @Override
    public StringBuilder getSQL(StringBuilder stringBuilder) {
        if (this.valueType == 16) {
            StringUtils.quoteStringSQL(stringBuilder, this.getString());
        } else {
            stringBuilder.append("X'");
            StringUtils.convertBytesToHex(stringBuilder, this.getBytes()).append('\'');
        }
        return stringBuilder;
    }

    @Override
    public String getTraceSQL() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.valueType == 16) {
            stringBuilder.append("SPACE(").append(this.precision);
        } else {
            stringBuilder.append("CAST(REPEAT('00', ").append(this.precision).append(") AS BINARY");
        }
        stringBuilder.append(" /* ").append(this.fileName).append(" */)");
        return stringBuilder.toString();
    }

    @Override
    public byte[] getSmall() {
        return null;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof ValueLob) {
            ValueLob valueLob = (ValueLob)object;
            return this.valueType == valueLob.valueType && this.compareTypeSafe(valueLob, null, null) == 0;
        }
        return false;
    }

    public boolean isCompressed() {
        return this.compressed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void deleteFile(DataHandler dataHandler, String string) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileUtils.delete(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void renameFile(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            FileUtils.move(string, string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFileTo(DataHandler dataHandler, String string, String string2) {
        Object object = dataHandler.getLobSyncObject();
        synchronized (object) {
            try {
                IOUtils.copyFiles(string, string2);
            }
            catch (IOException iOException) {
                throw DbException.convertIOException(iOException, null);
            }
        }
    }

    @Override
    public int getMemory() {
        return 140;
    }

    @Override
    public ValueLobDb copyToTemp() {
        ValueLobDb valueLobDb = this.valueType == 16 ? ValueLobDb.createTempClob(this.getReader(), this.precision, this.handler) : ValueLobDb.createTempBlob(this.getInputStream(), this.precision, this.handler);
        return valueLobDb;
    }

    @Override
    public Value convertPrecision(long l) {
        if (this.precision <= l) {
            return this;
        }
        ValueLobDb valueLobDb = this.valueType == 16 ? ValueLobDb.createTempClob(this.getReader(), l, this.handler) : ValueLobDb.createTempBlob(this.getInputStream(), l, this.handler);
        return valueLobDb;
    }
}

