/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.properties;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.properties.ApplicationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NiFiRegistryProperties
extends ApplicationProperties {
    private static final Logger logger = LoggerFactory.getLogger(NiFiRegistryProperties.class);
    public static final String NIFI_REGISTRY_PROPERTIES_FILE_PATH_PROPERTY = "nifi.registry.properties.file.path";
    public static final String NIFI_REGISTRY_BOOTSTRAP_FILE_PATH_PROPERTY = "nifi.registry.bootstrap.config.file.path";
    public static final String NIFI_REGISTRY_BOOTSTRAP_DOCS_DIR_PROPERTY = "nifi.registry.bootstrap.config.docs.dir";
    public static final String RELATIVE_BOOTSTRAP_FILE_LOCATION = "conf/bootstrap.conf";
    public static final String RELATIVE_PROPERTIES_FILE_LOCATION = "conf/nifi-registry.properties";
    public static final String RELATIVE_DOCS_LOCATION = "docs";
    public static final String PROPERTIES_FILE_PATH = "nifi.registry.properties.file.path";
    public static final String WEB_WAR_DIR = "nifi.registry.web.war.directory";
    public static final String WEB_HTTP_PORT = "nifi.registry.web.http.port";
    public static final String WEB_HTTP_HOST = "nifi.registry.web.http.host";
    public static final String WEB_HTTPS_PORT = "nifi.registry.web.https.port";
    public static final String WEB_HTTPS_HOST = "nifi.registry.web.https.host";
    public static final String WEB_HTTPS_CIPHERSUITES_INCLUDE = "nifi.registry.web.https.ciphersuites.include";
    public static final String WEB_HTTPS_CIPHERSUITES_EXCLUDE = "nifi.registry.web.https.ciphersuites.exclude";
    public static final String WEB_HTTPS_APPLICATION_PROTOCOLS = "nifi.registry.web.https.application.protocols";
    public static final String WEB_WORKING_DIR = "nifi.registry.web.jetty.working.directory";
    public static final String WEB_THREADS = "nifi.registry.web.jetty.threads";
    public static final String WEB_SHOULD_SEND_SERVER_VERSION = "nifi.registry.web.should.send.server.version";
    public static final String SECURITY_KEYSTORE = "nifi.registry.security.keystore";
    public static final String SECURITY_KEYSTORE_TYPE = "nifi.registry.security.keystoreType";
    public static final String SECURITY_KEYSTORE_PASSWD = "nifi.registry.security.keystorePasswd";
    public static final String SECURITY_KEY_PASSWD = "nifi.registry.security.keyPasswd";
    public static final String SECURITY_TRUSTSTORE = "nifi.registry.security.truststore";
    public static final String SECURITY_TRUSTSTORE_TYPE = "nifi.registry.security.truststoreType";
    public static final String SECURITY_TRUSTSTORE_PASSWD = "nifi.registry.security.truststorePasswd";
    public static final String SECURITY_NEED_CLIENT_AUTH = "nifi.registry.security.needClientAuth";
    public static final String SECURITY_AUTHORIZERS_CONFIGURATION_FILE = "nifi.registry.security.authorizers.configuration.file";
    public static final String SECURITY_AUTHORIZER = "nifi.registry.security.authorizer";
    public static final String SECURITY_IDENTITY_PROVIDERS_CONFIGURATION_FILE = "nifi.registry.security.identity.providers.configuration.file";
    public static final String SECURITY_IDENTITY_PROVIDER = "nifi.registry.security.identity.provider";
    public static final String SECURITY_IDENTITY_MAPPING_PATTERN_PREFIX = "nifi.registry.security.identity.mapping.pattern.";
    public static final String SECURITY_IDENTITY_MAPPING_VALUE_PREFIX = "nifi.registry.security.identity.mapping.value.";
    public static final String SECURITY_IDENTITY_MAPPING_TRANSFORM_PREFIX = "nifi.registry.security.identity.mapping.transform.";
    public static final String SECURITY_GROUP_MAPPING_PATTERN_PREFIX = "nifi.registry.security.group.mapping.pattern.";
    public static final String SECURITY_GROUP_MAPPING_VALUE_PREFIX = "nifi.registry.security.group.mapping.value.";
    public static final String SECURITY_GROUP_MAPPING_TRANSFORM_PREFIX = "nifi.registry.security.group.mapping.transform.";
    public static final String EXTENSION_DIR_PREFIX = "nifi.registry.extension.dir.";
    public static final String PROVIDERS_CONFIGURATION_FILE = "nifi.registry.providers.configuration.file";
    public static final String REGISTRY_ALIAS_CONFIGURATION_FILE = "nifi.registry.registry.alias.configuration.file";
    public static final String EXTENSIONS_WORKING_DIR = "nifi.registry.extensions.working.directory";
    public static final String DATABASE_DIRECTORY = "nifi.registry.db.directory";
    public static final String DATABASE_URL_APPEND = "nifi.registry.db.url.append";
    public static final String DATABASE_URL = "nifi.registry.db.url";
    public static final String DATABASE_DRIVER_CLASS_NAME = "nifi.registry.db.driver.class";
    public static final String DATABASE_DRIVER_DIR = "nifi.registry.db.driver.directory";
    public static final String DATABASE_USERNAME = "nifi.registry.db.username";
    public static final String DATABASE_PASSWORD = "nifi.registry.db.password";
    public static final String DATABASE_MAX_CONNECTIONS = "nifi.registry.db.maxConnections";
    public static final String DATABASE_SQL_DEBUG = "nifi.registry.db.sql.debug";
    public static final String KERBEROS_KRB5_FILE = "nifi.registry.kerberos.krb5.file";
    public static final String KERBEROS_SPNEGO_PRINCIPAL = "nifi.registry.kerberos.spnego.principal";
    public static final String KERBEROS_SPNEGO_KEYTAB_LOCATION = "nifi.registry.kerberos.spnego.keytab.location";
    public static final String KERBEROS_SPNEGO_AUTHENTICATION_EXPIRATION = "nifi.registry.kerberos.spnego.authentication.expiration";
    public static final String KERBEROS_SERVICE_PRINCIPAL = "nifi.registry.kerberos.service.principal";
    public static final String KERBEROS_SERVICE_KEYTAB_LOCATION = "nifi.registry.kerberos.service.keytab.location";
    public static final String SECURITY_USER_OIDC_DISCOVERY_URL = "nifi.registry.security.user.oidc.discovery.url";
    public static final String SECURITY_USER_OIDC_CONNECT_TIMEOUT = "nifi.registry.security.user.oidc.connect.timeout";
    public static final String SECURITY_USER_OIDC_READ_TIMEOUT = "nifi.registry.security.user.oidc.read.timeout";
    public static final String SECURITY_USER_OIDC_CLIENT_ID = "nifi.registry.security.user.oidc.client.id";
    public static final String SECURITY_USER_OIDC_CLIENT_SECRET = "nifi.registry.security.user.oidc.client.secret";
    public static final String SECURITY_USER_OIDC_PREFERRED_JWSALGORITHM = "nifi.registry.security.user.oidc.preferred.jwsalgorithm";
    public static final String SECURITY_USER_OIDC_ADDITIONAL_SCOPES = "nifi.registry.security.user.oidc.additional.scopes";
    public static final String SECURITY_USER_OIDC_CLAIM_IDENTIFYING_USER = "nifi.registry.security.user.oidc.claim.identifying.user";
    public static final String REVISIONS_ENABLED = "nifi.registry.revisions.enabled";
    public static final String DEFAULT_WEB_WORKING_DIR = "./work/jetty";
    public static final String DEFAULT_WEB_HTTPS_APPLICATION_PROTOCOLS = "http/1.1";
    public static final String DEFAULT_WAR_DIR = "./lib";
    public static final String DEFAULT_PROVIDERS_CONFIGURATION_FILE = "./conf/providers.xml";
    public static final String DEFAULT_REGISTRY_ALIAS_CONFIGURATION_FILE = "./conf/registry-aliases.xml";
    public static final String DEFAULT_SECURITY_AUTHORIZERS_CONFIGURATION_FILE = "./conf/authorizers.xml";
    public static final String DEFAULT_SECURITY_IDENTITY_PROVIDER_CONFIGURATION_FILE = "./conf/identity-providers.xml";
    public static final String DEFAULT_AUTHENTICATION_EXPIRATION = "12 hours";
    public static final String DEFAULT_EXTENSIONS_WORKING_DIR = "./work/extensions";
    public static final String DEFAULT_WEB_SHOULD_SEND_SERVER_VERSION = "true";
    public static final String DEFAULT_SECURITY_USER_OIDC_CONNECT_TIMEOUT = "5 secs";
    public static final String DEFAULT_SECURITY_USER_OIDC_READ_TIMEOUT = "5 secs";

    public NiFiRegistryProperties() {
        this(Collections.EMPTY_MAP);
    }

    public NiFiRegistryProperties(Map<String, String> props) {
        super(props);
    }

    public NiFiRegistryProperties(Properties props) {
        super(props);
    }

    public int getWebThreads() {
        int webThreads = 200;
        try {
            webThreads = Integer.parseInt(this.getProperty(WEB_THREADS));
        }
        catch (NumberFormatException nfe) {
            logger.warn(String.format("%s must be an integer value. Defaulting to %s", WEB_THREADS, webThreads));
        }
        return webThreads;
    }

    public Integer getPort() {
        return this.getPropertyAsInteger(WEB_HTTP_PORT);
    }

    public String getHttpHost() {
        return this.getProperty(WEB_HTTP_HOST);
    }

    public Integer getSslPort() {
        return this.getPropertyAsInteger(WEB_HTTPS_PORT);
    }

    public boolean isHTTPSConfigured() {
        return this.getSslPort() != null;
    }

    public boolean shouldSendServerVersion() {
        return Boolean.parseBoolean(this.getProperty(WEB_SHOULD_SEND_SERVER_VERSION, DEFAULT_WEB_SHOULD_SEND_SERVER_VERSION));
    }

    public String getHttpsHost() {
        return this.getProperty(WEB_HTTPS_HOST);
    }

    public String getHttpsCipherSuitesInclude() {
        return this.getProperty(WEB_HTTPS_CIPHERSUITES_INCLUDE);
    }

    public String getHttpsCipherSuitesExclude() {
        return this.getProperty(WEB_HTTPS_CIPHERSUITES_EXCLUDE);
    }

    public boolean getNeedClientAuth() {
        boolean needClientAuth = true;
        String rawNeedClientAuth = this.getProperty(SECURITY_NEED_CLIENT_AUTH);
        if ("false".equalsIgnoreCase(rawNeedClientAuth)) {
            needClientAuth = false;
        }
        return needClientAuth;
    }

    public String getKeyStorePath() {
        return this.getProperty(SECURITY_KEYSTORE);
    }

    public String getKeyStoreType() {
        return this.getProperty(SECURITY_KEYSTORE_TYPE);
    }

    public String getKeyStorePassword() {
        return this.getProperty(SECURITY_KEYSTORE_PASSWD);
    }

    public String getKeyPassword() {
        return this.getProperty(SECURITY_KEY_PASSWD);
    }

    public String getTrustStorePath() {
        return this.getProperty(SECURITY_TRUSTSTORE);
    }

    public String getTrustStoreType() {
        return this.getProperty(SECURITY_TRUSTSTORE_TYPE);
    }

    public String getTrustStorePassword() {
        return this.getProperty(SECURITY_TRUSTSTORE_PASSWD);
    }

    public File getWarLibDirectory() {
        return new File(this.getProperty(WEB_WAR_DIR, DEFAULT_WAR_DIR));
    }

    public File getWebWorkingDirectory() {
        return new File(this.getProperty(WEB_WORKING_DIR, DEFAULT_WEB_WORKING_DIR));
    }

    public Set<String> getWebHttpsApplicationProtocols() {
        String protocols = this.getProperty(WEB_HTTPS_APPLICATION_PROTOCOLS, DEFAULT_WEB_HTTPS_APPLICATION_PROTOCOLS);
        return Arrays.stream(protocols.split("\\s+")).collect(Collectors.toSet());
    }

    public File getExtensionsWorkingDirectory() {
        return new File(this.getProperty(EXTENSIONS_WORKING_DIR, DEFAULT_EXTENSIONS_WORKING_DIR));
    }

    public File getProvidersConfigurationFile() {
        return this.getPropertyAsFile(PROVIDERS_CONFIGURATION_FILE, DEFAULT_PROVIDERS_CONFIGURATION_FILE);
    }

    public File getRegistryAliasConfigurationFile() {
        return this.getPropertyAsFile(REGISTRY_ALIAS_CONFIGURATION_FILE, DEFAULT_REGISTRY_ALIAS_CONFIGURATION_FILE);
    }

    public String getLegacyDatabaseDirectory() {
        return this.getProperty(DATABASE_DIRECTORY);
    }

    public String getLegacyDatabaseUrlAppend() {
        return this.getProperty(DATABASE_URL_APPEND);
    }

    public String getDatabaseUrl() {
        return this.getProperty(DATABASE_URL);
    }

    public String getDatabaseDriverClassName() {
        return this.getProperty(DATABASE_DRIVER_CLASS_NAME);
    }

    public String getDatabaseDriverDirectory() {
        return this.getProperty(DATABASE_DRIVER_DIR);
    }

    public String getDatabaseUsername() {
        return this.getProperty(DATABASE_USERNAME);
    }

    public String getDatabasePassword() {
        return this.getProperty(DATABASE_PASSWORD);
    }

    public Integer getDatabaseMaxConnections() {
        return this.getPropertyAsInteger(DATABASE_MAX_CONNECTIONS);
    }

    public boolean getDatabaseSqlDebug() {
        String value = this.getProperty(DATABASE_SQL_DEBUG);
        if (StringUtils.isBlank((CharSequence)value)) {
            return false;
        }
        return DEFAULT_WEB_SHOULD_SEND_SERVER_VERSION.equalsIgnoreCase(value.trim());
    }

    public File getAuthorizersConfigurationFile() {
        return this.getPropertyAsFile(SECURITY_AUTHORIZERS_CONFIGURATION_FILE, DEFAULT_SECURITY_AUTHORIZERS_CONFIGURATION_FILE);
    }

    public File getIdentityProviderConfigurationFile() {
        return this.getPropertyAsFile(SECURITY_IDENTITY_PROVIDERS_CONFIGURATION_FILE, DEFAULT_SECURITY_IDENTITY_PROVIDER_CONFIGURATION_FILE);
    }

    public File getKerberosConfigurationFile() {
        return this.getPropertyAsFile(KERBEROS_KRB5_FILE);
    }

    public String getKerberosSpnegoAuthenticationExpiration() {
        return this.getProperty(KERBEROS_SPNEGO_AUTHENTICATION_EXPIRATION, DEFAULT_AUTHENTICATION_EXPIRATION);
    }

    public String getKerberosSpnegoPrincipal() {
        return this.getPropertyAsTrimmedString(KERBEROS_SPNEGO_PRINCIPAL);
    }

    public String getKerberosSpnegoKeytabLocation() {
        return this.getPropertyAsTrimmedString(KERBEROS_SPNEGO_KEYTAB_LOCATION);
    }

    public boolean isKerberosSpnegoSupportEnabled() {
        return !StringUtils.isBlank((CharSequence)this.getKerberosSpnegoPrincipal()) && !StringUtils.isBlank((CharSequence)this.getKerberosSpnegoKeytabLocation());
    }

    public String getKerberosServicePrincipal() {
        return this.getPropertyAsTrimmedString(KERBEROS_SERVICE_PRINCIPAL);
    }

    public String getKerberosServiceKeytabLocation() {
        return this.getPropertyAsTrimmedString(KERBEROS_SERVICE_KEYTAB_LOCATION);
    }

    public Set<String> getExtensionsDirs() {
        HashSet<String> extensionDirs = new HashSet<String>();
        this.getPropertyKeys().stream().filter(key -> key.startsWith(EXTENSION_DIR_PREFIX)).forEach(key -> extensionDirs.add(this.getProperty((String)key)));
        return extensionDirs;
    }

    public boolean areRevisionsEnabled() {
        return Boolean.parseBoolean(this.getPropertyAsTrimmedString(REVISIONS_ENABLED));
    }

    private String getPropertyAsTrimmedString(String key) {
        String value = this.getProperty(key);
        if (!StringUtils.isBlank((CharSequence)value)) {
            return value.trim();
        }
        return null;
    }

    private Integer getPropertyAsInteger(String key) {
        String value = this.getProperty(key);
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException(String.format("%s must be an integer value.", key));
        }
    }

    private File getPropertyAsFile(String key) {
        String filePath = this.getProperty(key);
        if (filePath != null && filePath.trim().length() > 0) {
            return new File(filePath.trim());
        }
        return null;
    }

    private File getPropertyAsFile(String propertyKey, String defaultFileLocation) {
        String value = this.getProperty(propertyKey);
        if (StringUtils.isBlank((CharSequence)value)) {
            return new File(defaultFileLocation);
        }
        return new File(value);
    }

    public boolean isLoginIdentityProviderEnabled() {
        return !StringUtils.isBlank((CharSequence)this.getProperty(SECURITY_IDENTITY_PROVIDER));
    }

    public boolean isOidcEnabled() {
        return !StringUtils.isBlank((CharSequence)this.getOidcDiscoveryUrl());
    }

    public String getOidcDiscoveryUrl() {
        return this.getProperty(SECURITY_USER_OIDC_DISCOVERY_URL);
    }

    public String getOidcConnectTimeout() {
        return this.getProperty(SECURITY_USER_OIDC_CONNECT_TIMEOUT, "5 secs");
    }

    public String getOidcReadTimeout() {
        return this.getProperty(SECURITY_USER_OIDC_READ_TIMEOUT, "5 secs");
    }

    public String getOidcClientId() {
        return this.getProperty(SECURITY_USER_OIDC_CLIENT_ID);
    }

    public String getOidcClientSecret() {
        return this.getProperty(SECURITY_USER_OIDC_CLIENT_SECRET);
    }

    public String getOidcPreferredJwsAlgorithm() {
        return this.getProperty(SECURITY_USER_OIDC_PREFERRED_JWSALGORITHM);
    }

    public List<String> getOidcAdditionalScopes() {
        String rawProperty = this.getProperty(SECURITY_USER_OIDC_ADDITIONAL_SCOPES, "");
        if (rawProperty.isEmpty()) {
            return new ArrayList<String>();
        }
        List<String> additionalScopes = Arrays.asList(rawProperty.split(","));
        return additionalScopes.stream().map(String::trim).collect(Collectors.toList());
    }

    public String getOidcClaimIdentifyingUser() {
        return this.getProperty(SECURITY_USER_OIDC_CLAIM_IDENTIFYING_USER, "email").trim();
    }
}

