/*
 * Decompiled with CFR 0.152.
 */
package com.azure.security.keyvault.keys.cryptography.implementation;

import com.azure.core.util.CoreUtils;
import com.azure.security.keyvault.keys.cryptography.implementation.Asn1DerSignatureEncoding;
import com.azure.security.keyvault.keys.cryptography.implementation.Ecdsa;

final class SignatureEncoding {
    private SignatureEncoding() {
    }

    static byte[] fromAsn1Der(byte[] asn1DerSignature, Ecdsa algorithm) {
        try {
            return Asn1DerSignatureEncoding.decode(asn1DerSignature, algorithm);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage() + " " + CoreUtils.bytesToHexString((byte[])asn1DerSignature), ex);
        }
    }

    static byte[] toAsn1Der(byte[] signature, Ecdsa algorithm) {
        try {
            return Asn1DerSignatureEncoding.encode(signature, algorithm);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage() + " " + CoreUtils.bytesToHexString((byte[])signature), ex);
        }
    }
}

