/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.registry.db;

import com.zaxxer.hikari.HikariDataSource;
import java.io.File;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.h2.database.migration.H2DatabaseUpdater;
import org.apache.nifi.registry.properties.NiFiRegistryProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration
public class DataSourceFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataSourceFactory.class);
    private final NiFiRegistryProperties properties;
    private DataSource dataSource;

    @Autowired
    public DataSourceFactory(NiFiRegistryProperties properties) {
        this.properties = properties;
    }

    @Bean
    @Primary
    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.createDataSource();
        }
        return this.dataSource;
    }

    private DataSource createDataSource() {
        String databaseUrl = this.properties.getDatabaseUrl();
        if (StringUtils.isBlank((CharSequence)databaseUrl)) {
            throw new IllegalStateException("nifi.registry.db.url is required");
        }
        String databaseDriver = this.properties.getDatabaseDriverClassName();
        if (StringUtils.isBlank((CharSequence)databaseDriver)) {
            throw new IllegalStateException("nifi.registry.db.driver.class is required");
        }
        String databaseUsername = this.properties.getDatabaseUsername();
        if (StringUtils.isBlank((CharSequence)databaseUsername)) {
            throw new IllegalStateException("nifi.registry.db.username is required");
        }
        String databasePassword = this.properties.getDatabasePassword();
        if (StringUtils.isBlank((CharSequence)databasePassword)) {
            throw new IllegalStateException("nifi.registry.db.password is required");
        }
        DataSource dataSource = DataSourceBuilder.create().url(databaseUrl).driverClassName(databaseDriver).username(databaseUsername).password(databasePassword).build();
        if (dataSource instanceof HikariDataSource) {
            LOGGER.info("Setting maximum pool size on HikariDataSource to {}", (Object)this.properties.getDatabaseMaxConnections());
            ((HikariDataSource)dataSource).setMaximumPoolSize(this.properties.getDatabaseMaxConnections().intValue());
        }
        if (databaseUrl.startsWith("jdbc:h2:")) {
            File databaseFile = this.getFileFromH2URL(databaseUrl);
            String migrationDbUrl = "jdbc:h2:" + databaseFile + ";LOCK_MODE=3";
            try {
                H2DatabaseUpdater.checkAndPerformMigration((String)databaseFile.getAbsolutePath(), (String)migrationDbUrl, (String)databaseUsername, (String)databasePassword);
            }
            catch (Exception e) {
                throw new RuntimeException("H2 database migration failed", e);
            }
        }
        return dataSource;
    }

    private File getFileFromH2URL(String databaseUrl) {
        String dbPath = databaseUrl.substring("jdbc:h2:".length(), databaseUrl.indexOf(";"));
        return new File(dbPath);
    }
}

