/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.controller;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.cluster.coordination.ClusterCoordinator;
import org.apache.nifi.cluster.coordination.node.NodeWorkload;
import org.apache.nifi.cluster.protocol.NodeIdentifier;
import org.apache.nifi.remote.cluster.ClusterNodeInformation;
import org.apache.nifi.remote.cluster.NodeInformant;
import org.apache.nifi.remote.cluster.NodeInformation;

public class ClusterCoordinatorNodeInformant
implements NodeInformant {
    private final ClusterCoordinator clusterCoordinator;

    public ClusterCoordinatorNodeInformant(ClusterCoordinator coordinator) {
        this.clusterCoordinator = coordinator;
    }

    public ClusterNodeInformation getNodeInformation() {
        List nodeInfoCollection;
        try {
            nodeInfoCollection = this.clusterCoordinator.getClusterWorkload().entrySet().stream().map(entry -> {
                NodeIdentifier nodeId = (NodeIdentifier)entry.getKey();
                NodeInformation nodeInfo = new NodeInformation(nodeId.getSiteToSiteAddress(), nodeId.getSiteToSitePort(), nodeId.getSiteToSiteHttpApiPort(), nodeId.getApiPort(), nodeId.isSiteToSiteSecure(), ((NodeWorkload)entry.getValue()).getFlowFileCount());
                return nodeInfo;
            }).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to retrieve cluster workload due to " + e, e);
        }
        ClusterNodeInformation nodeInfo = new ClusterNodeInformation();
        nodeInfo.setNodeInformation(nodeInfoCollection);
        return nodeInfo;
    }
}

